/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.sourcecontrols;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Modification;
import net.sourceforge.cruisecontrol.SourceControl;
import net.sourceforge.cruisecontrol.sourcecontrols.BuildStatus;
import net.sourceforge.cruisecontrol.sourcecontrols.Triggers;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Veto
implements SourceControl {
    private static final Logger LOG = Logger.getLogger(Veto.class);
    private Triggers triggers;
    private BuildStatus buildStatus;

    @Override
    public List<Modification> getModifications(Date lastBuild, Date now) {
        List<Modification> triggerMods = this.triggers.getModifications(lastBuild, now);
        if (triggerMods.isEmpty()) {
            return Collections.emptyList();
        }
        List<Modification> buildStatusMods = this.buildStatus.getModifications(lastBuild, now);
        if (buildStatusMods.isEmpty()) {
            throw new OutOfDateException("trigger changes with no buildstatus changes");
        }
        Modification latestBuildStatusMod = this.getLatestModification(buildStatusMods);
        if (!this.getNewerModifications(triggerMods, latestBuildStatusMod).isEmpty()) {
            throw new OutOfDateException("buildstatus out of date compared to trigger changes");
        }
        return Collections.emptyList();
    }

    private Modification getLatestModification(List<Modification> mods) {
        Modification latest = null;
        for (Modification mod : mods) {
            if (latest != null && !mod.modifiedTime.after(latest.modifiedTime)) continue;
            latest = mod;
        }
        return latest;
    }

    private List getNewerModifications(List<Modification> mods, Modification buildStatusMod) {
        ArrayList<Modification> newerMods = new ArrayList<Modification>();
        LOG.debug((Object)("Comparing all trigger mods against buildStatusMod with date [" + buildStatusMod.modifiedTime + "]"));
        for (Modification mod : mods) {
            if (!mod.modifiedTime.after(buildStatusMod.modifiedTime)) continue;
            newerMods.add(mod);
            LOG.debug((Object)("Newer file : " + mod.getFullPath() + " at [" + mod.modifiedTime + "]"));
        }
        if (!newerMods.isEmpty()) {
            LOG.info((Object)("Found " + newerMods.size() + " modifications since last build status."));
        }
        return newerMods;
    }

    @Override
    public Map<String, String> getProperties() {
        return Collections.emptyMap();
    }

    @Override
    public void validate() throws CruiseControlException {
        if (this.triggers == null) {
            throw new CruiseControlException("veto requires nested triggers element");
        }
        this.triggers.validate();
        if (this.buildStatus == null) {
            throw new CruiseControlException("veto requires a nested buildstatus element");
        }
        this.buildStatus.validate();
    }

    public Triggers createTriggers() throws CruiseControlException {
        if (this.triggers != null) {
            throw new CruiseControlException("only one nested triggers allowed");
        }
        this.triggers = new Triggers(this);
        return this.triggers;
    }

    public BuildStatus createBuildStatus() throws CruiseControlException {
        if (this.buildStatus != null) {
            throw new CruiseControlException("only one nested buildstatus allowed");
        }
        this.buildStatus = this.getBuildStatus();
        return this.buildStatus;
    }

    protected BuildStatus getBuildStatus() {
        return new BuildStatus();
    }

    private class OutOfDateException
    extends RuntimeException {
        public OutOfDateException(String string) {
            super(string);
        }
    }
}

