/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.sourcecontrols;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Modification;
import net.sourceforge.cruisecontrol.SourceControl;
import net.sourceforge.cruisecontrol.sourcecontrols.SourceControlProperties;
import net.sourceforge.cruisecontrol.util.Commandline;
import net.sourceforge.cruisecontrol.util.CommandlineUtil;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UCM
implements SourceControl {
    private static final Logger LOG = Logger.getLogger(UCM.class);
    private String stream;
    private String viewPath;
    private boolean multiVob;
    private boolean contributors = true;
    private boolean rebases = false;
    private final SourceControlProperties properties = new SourceControlProperties();
    private final SimpleDateFormat inputDateFormat = new SimpleDateFormat("dd-MMMM-yyyy.HH:mm:ss");
    private final SimpleDateFormat outputDateFormat = new SimpleDateFormat("yyyyMMdd.HHmmss");
    private String pvob;
    static final String DELIMITER = "#~#";
    static final String END_OF_STRING_DELIMITER = "@#@#@#@#@#@#@#@#@#@#@#@";

    public Map getProperties() {
        return this.properties.getPropertiesAndReset();
    }

    @Override
    public void validate() throws CruiseControlException {
        ValidationHelper.assertIsSet((Object)this.stream, "stream", this.getClass());
        ValidationHelper.assertIsSet((Object)this.viewPath, "viewpath", this.getClass());
        if (this.isRebases()) {
            ValidationHelper.assertIsSet((Object)this.pvob, "pvob", this.getClass());
        }
    }

    public String getStream() {
        return this.stream;
    }

    public void setStream(String stream) {
        this.stream = stream;
    }

    public String getViewPath() {
        return this.viewPath;
    }

    public void setViewPath(String viewPath) {
        this.viewPath = viewPath;
    }

    public boolean isMultiVob() {
        return this.multiVob;
    }

    public void setMultiVob(boolean multiVob) {
        this.multiVob = multiVob;
    }

    public void setPvob(String pvob) {
        this.pvob = pvob;
    }

    public String getPvob() {
        return this.pvob;
    }

    public boolean isRebases() {
        return this.rebases;
    }

    public void setRebases(boolean rebases) {
        this.rebases = rebases;
    }

    public boolean isContributors() {
        return this.contributors;
    }

    public void setContributors(boolean contributors) {
        this.contributors = contributors;
    }

    public void setProperty(String property) {
        this.properties.assignPropertyName(property);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getModifications(Date lastBuild, Date now) {
        String lastBuildDate = this.inputDateFormat.format(lastBuild);
        String nowDate = this.inputDateFormat.format(now);
        this.properties.put("ucmlastbuild", lastBuildDate);
        this.properties.put("ucmnow", nowDate);
        List<Object> mods = new ArrayList();
        try {
            HashMap<String, String> activityNames = this.collectActivitiesSinceLastBuild(lastBuildDate);
            if (activityNames.size() == 0) {
                return mods;
            }
            mods = this.describeAllActivities(activityNames);
        }
        catch (Exception e) {
            LOG.error((Object)"Command failed to execute succesfully", (Throwable)e);
        }
        if (this.isRebases()) {
            try {
                Commandline commandline = this.buildDetectRebasesCommand(lastBuildDate);
                commandline.setWorkingDirectory(this.viewPath);
                InputStream cmdStream = CommandlineUtil.streamOutput(commandline);
                try {
                    mods.addAll(this.parseRebases(cmdStream));
                }
                finally {
                    cmdStream.close();
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Error in executing the Clear Case command : ", (Throwable)e);
            }
        }
        if (!mods.isEmpty()) {
            this.properties.modificationFound();
        }
        return mods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap<String, String> collectActivitiesSinceLastBuild(String lastBuildDate) {
        LOG.debug((Object)("Last build time was: " + lastBuildDate));
        HashMap<String, String> activityMap = new HashMap<String, String>();
        Commandline commandLine = this.buildListStreamCommand(lastBuildDate);
        LOG.debug((Object)("Executing: " + commandLine));
        try {
            commandLine.setWorkingDirectory(this.viewPath);
            InputStream cmdStream = CommandlineUtil.streamOutput(commandLine);
            InputStreamReader isr = new InputStreamReader(cmdStream);
            BufferedReader br = new BufferedReader(isr);
            try {
                String line = br.readLine();
                while (line != null && !line.equals("")) {
                    String[] details = this.getDetails(line);
                    if (!(details[0].equals("mkbranch") || details[0].equals("rmbranch") || details[0].equals("rmver"))) {
                        String activityName = details[1];
                        String activityDate = details[2];
                        if (!activityMap.containsKey(activityName)) {
                            LOG.debug((Object)("Found activity name: " + activityName + "; date: " + activityDate));
                            activityMap.put(activityName, activityDate);
                        }
                    }
                    line = br.readLine();
                }
            }
            finally {
                br.close();
                cmdStream.close();
            }
        }
        catch (IOException e) {
            LOG.error((Object)"IO Error executing ClearCase lshistory command", (Throwable)e);
        }
        catch (CruiseControlException e) {
            LOG.error((Object)"Interrupt Error executing ClearCase lshistory command", (Throwable)e);
        }
        return activityMap;
    }

    private String[] getDetails(String line) {
        ArrayList<String> details = new ArrayList<String>();
        String delimiter = "~#~";
        int startIndex = 0;
        int index = 0;
        while (index != -1) {
            index = line.indexOf(delimiter, startIndex);
            String detail = index == -1 ? line.substring(startIndex, line.length()) : line.substring(startIndex, index);
            details.add(detail);
            startIndex = index + delimiter.length();
        }
        return details.toArray(new String[details.size()]);
    }

    public Commandline buildListStreamCommand(String lastBuildDate) {
        Commandline commandLine = new Commandline();
        if (this.isMultiVob()) {
            try {
                commandLine.setWorkingDirectory(this.getViewPath());
            }
            catch (CruiseControlException e) {
                LOG.error((Object)"Error in setting workdirectory", (Throwable)e);
            }
        }
        commandLine.setExecutable("cleartool");
        commandLine.createArgument("lshistory");
        commandLine.createArguments("-branch", this.getStream());
        if (this.isMultiVob()) {
            commandLine.createArgument("-avobs");
        } else {
            commandLine.createArgument("-r");
        }
        commandLine.createArgument("-nco");
        commandLine.createArguments("-since", lastBuildDate);
        commandLine.createArguments("-fmt", "%o~#~%[activity]Xp~#~%Nd\n");
        if (!this.isMultiVob()) {
            commandLine.createArgument(this.getViewPath());
        }
        return commandLine;
    }

    private List<Modification> describeAllActivities(HashMap<String, String> activityNames) {
        ArrayList<Modification> activityList = new ArrayList<Modification>();
        for (Map.Entry<String, String> activity : activityNames.entrySet()) {
            String activityID = activity.getKey();
            String activityDate = activity.getValue();
            UCMModification activityMod = this.describeActivity(activityID, activityDate);
            activityList.add(activityMod);
            if (!activityMod.comment.startsWith("deliver ") || !this.isContributors()) continue;
            List<String> contribList = this.describeContributors(activityID);
            Iterator<String> contribIter = contribList.iterator();
            while (contribIter.hasNext()) {
                String contribName = activity.toString();
                UCMModification contribMod = this.describeActivity(contribName, activityDate);
                contribMod.type = "contributor";
                LOG.debug((Object)("Found contributor name: " + contribName + "; date: " + activityDate));
                activityList.add(contribMod);
            }
        }
        return activityList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UCMModification describeActivity(String activityID, String activityDate) {
        UCMModification mod = new UCMModification();
        Commandline commandLine = this.buildDescribeActivityCommand(activityID);
        LOG.debug((Object)("Executing: " + commandLine));
        try {
            commandLine.setWorkingDirectory(this.viewPath);
            InputStream cmdStream = CommandlineUtil.streamOutput(commandLine);
            InputStreamReader isr = new InputStreamReader(cmdStream);
            BufferedReader br = new BufferedReader(isr);
            try {
                String line = br.readLine();
                while (line != null && !line.equals("")) {
                    String[] details = this.getDetails(line);
                    try {
                        mod.modifiedTime = this.outputDateFormat.parse(activityDate);
                    }
                    catch (ParseException e) {
                        LOG.error((Object)"Error parsing modification date");
                        mod.modifiedTime = new Date();
                    }
                    mod.type = "activity";
                    mod.revision = details[0].equals("") ? details[3] : details[0];
                    mod.crmtype = details[1];
                    mod.userName = details[2];
                    mod.comment = details[3];
                    line = br.readLine();
                }
            }
            finally {
                br.close();
                cmdStream.close();
            }
        }
        catch (IOException e) {
            LOG.error((Object)"IO Error executing ClearCase describe command", (Throwable)e);
        }
        catch (CruiseControlException e) {
            LOG.error((Object)"Interrupt error executing ClearCase describe command", (Throwable)e);
        }
        return mod;
    }

    public Commandline buildDescribeActivityCommand(String activityID) {
        Commandline commandLine = new Commandline();
        commandLine.setExecutable("cleartool");
        commandLine.createArgument("describe");
        commandLine.createArguments("-fmt", "%[crm_record_id]p~#~%[crm_record_type]p~#~%u~#~%[headline]p~#~");
        commandLine.createArgument(activityID);
        return commandLine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> describeContributors(String activityName) {
        ArrayList<String> contribList = new ArrayList<String>();
        Commandline commandLine = this.buildListContributorsCommand(activityName);
        LOG.debug((Object)("Executing: " + commandLine));
        try {
            commandLine.setWorkingDirectory(this.viewPath);
            InputStream cmdStream = CommandlineUtil.streamOutput(commandLine);
            InputStreamReader isr = new InputStreamReader(cmdStream);
            BufferedReader br = new BufferedReader(isr);
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    String[] contribs = this.splitOnSpace(line);
                    contribList.addAll(Arrays.asList(contribs));
                }
            }
            finally {
                br.close();
                cmdStream.close();
            }
        }
        catch (IOException e) {
            LOG.error((Object)"IO Error executing ClearCase describe contributors command", (Throwable)e);
        }
        catch (CruiseControlException e) {
            LOG.error((Object)"Interrupt Error executing ClearCase describe contributors command", (Throwable)e);
        }
        return contribList;
    }

    private String[] splitOnSpace(String string) {
        return string.split(" ");
    }

    public Commandline buildListContributorsCommand(String activityID) {
        Commandline commandLine = new Commandline();
        commandLine.setExecutable("cleartool");
        commandLine.createArgument("describe");
        commandLine.createArguments("-fmt", "%[contrib_acts]Xp");
        commandLine.createArgument(activityID);
        return commandLine;
    }

    protected Commandline buildDetectRebasesCommand(String lastBuildDate) {
        Commandline commandLine = new Commandline();
        commandLine.setExecutable("cleartool");
        commandLine.createArgument().setValue("lshistory");
        commandLine.createArgument().setValue("-since");
        commandLine.createArgument().setValue(lastBuildDate);
        commandLine.createArgument().setValue("-minor");
        commandLine.createArgument().setValue("-fmt");
        String format = "%u#~#%Nd#~#%o#~#%Nc@#@#@#@#@#@#@#@#@#@#@#@\\n";
        commandLine.createArgument().setValue("%u#~#%Nd#~#%o#~#%Nc@#@#@#@#@#@#@#@#@#@#@#@\\n");
        commandLine.createArgument().setValue("stream:" + this.stream + "@" + this.pvob);
        return commandLine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Modification> parseRebases(InputStream input) throws IOException {
        ArrayList<Modification> modifications = new ArrayList<Modification>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(input));
        try {
            String line;
            String ls = System.getProperty("line.separator");
            StringBuffer lines = new StringBuffer();
            while ((line = reader.readLine()) != null) {
                if (lines.length() != 0) {
                    lines.append(ls);
                }
                lines.append(line);
                Modification mod = null;
                if (lines.indexOf(END_OF_STRING_DELIMITER) > -1) {
                    mod = this.parseRebaseEntry(lines.substring(0, lines.indexOf(END_OF_STRING_DELIMITER)));
                    lines = new StringBuffer();
                }
                if (mod == null) continue;
                modifications.add(mod);
            }
        }
        finally {
            reader.close();
        }
        return modifications;
    }

    Modification parseRebaseEntry(String line) {
        LOG.debug((Object)("parsing entry: " + line));
        String[] tokens = this.tokenizeEntry(line);
        if (tokens == null) {
            return null;
        }
        String username = tokens[0].trim();
        String timeStamp = tokens[1].trim();
        String operationType = tokens[2].trim();
        String comment = tokens[3].trim();
        Modification mod = null;
        if (operationType.equals("mkhlink") || operationType.equals("rmhlink")) {
            mod = new Modification();
            String linkName = this.parseLinkName(comment);
            if (!linkName.startsWith("UseBaseline")) {
                return null;
            }
            Hyperlink link = this.getHyperlink(linkName);
            StringBuffer modComment = new StringBuffer();
            mod.type = "ucmdependency";
            if (operationType.equals("mkhlink")) {
                modComment.append("Added dependency");
            } else {
                modComment.append("Removed dependency");
            }
            if (link.getFrom().length() > 0) {
                modComment.append(" of ");
                modComment.append(link.getFrom());
            }
            if (link.getTo().length() > 0) {
                modComment.append(" on ");
                modComment.append(link.getTo());
                mod.revision = link.getTo();
            } else {
                mod.revision = "";
            }
            mod.comment = modComment.toString();
            mod.userName = username;
            try {
                mod.modifiedTime = this.outputDateFormat.parse(timeStamp);
            }
            catch (ParseException e) {
                LOG.error((Object)"Error parsing modification date", (Throwable)e);
                mod.modifiedTime = new Date();
            }
            this.properties.modificationFound();
        }
        return mod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Hyperlink getHyperlink(String linkName) {
        Commandline commandline = this.buildGetHyperlinkCommandline(linkName);
        try {
            commandline.setWorkingDirectory(this.viewPath);
            InputStream cmdStream = CommandlineUtil.streamOutput(commandline);
            Hyperlink link = null;
            try {
                link = this.parseHyperlinkDescription(cmdStream);
            }
            finally {
                cmdStream.close();
            }
            return link;
        }
        catch (Exception e) {
            LOG.error((Object)"Error in executing the Clear Case command : ", (Throwable)e);
            return new Hyperlink();
        }
    }

    protected Commandline buildGetHyperlinkCommandline(String linkName) {
        Commandline commandline = new Commandline();
        commandline.setExecutable("cleartool");
        commandline.createArgument().setValue("describe");
        commandline.createArgument().setValue("hlink:" + linkName + "@" + this.pvob);
        return commandline;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Hyperlink parseHyperlinkDescription(InputStream input) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(input));
        try {
            String lastLine = "";
            String line = reader.readLine();
            while (line != null) {
                lastLine = line;
                line = reader.readLine();
            }
            Hyperlink link = new Hyperlink();
            StringTokenizer tokens = new StringTokenizer(lastLine, " ");
            if (!tokens.hasMoreTokens()) {
                Hyperlink hyperlink = link;
                return hyperlink;
            }
            tokens.nextToken();
            if (!tokens.hasMoreTokens()) {
                Hyperlink hyperlink = link;
                return hyperlink;
            }
            link.setFrom(tokens.nextToken());
            if (!tokens.hasMoreTokens()) {
                Hyperlink hyperlink = link;
                return hyperlink;
            }
            tokens.nextToken();
            if (!tokens.hasMoreTokens()) {
                Hyperlink hyperlink = link;
                return hyperlink;
            }
            link.setTo(tokens.nextToken());
            Hyperlink hyperlink = link;
            return hyperlink;
        }
        finally {
            reader.close();
        }
    }

    String parseLinkName(String comment) {
        StringTokenizer tokens = new StringTokenizer(comment, " \"");
        String link = "";
        String token = "";
        while (tokens.hasMoreTokens()) {
            link = token;
            token = tokens.nextToken();
        }
        int index = link.lastIndexOf(64);
        if (index != -1) {
            return link.substring(0, link.lastIndexOf(64));
        }
        return link;
    }

    private String[] tokenizeEntry(String line) {
        int maxTokens = 4;
        int minTokens = maxTokens - 1;
        Object[] tokens = new String[maxTokens];
        Arrays.fill(tokens, "");
        int tokenIndex = 0;
        int oldIndex = 0;
        int i = line.indexOf(DELIMITER, 0);
        while (true) {
            if (tokenIndex > maxTokens) {
                LOG.debug((Object)"Too many tokens; skipping entry");
                return null;
            }
            if (i == -1) break;
            tokens[tokenIndex] = line.substring(oldIndex, i);
            oldIndex = i + DELIMITER.length();
            i = line.indexOf(DELIMITER, oldIndex);
            ++tokenIndex;
        }
        tokens[tokenIndex] = line.substring(oldIndex);
        if (tokenIndex < minTokens) {
            LOG.debug((Object)"Not enough tokens; skipping entry");
            return null;
        }
        return tokens;
    }

    private static class UCMModification
    extends Modification {
        private static final String TAGNAME_CRMTYPE = "crmtype";
        public String crmtype;

        public int compareTo(Object o) {
            UCMModification modification = (UCMModification)o;
            return this.getActivitityNumber() - modification.getActivitityNumber();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof UCMModification)) {
                return false;
            }
            UCMModification modification = (UCMModification)o;
            return this.getActivitityNumber() == modification.getActivitityNumber();
        }

        public int hashCode() {
            return this.getActivitityNumber();
        }

        private int getActivitityNumber() {
            return Integer.parseInt(this.revision);
        }

        UCMModification() {
            super("ucm");
        }

        public Element toElement() {
            Element modificationElement = super.toElement();
            Element crmtypeElement = new Element(TAGNAME_CRMTYPE);
            crmtypeElement.addContent(this.crmtype);
            modificationElement.addContent((Content)crmtypeElement);
            return modificationElement;
        }
    }

    class Hyperlink {
        private String from = "";
        private String to = "";

        Hyperlink() {
        }

        public String getFrom() {
            return this.from;
        }

        public void setFrom(String from) {
            this.from = from;
        }

        public String getTo() {
            return this.to;
        }

        public void setTo(String to) {
            this.to = to;
        }
    }
}

