/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.sourcecontrols;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Modification;
import net.sourceforge.cruisecontrol.sourcecontrols.FakeUserSourceControl;
import net.sourceforge.cruisecontrol.util.DateUtil;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeBuild
extends FakeUserSourceControl {
    private static final Logger LOG = Logger.getLogger(TimeBuild.class);
    private int time = -1;

    public void setTime(String timeString) {
        this.time = Integer.parseInt(timeString);
    }

    @Override
    public void validate() throws CruiseControlException {
        ValidationHelper.assertFalse(this.time == -1, "the 'time' attribute is mandatory");
    }

    @Override
    public List<Modification> getModifications(Date lastBuild, Date now) {
        LOG.debug((Object)("LastBuild:" + lastBuild + ", now:" + now));
        ArrayList<Modification> modifications = new ArrayList<Modification>();
        int lastBuildTime = DateUtil.getTimeFromDate(lastBuild);
        int nowTime = DateUtil.getTimeFromDate(now);
        if (this.onSameDay(lastBuild, now)) {
            if (lastBuildTime < this.time && this.time < nowTime) {
                modifications.add(this.getMod(now));
            }
        } else if (nowTime > this.time || lastBuildTime < this.time || this.moreThanOneDay(lastBuild, now)) {
            modifications.add(this.getMod(now));
        }
        if (!modifications.isEmpty()) {
            this.getSourceControlProperties().modificationFound();
        }
        return modifications;
    }

    private boolean moreThanOneDay(Date lastBuild, Date now) {
        Calendar lastBuildCal = Calendar.getInstance();
        lastBuildCal.setTime(lastBuild);
        Calendar nowCal = Calendar.getInstance();
        nowCal.setTime(now);
        lastBuildCal.add(5, 1);
        return lastBuildCal.before(nowCal);
    }

    private boolean onSameDay(Date date1, Date date2) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date1);
        int day1 = calendar.get(5);
        calendar.setTime(date2);
        int day2 = calendar.get(5);
        return day1 == day2;
    }

    private Modification getMod(Date now) {
        Modification mod = new Modification("always");
        Modification.ModifiedFile modfile = mod.createModifiedFile("time build", "time build");
        modfile.action = "change";
        mod.userName = this.getUserName();
        Calendar nowTimeBuild = Calendar.getInstance();
        nowTimeBuild.setTime(now);
        int modifHour = this.time / 100;
        int modifMinute = this.time - modifHour * 100;
        nowTimeBuild.set(11, modifHour);
        nowTimeBuild.set(12, modifMinute);
        nowTimeBuild.set(14, 0);
        mod.modifiedTime = nowTimeBuild.getTime();
        mod.comment = "";
        return mod;
    }

    public String toString() {
        return this.getUserName() + ", " + this.time;
    }
}

