/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.sourcecontrols;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Modification;
import net.sourceforge.cruisecontrol.SourceControl;
import net.sourceforge.cruisecontrol.sourcecontrols.SourceControlProperties;
import net.sourceforge.cruisecontrol.util.Commandline;
import net.sourceforge.cruisecontrol.util.StreamLogger;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import org.apache.log4j.Logger;

public class TeamFoundationServer
implements SourceControl {
    private static final Logger LOG = Logger.getLogger(TeamFoundationServer.class);
    private static final String TFS_UTC_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private String server;
    private String projectPath;
    private String username;
    private String password;
    private String tfPath = "tf";
    private String options;
    private String inputEncoding = "UTF-8";
    private String profile;
    private final SourceControlProperties properties = new SourceControlProperties();

    public List getModifications(Date lastBuild, Date now) {
        List modifications = new ArrayList();
        Commandline command = this.buildHistoryCommand(lastBuild, now);
        try {
            modifications = this.execHistoryCommand(command, lastBuild);
        }
        catch (Exception e) {
            LOG.error((Object)("Error executing tf history command " + command), (Throwable)e);
        }
        this.fillPropertiesIfNeeded(modifications);
        return modifications;
    }

    void fillPropertiesIfNeeded(List modifications) {
        if (!modifications.isEmpty()) {
            this.properties.modificationFound();
            int maxChangset = 0;
            for (int i = 0; i < modifications.size(); ++i) {
                Modification modification = (Modification)modifications.get(i);
                maxChangset = Math.max(maxChangset, Integer.parseInt(modification.revision));
                Modification.ModifiedFile file = modification.files.get(0);
                if (!file.action.equals("delete")) continue;
                this.properties.deletionFound();
                break;
            }
            this.properties.put("tfschangeset", "" + maxChangset);
        }
    }

    Commandline buildHistoryCommand(Date lastBuild, Date now) {
        Commandline command = new Commandline();
        command.setExecutable(this.tfPath);
        command.createArgument().setValue("history");
        command.createArgument().setValue("-noprompt");
        if (this.server != null) {
            command.createArgument().setValue("-server:" + this.server);
        }
        if (this.profile != null) {
            command.createArgument().setValue("-profile:" + this.profile);
        }
        command.createArgument().setValue(this.projectPath);
        command.createArgument().setValue("-version:D" + TeamFoundationServer.formatUTCDate(lastBuild) + "~D" + TeamFoundationServer.formatUTCDate(now));
        command.createArgument().setValue("-recursive");
        command.createArgument().setValue("-format:detailed");
        if (this.username != null && this.password != null) {
            command.createArgument().setValue("-login:" + this.username + "," + this.password + "");
        }
        if (this.options != null) {
            command.createArgument().setValue(this.options);
        }
        LOG.debug((Object)("Executing command: " + command));
        return command;
    }

    private List execHistoryCommand(Commandline command, Date lastBuild) throws InterruptedException, IOException, ParseException {
        Process p = command.execute();
        this.logErrorStream(p);
        InputStream svnStream = p.getInputStream();
        List modifications = this.parseStream(svnStream, lastBuild);
        p.waitFor();
        p.getInputStream().close();
        p.getOutputStream().close();
        p.getErrorStream().close();
        return modifications;
    }

    private void logErrorStream(Process p) {
        Thread stderr = new Thread(StreamLogger.getWarnPumper(LOG, p.getErrorStream()));
        stderr.start();
    }

    private List parseStream(InputStream tfStream, Date lastBuild) throws IOException, ParseException {
        InputStreamReader reader = new InputStreamReader(tfStream, this.inputEncoding);
        return TFHistoryParser.parse(reader, lastBuild);
    }

    static String formatUTCDate(Date date) {
        SimpleDateFormat f = new SimpleDateFormat(TFS_UTC_DATE_FORMAT);
        f.setTimeZone(TimeZone.getTimeZone("GMT"));
        return f.format(date);
    }

    public Map getProperties() {
        return this.properties.getPropertiesAndReset();
    }

    public void validate() throws CruiseControlException {
        ValidationHelper.assertFalse(this.profile == null && this.server == null, "One of the attributes 'server' or 'profile' should be set");
        ValidationHelper.assertFalse(this.profile != null && this.server != null, "The combination of the attributes 'server' or 'profile' is prohibited");
        ValidationHelper.assertIsSet((Object)this.projectPath, "projectPath", this.getClass());
        ValidationHelper.assertTrue(this.projectPath.startsWith("$/"), "A TFS server path must begin with $/");
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setProjectPath(String projectPath) {
        this.projectPath = projectPath;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setTfPath(String tfPath) {
        this.tfPath = tfPath;
    }

    public void setOptions(String options) {
        this.options = options;
    }

    public void setInputEncoding(String inputEncoding) {
        this.inputEncoding = inputEncoding;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    static final class TFHistoryParser {
        private static final String CHANGESET_SEPERATOR = "---------------------------------";
        private static final Pattern PATTERN_CHANGESET = Pattern.compile("^[^:]*:[ \t]([0-9]*)\n[^:]*:[ \t](.*)\n[^:]*:[ \t](.*)\n[^:]*:((?:\n.*)*)\n\n[^\n :]*:(?=\n  )((?:\n[ \t]+.*)*)");
        private static final Pattern PATTERN_ITEM = Pattern.compile("\n  ([^$]+) (\\$/.*)");

        private TFHistoryParser() {
        }

        static List parse(Reader reader, Date lastBuild) throws IOException, ParseException {
            String line;
            ArrayList modifications = new ArrayList();
            StringBuffer buffer = new StringBuffer();
            BufferedReader br = new BufferedReader(reader);
            int linecount = 0;
            while ((line = br.readLine()) != null) {
                ++linecount;
                if (line.startsWith(CHANGESET_SEPERATOR)) {
                    if (linecount <= 1) continue;
                    modifications.addAll(TFHistoryParser.parseChangeset(buffer.toString(), lastBuild));
                    buffer.setLength(0);
                    continue;
                }
                buffer.append(line).append('\n');
            }
            modifications.addAll(TFHistoryParser.parseChangeset(buffer.toString(), lastBuild));
            return modifications;
        }

        static ArrayList parseChangeset(String data, Date lastBuild) throws ParseException {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Parsing Changeset Data:\n" + data));
            }
            ArrayList<Modification> modifications = new ArrayList<Modification>();
            Matcher m = PATTERN_CHANGESET.matcher(data);
            if (m.find()) {
                String revision = m.group(1);
                String userName = m.group(2);
                Date modifiedTime = TFHistoryParser.parseDate(m.group(3));
                if (modifiedTime.compareTo(lastBuild) < 0) {
                    return new ArrayList();
                }
                String comment = m.group(4).replaceAll("\n  ", "\n");
                if (comment.length() > 0) {
                    comment = comment.trim();
                }
                Matcher itemMatcher = PATTERN_ITEM.matcher(m.group(5));
                int items = 0;
                while (itemMatcher.find()) {
                    ++items;
                    Modification modification = new Modification("tfs");
                    modification.revision = revision;
                    modification.userName = userName;
                    modification.modifiedTime = modifiedTime;
                    modification.comment = comment;
                    Modification.ModifiedFile modfile = modification.createModifiedFile(itemMatcher.group(2), null);
                    if (!modfile.fileName.startsWith("$/")) {
                        throw new ParseException("Parse error. Mistakenly identified \"" + modfile.fileName + "\" as an item, but it does not appear to " + "be a valid TFS path.  Please report this as a bug.  Changeset" + "data = \"\n" + data + "\n\".", itemMatcher.start());
                    }
                    modfile.action = itemMatcher.group(1).trim();
                    modfile.revision = modification.revision;
                    modifications.add(modification);
                }
                if (items < 1) {
                    throw new ParseException("Parse error. Unable to find an item within a changeset.  Please report this as a bug.  Changesetdata = \"\n" + data + "\n\".", 0);
                }
            }
            return modifications;
        }

        protected static Date parseDate(String dateString) throws ParseException {
            Date date = null;
            try {
                date = new Date(Date.parse(dateString));
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            if (date == null) {
                DateFormat[] formats = TFHistoryParser.createDateFormatsForLocaleAndTimeZone(null, null);
                return TFHistoryParser.parseWithFormats(dateString, formats);
            }
            return date;
        }

        private static Date parseWithFormats(String input, DateFormat[] formats) throws ParseException {
            ParseException parseException = null;
            for (int i = 0; i < formats.length; ++i) {
                try {
                    return formats[i].parse(input);
                }
                catch (ParseException ex) {
                    parseException = ex;
                    continue;
                }
            }
            throw parseException;
        }

        private static DateFormat[] createDateFormatsForLocaleAndTimeZone(Locale locale, TimeZone timeZone) {
            int dateStyle;
            if (locale == null) {
                locale = Locale.getDefault();
            }
            if (timeZone == null) {
                timeZone = TimeZone.getDefault();
            }
            ArrayList<DateFormat> formats = new ArrayList<DateFormat>();
            for (dateStyle = 0; dateStyle <= 3; ++dateStyle) {
                for (int timeStyle = 0; timeStyle <= 3; ++timeStyle) {
                    DateFormat df = DateFormat.getDateTimeInstance(dateStyle, timeStyle, locale);
                    if (timeZone != null) {
                        df.setTimeZone(timeZone);
                    }
                    formats.add(df);
                }
            }
            for (dateStyle = 0; dateStyle <= 3; ++dateStyle) {
                DateFormat df = DateFormat.getDateInstance(dateStyle, locale);
                df.setTimeZone(timeZone);
                formats.add(df);
            }
            return formats.toArray(new DateFormat[formats.size()]);
        }
    }
}

