/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.sourcecontrols;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Modification;
import net.sourceforge.cruisecontrol.SourceControl;
import net.sourceforge.cruisecontrol.sourcecontrols.SourceControlProperties;
import net.sourceforge.cruisecontrol.util.Commandline;
import net.sourceforge.cruisecontrol.util.IO;
import net.sourceforge.cruisecontrol.util.StreamLogger;
import net.sourceforge.cruisecontrol.util.Util;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class SVN
implements SourceControl {
    private static final long serialVersionUID = -144583234813298598L;
    private static final Logger LOG = Logger.getLogger(SVN.class);
    private static final String SVN_DATE_FORMAT_IN = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final String SVN_DATE_FORMAT_OUT = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    private final SourceControlProperties properties = new SourceControlProperties();
    private String repositoryLocation;
    private String localWorkingCopy;
    private String userName;
    private String password;
    private String configDir;
    private boolean checkExternals = false;
    private boolean useLocalRevision = false;

    public Map getProperties() {
        return this.properties.getPropertiesAndReset();
    }

    public void setProperty(String property) {
        this.properties.assignPropertyName(property);
    }

    public void setPropertyOnDelete(String propertyOnDelete) {
        this.properties.assignPropertyOnDeleteName(propertyOnDelete);
    }

    public void setConfigDir(String configDir) {
        this.configDir = configDir;
    }

    public void setCheckExternals(boolean value) {
        this.checkExternals = value;
    }

    public void setRepositoryLocation(String repositoryLocation) {
        this.repositoryLocation = repositoryLocation;
    }

    public void setLocalWorkingCopy(String localWorkingCopy) {
        this.localWorkingCopy = localWorkingCopy;
    }

    public void setUsername(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void validate() throws CruiseControlException {
        ValidationHelper.assertTrue(this.repositoryLocation != null || this.localWorkingCopy != null, "At least 'repositoryLocation'or 'localWorkingCopy' is a required attribute on the Subversion task ");
        if (this.localWorkingCopy != null) {
            File workingDir = new File(this.localWorkingCopy);
            ValidationHelper.assertTrue(workingDir.exists() && workingDir.isDirectory(), "'localWorkingCopy' must be an existing directory. Was " + workingDir.getAbsolutePath());
        }
    }

    public List getModifications(Date lastBuild, Date now) {
        String path;
        Commandline command2;
        HashMap directories = new HashMap();
        Commandline propCommand = new Commandline();
        if (this.checkExternals) {
            try {
                propCommand = this.buildPropgetCommand();
            }
            catch (CruiseControlException e) {
                LOG.error((Object)"Error building history command", (Throwable)e);
            }
            try {
                directories = SVN.execPropgetCommand(propCommand);
            }
            catch (Exception e) {
                LOG.error((Object)("Error executing svn propget command " + propCommand), (Throwable)e);
            }
        }
        ArrayList modifications = new ArrayList();
        HashMap<Commandline, String> commandsAndPaths = new HashMap<Commandline, String>();
        try {
            String startRevision = SVN.formatSVNDate(lastBuild);
            String endRevision = this.useLocalRevision ? this.execInfoCommand(this.buildInfoCommand(null)) : SVN.formatSVNDate(now);
            command2 = this.buildHistoryCommand(startRevision, endRevision);
            commandsAndPaths.put(command2, null);
            for (String directory : directories.keySet()) {
                endRevision = this.useLocalRevision ? this.execInfoCommand(this.buildInfoCommand(directory)) : SVN.formatSVNDate(now);
                ArrayList externals = (ArrayList)directories.get(directory);
                for (String[] external : externals) {
                    path = directory + "/" + external[0];
                    String svnURL = external[1];
                    if (this.repositoryLocation != null) {
                        command2 = this.buildHistoryCommand(startRevision, endRevision, svnURL);
                        commandsAndPaths.put(command2, null);
                        continue;
                    }
                    command2 = this.buildHistoryCommand(startRevision, endRevision, svnURL);
                    commandsAndPaths.put(command2, path);
                }
            }
        }
        catch (CruiseControlException e) {
            LOG.error((Object)"Error building history command", (Throwable)e);
            return modifications;
        }
        try {
            for (Commandline command2 : commandsAndPaths.keySet()) {
                path = (String)commandsAndPaths.get(command2);
                modifications.addAll(SVN.execHistoryCommand(command2, lastBuild, path));
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Error executing svn log command " + command2), (Throwable)e);
        }
        this.fillPropertiesIfNeeded(modifications);
        return modifications;
    }

    Commandline buildPropgetCommand() throws CruiseControlException {
        Commandline command = new Commandline();
        command.setExecutable("svn");
        if (this.localWorkingCopy != null) {
            command.setWorkingDirectory(this.localWorkingCopy);
        }
        command.createArgument("propget");
        command.createArgument("-R");
        command.createArgument("--non-interactive");
        command.createArgument("svn:externals");
        if (this.repositoryLocation != null) {
            command.createArgument(this.repositoryLocation);
        }
        LOG.debug((Object)("Executing command: " + command));
        return command;
    }

    Commandline buildInfoCommand(String path) throws CruiseControlException {
        Commandline command = new Commandline();
        command.setExecutable("svn");
        if (this.localWorkingCopy != null) {
            command.setWorkingDirectory(this.localWorkingCopy);
        }
        command.createArgument("info");
        command.createArgument("--xml");
        if (path != null) {
            command.createArgument(path);
        }
        LOG.debug((Object)("Executing command: " + command));
        return command;
    }

    Commandline buildHistoryCommand(String lastBuild, String checkTime) throws CruiseControlException {
        return this.buildHistoryCommand(lastBuild, checkTime, null);
    }

    Commandline buildHistoryCommand(String lastBuild, String checkTime, String path) throws CruiseControlException {
        Commandline command = new Commandline();
        command.setExecutable("svn");
        if (this.localWorkingCopy != null) {
            command.setWorkingDirectory(this.localWorkingCopy);
        }
        command.createArgument("log");
        command.createArgument("--non-interactive");
        command.createArgument("--xml");
        command.createArgument("-v");
        command.createArgument("-r");
        command.createArgument(lastBuild + ":" + checkTime);
        if (this.configDir != null) {
            command.createArguments("--config-dir", this.configDir);
        }
        if (this.userName != null || this.password != null) {
            command.createArgument("--no-auth-cache");
            if (this.userName != null) {
                command.createArguments("--username", this.userName);
            }
            if (this.password != null) {
                command.createArguments("--password", this.password);
            }
        }
        if (path != null) {
            command.createArgument(path);
        } else if (this.repositoryLocation != null) {
            command.createArgument(this.repositoryLocation);
        }
        LOG.debug((Object)("Executing command: " + command));
        return command;
    }

    static String formatSVNDate(Date date) {
        return SVN.formatSVNDate(date, Util.isWindows());
    }

    static String formatSVNDate(Date lastBuild, boolean isWindows) {
        SimpleDateFormat f = new SimpleDateFormat(SVN_DATE_FORMAT_IN);
        f.setTimeZone(TimeZone.getTimeZone("GMT"));
        String dateStr = f.format(lastBuild);
        if (isWindows) {
            return "\"{" + dateStr + "}\"";
        }
        return "{" + dateStr + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashMap execPropgetCommand(Commandline command) throws InterruptedException, IOException {
        Process p = command.execute();
        Thread stderr = SVN.logErrorStream(p);
        BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream(), "UTF8"));
        HashMap directories = new HashMap();
        try {
            SVN.parsePropgetReader(reader, directories);
            p.waitFor();
            stderr.join();
        }
        finally {
            reader.close();
            IO.close(p);
        }
        return directories;
    }

    static void parsePropgetReader(BufferedReader reader, HashMap directories) throws IOException {
        String line;
        String currentDir = null;
        while ((line = reader.readLine()) != null) {
            String[] split = line.split(" - ");
            if (split.length > 1) {
                currentDir = split[0];
                directories.put(currentDir, new ArrayList());
                line = split[1];
            }
            if ((split = line.split("\\s"))[0].equals("")) continue;
            ArrayList externals = (ArrayList)directories.get(currentDir);
            externals.add(split);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List execHistoryCommand(Commandline command, Date lastBuild, String externalPath) throws InterruptedException, IOException, ParseException, JDOMException {
        List modifications;
        Process p = command.execute();
        Thread stderr = SVN.logErrorStream(p);
        InputStreamReader reader = new InputStreamReader(p.getInputStream(), "UTF-8");
        try {
            modifications = SVNLogXMLParser.parseAndFilter(reader, lastBuild, externalPath);
            p.waitFor();
            stderr.join();
        }
        finally {
            reader.close();
            IO.close(p);
        }
        return modifications;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String execInfoCommand(Commandline command) throws CruiseControlException {
        try {
            String revision;
            Process p = command.execute();
            Thread stderr = SVN.logErrorStream(p);
            InputStream svnStream = p.getInputStream();
            InputStreamReader reader = new InputStreamReader(svnStream, "UTF-8");
            try {
                revision = SVNInfoXMLParser.parse(reader);
                p.waitFor();
                stderr.join();
            }
            finally {
                reader.close();
                IO.close(p);
            }
            return revision;
        }
        catch (IOException e) {
            throw new CruiseControlException(e);
        }
        catch (JDOMException e) {
            throw new CruiseControlException(e);
        }
        catch (InterruptedException e) {
            throw new CruiseControlException(e);
        }
    }

    private static Thread logErrorStream(Process p) {
        Thread stderr = new Thread(StreamLogger.getWarnPumper(LOG, p.getErrorStream()));
        stderr.start();
        return stderr;
    }

    void fillPropertiesIfNeeded(List modifications) {
        if (!modifications.isEmpty()) {
            this.properties.modificationFound();
            int maxRevision = 0;
            for (int i = 0; i < modifications.size(); ++i) {
                Modification modification = (Modification)modifications.get(i);
                maxRevision = Math.max(maxRevision, Integer.parseInt(modification.revision));
                Modification.ModifiedFile file = modification.files.get(0);
                if (!file.action.equals("deleted")) continue;
                this.properties.deletionFound();
            }
            this.properties.put("svnrevision", "" + maxRevision);
        }
    }

    public static DateFormat getOutDateFormatter() {
        SimpleDateFormat f = new SimpleDateFormat(SVN_DATE_FORMAT_OUT);
        f.setTimeZone(TimeZone.getTimeZone("GMT"));
        return f;
    }

    public void setUseLocalRevision(boolean useLocalRevision) {
        this.useLocalRevision = useLocalRevision;
    }

    static final class SVNInfoXMLParser {
        private SVNInfoXMLParser() {
        }

        public static String parse(Reader reader) throws JDOMException, IOException {
            SAXBuilder builder = new SAXBuilder(false);
            Document document = builder.build(reader);
            return document.getRootElement().getChild("entry").getAttribute("revision").getValue();
        }
    }

    static final class SVNLogXMLParser {
        private SVNLogXMLParser() {
        }

        static List parseAndFilter(Reader reader, Date lastBuild) throws ParseException, JDOMException, IOException {
            return SVNLogXMLParser.parseAndFilter(reader, lastBuild, null);
        }

        static List parseAndFilter(Reader reader, Date lastBuild, String externalPath) throws ParseException, JDOMException, IOException {
            Modification[] modifications = SVNLogXMLParser.parse(reader, externalPath);
            return SVNLogXMLParser.filterModifications(modifications, lastBuild);
        }

        static Modification[] parse(Reader reader) throws ParseException, JDOMException, IOException {
            return SVNLogXMLParser.parse(reader, null);
        }

        static Modification[] parse(Reader reader, String externalPath) throws ParseException, JDOMException, IOException {
            SAXBuilder builder = new SAXBuilder(false);
            Document document = builder.build(reader);
            return SVNLogXMLParser.parseDOMTree(document, externalPath);
        }

        static Modification[] parseDOMTree(Document document, String externalPath) throws ParseException {
            ArrayList<Modification> modifications = new ArrayList<Modification>();
            Element rootElement = document.getRootElement();
            List logEntries = rootElement.getChildren("logentry");
            for (Element logEntry : logEntries) {
                Modification[] modificationsOfRevision = SVNLogXMLParser.parseLogEntry(logEntry, externalPath);
                modifications.addAll(Arrays.asList(modificationsOfRevision));
            }
            return modifications.toArray(new Modification[modifications.size()]);
        }

        static Modification[] parseLogEntry(Element logEntry, String externalPath) throws ParseException {
            ArrayList<Modification> modifications = new ArrayList<Modification>();
            Element logEntryPaths = logEntry.getChild("paths");
            if (logEntryPaths != null) {
                List paths = logEntryPaths.getChildren("path");
                for (Element path : paths) {
                    Modification modification = new Modification("svn");
                    modification.modifiedTime = SVNLogXMLParser.convertDate(logEntry.getChildText("date"));
                    modification.userName = logEntry.getChildText("author");
                    modification.comment = logEntry.getChildText("msg");
                    modification.revision = logEntry.getAttributeValue("revision");
                    Modification.ModifiedFile modfile = modification.createModifiedFile(path.getText(), null);
                    if (externalPath != null) {
                        modfile.fileName = "/" + externalPath + ":" + modfile.fileName;
                    }
                    modfile.action = SVNLogXMLParser.convertAction(path.getAttributeValue("action"));
                    modfile.revision = modification.revision;
                    modifications.add(modification);
                }
            }
            return modifications.toArray(new Modification[modifications.size()]);
        }

        static Date convertDate(String date) throws ParseException {
            int zIndex = date.indexOf(90);
            if (zIndex - 3 < 0) {
                throw new ParseException(date + " doesn't match the expected subversion date format", date.length());
            }
            String withoutMicroSeconds = date.substring(0, zIndex - 3);
            return SVN.getOutDateFormatter().parse(withoutMicroSeconds);
        }

        static String convertAction(String action) {
            if (action.equals("A")) {
                return "added";
            }
            if (action.equals("M")) {
                return "modified";
            }
            if (action.equals("D")) {
                return "deleted";
            }
            return "unknown";
        }

        static List filterModifications(Modification[] modifications, Date lastBuild) {
            ArrayList<Modification> filtered = new ArrayList<Modification>();
            for (int i = 0; i < modifications.length; ++i) {
                Modification modification = modifications[i];
                if (modification.modifiedTime.getTime() <= lastBuild.getTime()) continue;
                filtered.add(modification);
            }
            return filtered;
        }
    }
}

