/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.sourcecontrols;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Modification;
import net.sourceforge.cruisecontrol.SourceControl;
import net.sourceforge.cruisecontrol.sourcecontrols.SourceControlProperties;
import net.sourceforge.cruisecontrol.util.Commandline;
import net.sourceforge.cruisecontrol.util.IO;
import net.sourceforge.cruisecontrol.util.StreamLogger;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mercurial
implements SourceControl {
    static final DateFormat HG_DATE_PARSER = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
    private static final Logger LOG = Logger.getLogger(Mercurial.class);
    private final SourceControlProperties properties = new SourceControlProperties();
    private String localWorkingCopy = ".";
    private String hgCommand = "incoming";
    private static final String INCOMING_CMD = "incoming";
    private static final String LOG_CMD = "log";
    static final String MODIFICATION_XML_TEMPLATE = "<hgChange>\n\t<author>{author|escape}</author>\n\t<rev>{rev}</rev>\n\t<node>{node}</node>\n\t<description>{desc|escape}</description>\n\t<date>{date|hgdate}</date>\n\t<addedFiles>{file_adds}</addedFiles>\n\t<removedFiles>{file_dels}</removedFiles>\n\t<changedFiles>{files}</changedFiles>\n</hgChange>\n";

    @Override
    public Map<String, String> getProperties() {
        return this.properties.getPropertiesAndReset();
    }

    public void setProperty(String property) {
        this.properties.assignPropertyName(property);
    }

    public void setPropertyOnDelete(String propertyOnDelete) {
        this.properties.assignPropertyOnDeleteName(propertyOnDelete);
    }

    public void setLocalWorkingCopy(String localWorkingCopy) {
        this.localWorkingCopy = localWorkingCopy;
    }

    public void setHgCommand(String hgCommand) {
        this.hgCommand = hgCommand;
    }

    @Override
    public void validate() throws CruiseControlException {
        File workingDir = new File(this.localWorkingCopy);
        ValidationHelper.assertTrue(workingDir.exists() && workingDir.isDirectory(), "'localWorkingCopy' must be an existing directory. Was " + workingDir.getAbsolutePath());
        ValidationHelper.assertTrue(INCOMING_CMD.equals(this.hgCommand) || LOG_CMD.equals(this.hgCommand), "'hgCommand' must be either incoming or log");
    }

    @Override
    public List<Modification> getModifications(Date lastBuildDate, Date now) {
        String version = this.getMercurialVersion();
        LOG.info((Object)("Using Mercurial: '" + version + "'"));
        Commandline command = null;
        List<Modification> modifications = Collections.emptyList();
        try {
            command = this.buildHistoryCommand(lastBuildDate, now);
            modifications = Mercurial.execHistoryCommand(command);
        }
        catch (Exception e) {
            LOG.error((Object)("Error executing mercurial history command " + command), (Throwable)e);
        }
        this.fillPropertiesIfNeeded(modifications);
        return modifications;
    }

    private String getMercurialVersion() {
        Commandline command = null;
        try {
            command = this.buildVersionCommand();
            return this.execVersionCommand(command);
        }
        catch (Exception e) {
            LOG.error((Object)("Error executing mercurial version command " + command), (Throwable)e);
            return "version unresolved...";
        }
    }

    Commandline buildHistoryCommand(Date from, Date to) throws CruiseControlException {
        Commandline command = new Commandline();
        command.setWorkingDirectory(this.localWorkingCopy);
        command.setExecutable("hg");
        if (INCOMING_CMD.equals(this.hgCommand)) {
            this.usingIncomingToGetModifications(command);
        } else {
            this.usingLogToGetModifications(from, to, command);
        }
        return command;
    }

    private void usingIncomingToGetModifications(Commandline command) {
        command.createArgument(INCOMING_CMD);
        command.createArgument("--debug");
        command.createArgument("--template");
        command.createArgument(MODIFICATION_XML_TEMPLATE);
    }

    private void usingLogToGetModifications(Date from, Date to, Commandline command) {
        command.createArgument(LOG_CMD);
        command.createArgument("--debug");
        command.createArguments("--date", HG_DATE_PARSER.format(from) + " to " + HG_DATE_PARSER.format(to));
        command.createArguments("--template", MODIFICATION_XML_TEMPLATE);
        command.createArgument(new File(this.localWorkingCopy).getAbsolutePath());
    }

    private static List<Modification> execHistoryCommand(Commandline command) throws InterruptedException, IOException, ParseException, JDOMException {
        LOG.debug((Object)("Executing command: " + command));
        Process p = command.execute();
        Thread stderr = Mercurial.logErrorStream(p);
        InputStream commandOutputStream = p.getInputStream();
        List<Modification> modifications = Mercurial.parseStream(commandOutputStream);
        p.waitFor();
        stderr.join();
        IO.close(p);
        return modifications;
    }

    Commandline buildVersionCommand() throws CruiseControlException {
        Commandline command = new Commandline();
        command.setWorkingDirectory(this.localWorkingCopy);
        command.setExecutable("hg");
        command.createArgument("version");
        return command;
    }

    private String execVersionCommand(Commandline command) throws CruiseControlException {
        LOG.debug((Object)("Executing command: " + command));
        try {
            Process p = command.execute();
            Thread stderr = Mercurial.logErrorStream(p);
            InputStream svnStream = p.getInputStream();
            String revision = Mercurial.parseVersionStream(svnStream);
            p.waitFor();
            stderr.join();
            IO.close(p);
            return revision;
        }
        catch (IOException e) {
            throw new CruiseControlException(e);
        }
        catch (ParseException e) {
            throw new CruiseControlException(e);
        }
        catch (InterruptedException e) {
            throw new CruiseControlException(e);
        }
    }

    static String parseVersionStream(InputStream svnStream) throws ParseException, IOException {
        InputStreamReader reader = new InputStreamReader(svnStream, "UTF-8");
        return HgVersionParser.parse(reader);
    }

    private static Thread logErrorStream(Process p) {
        Thread stderr = new Thread(StreamLogger.getWarnPumper(LOG, p.getErrorStream()));
        stderr.start();
        return stderr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<Modification> parseStream(InputStream inputStream) throws JDOMException, IOException, ParseException {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        StringBuffer buffer = new StringBuffer();
        boolean startFound = false;
        while ((line = br.readLine()) != null) {
            if (!(startFound |= line.startsWith("<"))) continue;
            buffer.append(line).append("\n");
        }
        StringReader reader = new StringReader("<hgChanges>" + buffer.toString() + "</hgChanges>");
        try {
            List<Modification> list = HgLogParser.parse(reader);
            return list;
        }
        finally {
            ((Reader)reader).close();
        }
    }

    void fillPropertiesIfNeeded(List modifications) {
        if (!modifications.isEmpty()) {
            this.properties.modificationFound();
            String maxRevision = "";
            for (int i = 0; i < modifications.size(); ++i) {
                Modification modification = (Modification)modifications.get(i);
                Modification.ModifiedFile file = modification.files.get(0);
                if (i == modifications.size() - 1) {
                    maxRevision = modification.revision;
                }
                if (!file.action.equals("deleted")) continue;
                this.properties.deletionFound();
            }
            this.properties.put("hgrevision", maxRevision);
        }
    }

    static final class HgVersionParser {
        private HgVersionParser() {
        }

        public static String parse(Reader reader) throws ParseException, IOException {
            BufferedReader myReader = new BufferedReader(reader);
            String versionLine = myReader.readLine();
            if (versionLine == null) {
                throw new IllegalStateException("hg version returned nothing");
            }
            Pattern p = Pattern.compile("Mercurial Distributed SCM \\((.*)\\)");
            Matcher m = p.matcher(versionLine);
            if (!m.matches()) {
                throw new ParseException("HgVersionParser: no match of " + versionLine, 0);
            }
            return m.group(1);
        }
    }

    private static final class HgDateParser {
        private HgDateParser() {
        }

        private static Date parse(String date) throws ParseException {
            Pattern p = Pattern.compile("([0-9]*) (.*)");
            Matcher m = p.matcher(date);
            if (!m.matches()) {
                throw new ParseException("HgDateParser: no match of " + date, 0);
            }
            Calendar c = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            c.setTimeInMillis(Long.parseLong(m.group(1)) * 1000L);
            return c.getTime();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class HgLogParser {
        private HgLogParser() {
        }

        static List<Modification> parse(Reader reader) throws ParseException, JDOMException, IOException {
            SAXBuilder builder = new SAXBuilder(false);
            Document document = builder.build(reader);
            return HgLogParser.parseDOMTree(document);
        }

        static List<Modification> parseDOMTree(Document document) throws ParseException {
            ArrayList<Modification> modifications = new ArrayList<Modification>();
            Element rootElement = document.getRootElement();
            List logEntries = rootElement.getChildren("hgChange");
            for (Element logEntry : logEntries) {
                List<Modification> modificationsOfRevision = HgLogParser.parseLogEntry(logEntry);
                modifications.addAll(modificationsOfRevision);
            }
            return modifications;
        }

        static List<Modification> parseLogEntry(Element logEntry) throws ParseException {
            ArrayList<Modification> modifications = new ArrayList<Modification>();
            String userName = logEntry.getChildText("author");
            String revision = logEntry.getChildText("rev") + ":" + logEntry.getChildText("node");
            String comment = logEntry.getChildText("description");
            Date modifiedTime = HgLogParser.convertHgDate(logEntry.getChildText("date"));
            String[] addedFiles = HgLogParser.getFiles(logEntry.getChildText("addedFiles"));
            String[] removedFiles = HgLogParser.getFiles(logEntry.getChildText("removedFiles"));
            String[] changedFiles = HgLogParser.getFiles(logEntry.getChildText("changedFiles"));
            HgLogParser.addModifications(modifications, userName, revision, comment, modifiedTime, addedFiles, "added");
            HgLogParser.addModifications(modifications, userName, revision, comment, modifiedTime, changedFiles, "modified");
            HgLogParser.addModifications(modifications, userName, revision, comment, modifiedTime, removedFiles, "removed");
            return modifications;
        }

        private static void addModifications(List<Modification> modifications, String userName, String revision, String comment, Date modifiedTime, String[] files, String action) {
            for (int i = 0; i < files.length; ++i) {
                String filePath = files[i];
                HgLogParser.addModifications(modifications, userName, revision, comment, modifiedTime, filePath, action);
            }
        }

        private static void addModifications(List<Modification> modifications, String userName, String revision, String comment, Date modifiedTime, String filePath, String action) {
            Modification modification = new Modification("mercurial");
            modification.modifiedTime = modifiedTime;
            modification.userName = userName;
            modification.comment = comment;
            modification.revision = revision;
            Modification.ModifiedFile modfile = modification.createModifiedFile(filePath, null);
            modfile.action = action;
            modfile.revision = modification.revision;
            modifications.add(modification);
        }

        private static String[] getFiles(String childText) {
            if (childText.length() == 0) {
                return new String[0];
            }
            return childText.split(" ");
        }

        static Date convertHgDate(String date) throws ParseException {
            try {
                return HgDateParser.parse(date);
            }
            catch (IllegalArgumentException e) {
                ParseException parseException = new ParseException(e.getMessage(), 0);
                parseException.initCause(e);
                throw parseException;
            }
        }
    }
}

