/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.sourcecontrols;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Modification;
import net.sourceforge.cruisecontrol.SourceControl;
import net.sourceforge.cruisecontrol.sourcecontrols.SourceControlProperties;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import org.apache.log4j.Logger;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.cli.ConsoleDownloadMonitor;
import org.apache.maven.embedder.MavenEmbedder;
import org.apache.maven.embedder.MavenEmbedderConsoleLogger;
import org.apache.maven.embedder.MavenEmbedderException;
import org.apache.maven.embedder.MavenEmbedderLogger;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.wagon.events.TransferEvent;
import org.apache.maven.wagon.events.TransferListener;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;

public class Maven2SnapshotDependency
implements SourceControl {
    private static final Logger LOG = Logger.getLogger(Maven2SnapshotDependency.class);
    private final SourceControlProperties properties = new SourceControlProperties();
    private List modifications;
    private File pomFile;
    private String user;
    private File localRepoDir;
    static final String COMMENT_TIMESTAMP_CHANGE = " timestamp change detected: ";
    static final String COMMENT_MISSING_IN_LOCALREPO = " missing in local repo: ";

    public void setPomFile(String s) {
        this.pomFile = new File(s);
    }

    void setLocalRepository(String s) {
        this.localRepoDir = s != null ? new File(s) : null;
    }

    public void setUser(String s) {
        this.user = s;
    }

    public void setProperty(String property) {
        this.properties.assignPropertyName(property);
    }

    public Map getProperties() {
        return this.properties.getPropertiesAndReset();
    }

    public void validate() throws CruiseControlException {
        ValidationHelper.assertIsSet((Object)this.pomFile, "pomFile", this.getClass());
        ValidationHelper.assertTrue(this.pomFile.exists(), "Pom file '" + this.pomFile.getAbsolutePath() + "' does not exist.");
        ValidationHelper.assertFalse(this.pomFile.isDirectory(), "The directory '" + this.pomFile.getAbsolutePath() + "' cannot be used as the pomFile for Maven2SnapshotDependency.");
        if (this.localRepoDir != null) {
            ValidationHelper.assertTrue(this.localRepoDir.exists(), "Local Maven repository '" + this.localRepoDir.getAbsolutePath() + "' does not exist.");
            ValidationHelper.assertTrue(this.localRepoDir.isDirectory(), "Local Maven repository '" + this.localRepoDir.getAbsolutePath() + "' must be a directory.");
        }
    }

    public List getModifications(Date lastBuild, Date now) {
        this.modifications = new ArrayList();
        LOG.debug((Object)("Reading pom: " + this.pomFile.getAbsolutePath() + " with lastBuild: " + lastBuild));
        ArtifactInfo[] artifactsToCheck = this.getSnapshotInfos();
        for (int i = 0; i < artifactsToCheck.length; ++i) {
            this.checkFile(artifactsToCheck[i], lastBuild.getTime());
        }
        return this.modifications;
    }

    private void addRevision(File dependency, String changeType, String comment) {
        Modification newMod = new Modification("maven2");
        Modification.ModifiedFile modfile = newMod.createModifiedFile(dependency.getName(), dependency.getParent());
        modfile.action = changeType;
        newMod.userName = this.user;
        newMod.modifiedTime = new Date(dependency.lastModified());
        newMod.comment = comment;
        this.modifications.add(newMod);
        this.properties.modificationFound();
    }

    private static File getArtifactFilename(File localRepoBaseDir, Artifact artifact) {
        LOG.warn((Object)("We should not need this approach to finding artifact files. Artifact: " + artifact));
        StringBuffer fileName = new StringBuffer();
        fileName.append(localRepoBaseDir.getAbsolutePath());
        fileName.append('/');
        fileName.append(artifact.getGroupId().replace('.', '/'));
        fileName.append('/');
        String artifactId = artifact.getArtifactId();
        fileName.append(artifactId);
        fileName.append('/');
        String versionText = artifact.getVersion();
        fileName.append(versionText);
        fileName.append('/');
        fileName.append(artifactId);
        fileName.append('-');
        fileName.append(versionText);
        if (artifact.getClassifier() != null) {
            fileName.append('-');
            fileName.append(artifact.getClassifier());
        }
        fileName.append('.');
        String type = artifact.getType();
        fileName.append(type != null ? type : "jar");
        return new File(fileName.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArtifactInfo[] getSnapshotInfos() {
        MavenEmbedder embedder = this.getMvnEmbedder();
        try {
            MavenProject projectWithDependencies = Maven2SnapshotDependency.getProjectWithDependencies(embedder, this.pomFile);
            File localRepoBaseDir = new File(embedder.getLocalRepository().getBasedir());
            ArrayList artifactInfos = new ArrayList();
            Maven2SnapshotDependency.findParentSnapshotArtifacts(projectWithDependencies, artifactInfos, localRepoBaseDir, embedder, this.pomFile);
            Set snapshotArtifacts = projectWithDependencies != null ? Maven2SnapshotDependency.getSnaphotArtifacts(projectWithDependencies.getArtifacts()) : this.getSnapshotArtifactsManually(embedder);
            for (Artifact artifact : snapshotArtifacts) {
                Maven2SnapshotDependency.addArtifactInfo(artifactInfos, artifact, "dependency", localRepoBaseDir);
            }
            ArtifactInfo[] artifactInfoArray = artifactInfos.toArray(new ArtifactInfo[artifactInfos.size()]);
            return artifactInfoArray;
        }
        finally {
            try {
                embedder.stop();
            }
            catch (MavenEmbedderException e) {
                LOG.error((Object)"Failed to stop embedded maven2", (Throwable)e);
            }
        }
    }

    private static void findParentSnapshotArtifacts(MavenProject projectWithDependencies, List artifactInfos, File localRepoBaseDir, MavenEmbedder embedder, File pomFile) {
        block5: {
            block4: {
                if (projectWithDependencies == null) break block4;
                MavenProject currMvnProject = projectWithDependencies;
                Artifact parentArtifact = currMvnProject.getParentArtifact();
                while (parentArtifact != null && parentArtifact.isSnapshot()) {
                    Maven2SnapshotDependency.addArtifactInfo(artifactInfos, parentArtifact, "parent", localRepoBaseDir);
                    currMvnProject = currMvnProject.getParent();
                    parentArtifact = currMvnProject.getParentArtifact();
                }
                break block5;
            }
            MavenProject mavenProject = null;
            try {
                mavenProject = embedder.readProject(pomFile);
            }
            catch (ProjectBuildingException e) {
                LOG.error((Object)"Failed to read maven2 mavenProject", (Throwable)e);
            }
            if (mavenProject == null) break block5;
            MavenProject currMvnProject = mavenProject;
            Artifact artifact = currMvnProject.getParentArtifact();
            while (artifact != null && (artifact.getVersion().endsWith("SNAPSHOT") || artifact.isSnapshot())) {
                Maven2SnapshotDependency.addArtifactInfo(artifactInfos, artifact, "parent", localRepoBaseDir);
                Maven2SnapshotDependency.resolveArtifact(embedder, artifact, mavenProject, embedder.getLocalRepository());
                currMvnProject = currMvnProject.getParent();
                artifact = currMvnProject.getParentArtifact();
            }
        }
    }

    private static MavenProject getProjectWithDependencies(MavenEmbedder embedder, File pomFile) {
        MavenProject projectWithDependencies = null;
        try {
            ConsoleDownloadMonitor transferListener = new ConsoleDownloadMonitor(){

                public void transferProgress(TransferEvent transferEvent, byte[] buffer, int length) {
                }
            };
            projectWithDependencies = embedder.readProjectWithDependencies(pomFile, (TransferListener)transferListener);
        }
        catch (ProjectBuildingException e) {
            LOG.error((Object)"Failed to read maven2 projectWithDependencies", (Throwable)e);
        }
        catch (ArtifactResolutionException e) {
            LOG.warn((Object)"Failed to resolve artifact", (Throwable)e);
        }
        catch (ArtifactNotFoundException e) {
            LOG.warn((Object)"Couldn't find artifact", (Throwable)e);
        }
        return projectWithDependencies;
    }

    private static void resolveArtifact(MavenEmbedder embedder, Artifact artifact, MavenProject mavenProject, ArtifactRepository localRepo) {
        try {
            embedder.resolve(artifact, mavenProject.getPluginArtifactRepositories(), localRepo);
        }
        catch (ArtifactResolutionException e) {
            LOG.debug((Object)"Unresolved artifact", (Throwable)e);
        }
        catch (ArtifactNotFoundException e) {
            LOG.debug((Object)"Missing artifact", (Throwable)e);
        }
    }

    private static void addArtifactInfo(List artifactInfos, Artifact artifact, String artifactType, File localRepoBaseDir) {
        File file = artifact.getFile() == null ? Maven2SnapshotDependency.getArtifactFilename(localRepoBaseDir, artifact) : artifact.getFile();
        artifactInfos.add(new ArtifactInfo(artifact, artifactType, file));
    }

    private static Set getSnaphotArtifacts(Set artifacts) {
        HashSet<Artifact> retVal = new HashSet<Artifact>();
        for (Artifact artifact : artifacts) {
            LOG.debug((Object)("Examining artifact: " + artifact));
            if (!artifact.isSnapshot()) continue;
            retVal.add(artifact);
        }
        return retVal;
    }

    private Set getSnapshotArtifactsManually(MavenEmbedder embedder) {
        ArtifactRepository localRepo;
        MavenProject mavenProject;
        try {
            mavenProject = embedder.readProject(this.pomFile);
        }
        catch (ProjectBuildingException e) {
            LOG.error((Object)"Failed to read maven2 mavenProject", (Throwable)e);
            return new HashSet();
        }
        if (this.localRepoDir != null) {
            try {
                localRepo = embedder.createLocalRepository(this.localRepoDir);
            }
            catch (ComponentLookupException e) {
                LOG.error((Object)("Error setting maven2 local repo to: " + this.localRepoDir.getAbsolutePath()), (Throwable)e);
                throw new RuntimeException("Error setting maven2 local repo to: " + this.localRepoDir.getAbsolutePath() + "; " + e.getMessage());
            }
        } else {
            localRepo = embedder.getLocalRepository();
        }
        Set snapshotArtifacts = Maven2SnapshotDependency.getSnapshotDepsManually(embedder, mavenProject);
        for (Artifact artifact : snapshotArtifacts) {
            LOG.debug((Object)("Manually examining artifact: " + artifact));
            Maven2SnapshotDependency.resolveArtifact(embedder, artifact, mavenProject, localRepo);
        }
        return snapshotArtifacts;
    }

    private static Set getSnapshotDepsManually(MavenEmbedder mavenEmbedder, MavenProject mavenProject) {
        HashSet<Artifact> retVal = new HashSet<Artifact>();
        Model model = mavenProject.getModel();
        List depsList = model.getDependencies();
        LOG.debug((Object)("found dependencies manually: " + depsList.toString()));
        for (int i = 0; i < depsList.size(); ++i) {
            Dependency dep = (Dependency)depsList.get(i);
            if (!dep.getVersion().endsWith("SNAPSHOT")) continue;
            Artifact artifact = dep.getClassifier() != null ? mavenEmbedder.createArtifactWithClassifier(dep.getGroupId(), dep.getArtifactId(), dep.getVersion(), dep.getType(), dep.getClassifier()) : mavenEmbedder.createArtifact(dep.getGroupId(), dep.getArtifactId(), dep.getVersion(), dep.getScope(), dep.getType());
            if ("system".equals(artifact.getScope())) {
                artifact.setFile(new File(dep.getSystemPath(), artifact.getArtifactId() + "-" + artifact.getVersion() + (artifact.getClassifier() != null ? "-" + artifact.getClassifier() : "") + "." + artifact.getType()));
            }
            retVal.add(artifact);
        }
        return retVal;
    }

    private void checkFile(ArtifactInfo artifactInfo, long lastBuild) {
        File file = artifactInfo.localRepoFile;
        LOG.debug((Object)("Checking artifact: " + artifactInfo.getArtifact()));
        if (!file.isDirectory() && file.lastModified() > lastBuild) {
            this.addRevision(file, "change", artifactInfo.artifactType + COMMENT_TIMESTAMP_CHANGE + artifactInfo.getArtifact().getArtifactId());
        } else if (!file.isDirectory() && !file.exists()) {
            this.addRevision(file, "missing", artifactInfo.artifactType + COMMENT_MISSING_IN_LOCALREPO + artifactInfo.getArtifact().getArtifactId());
        }
    }

    private MavenEmbedder getMvnEmbedder() {
        MavenEmbedder mvnEmbedder = new MavenEmbedder();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        mvnEmbedder.setClassLoader(classLoader);
        mvnEmbedder.setLogger((MavenEmbedderLogger)new MavenEmbedderConsoleLogger());
        if (this.localRepoDir != null) {
            mvnEmbedder.setLocalRepositoryDirectory(this.localRepoDir);
            mvnEmbedder.setAlignWithUserInstallation(false);
        } else {
            mvnEmbedder.setAlignWithUserInstallation(true);
        }
        try {
            mvnEmbedder.start();
        }
        catch (MavenEmbedderException e) {
            LOG.error((Object)"Failed to start embedded maven2", (Throwable)e);
        }
        return mvnEmbedder;
    }

    static final class ArtifactInfo {
        static final String ART_TYPE_PARENT = "parent";
        static final String ART_TYPE_DEPENDENCY = "dependency";
        private final Artifact artifact;
        private final String artifactType;
        private final File localRepoFile;

        private ArtifactInfo(Artifact artifact, String artifactType, File localRepoFile) {
            this.artifact = artifact;
            this.artifactType = artifactType;
            this.localRepoFile = localRepoFile;
        }

        Artifact getArtifact() {
            return this.artifact;
        }

        String getArtifactType() {
            return this.artifactType;
        }

        File getLocalRepoFile() {
            return this.localRepoFile;
        }

        public String toString() {
            return this.artifact + "," + this.artifactType + "," + (this.localRepoFile != null ? this.localRepoFile.getAbsolutePath() : null);
        }
    }
}

