/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.sourcecontrols;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Modification;
import net.sourceforge.cruisecontrol.SourceControl;
import net.sourceforge.cruisecontrol.sourcecontrols.SourceControlProperties;
import net.sourceforge.cruisecontrol.util.Commandline;
import net.sourceforge.cruisecontrol.util.IO;
import net.sourceforge.cruisecontrol.util.StreamLogger;
import net.sourceforge.cruisecontrol.util.Util;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import org.apache.log4j.Logger;

public class Git
implements SourceControl {
    private static final Logger LOG = Logger.getLogger(Git.class);
    private static final Pattern COMMITPATTERN = Pattern.compile("commit ([0-9a-f]{40})");
    private static final Pattern AUTHORPATTERN = Pattern.compile("author (.*) <(.*)> ([0-9]*) [+-][0-9]{4}");
    private static final Pattern DIFFPATTERN = Pattern.compile("diff --git (a/.* b/.*)");
    private static final Pattern NEWFILEPATTERN = Pattern.compile("new file mode [0-7]{6}");
    private static final Pattern DELETEDFILEPATTERN = Pattern.compile("deleted file mode [0-7]{6}");
    private static final String NEWLINE = System.getProperty("line.separator");
    private final SourceControlProperties props = new SourceControlProperties();
    private String lwc;

    public Map getProperties() {
        return this.props.getPropertiesAndReset();
    }

    public void setProperty(String p) {
        this.props.assignPropertyName(p);
    }

    public void setPropertyOnDelete(String p) {
        this.props.assignPropertyOnDeleteName(p);
    }

    public void setLocalWorkingCopy(String d) {
        this.lwc = d;
    }

    public void validate() throws CruiseControlException {
        ValidationHelper.assertTrue(this.lwc != null, "'localWorkingCopy' is a required attribute on the Git task");
        File wd = new File(this.lwc);
        ValidationHelper.assertTrue(wd.exists() && wd.isDirectory(), "'localWorkingCopy' must be an existing directory. Was " + wd.getAbsolutePath());
    }

    public List getModifications(Date from, Date to) {
        ArrayList mods = new ArrayList();
        Commandline cmd = new Commandline();
        cmd.setExecutable("git");
        try {
            cmd.setWorkingDirectory(this.lwc);
        }
        catch (CruiseControlException e) {
            LOG.error((Object)"Error building history command", (Throwable)e);
            return mods;
        }
        cmd.createArgument("log");
        cmd.createArgument("-p");
        cmd.createArgument("--pretty=raw");
        cmd.createArgument(Git.gitRevision(from) + ".." + Git.gitRevision(to));
        LOG.debug((Object)("Executing command: " + cmd));
        try {
            Process p = cmd.execute();
            Thread stderr = new Thread(StreamLogger.getWarnPumper(LOG, p.getErrorStream()));
            stderr.start();
            Git.parseLog(new InputStreamReader(p.getInputStream(), "UTF-8"), mods, this.props);
            p.waitFor();
            stderr.join();
            IO.close(p);
        }
        catch (Exception e) {
            LOG.error((Object)("Error executing git log command " + cmd), (Throwable)e);
        }
        return mods;
    }

    static void parseLog(Reader grd, List mods, SourceControlProperties props) throws IOException {
        String l;
        BufferedReader rd = new BufferedReader(grd);
        boolean diffmode = false;
        Modification mod = null;
        while ((l = rd.readLine()) != null) {
            if (l.equals("")) {
                if (diffmode) {
                    diffmode = false;
                    continue;
                }
                mod.comment = "";
                while ((l = rd.readLine()) != null && !l.equals("")) {
                    mod.comment = mod.comment + l.substring(4) + NEWLINE;
                }
                continue;
            }
            Matcher matcher = COMMITPATTERN.matcher(l);
            if (matcher.matches()) {
                if (mod == null) {
                    props.put("gitcommitid", matcher.group(1));
                }
                mod = new Modification("git");
                mods.add(mod);
                props.modificationFound();
                continue;
            }
            matcher = AUTHORPATTERN.matcher(l);
            if (matcher.matches()) {
                mod.userName = matcher.group(1);
                mod.emailAddress = matcher.group(2);
                long dt = new Long(matcher.group(3));
                mod.revision = "" + dt;
                mod.modifiedTime = new Date(dt * 1000L);
                continue;
            }
            matcher = DIFFPATTERN.matcher(l);
            if (!matcher.matches()) continue;
            String m1 = matcher.group(1);
            Modification.ModifiedFile modfile = mod.createModifiedFile(m1.substring(m1.length() / 2 + 3), null);
            l = rd.readLine();
            if (DELETEDFILEPATTERN.matcher(l).matches()) {
                modfile.action = "deleted";
                props.deletionFound();
            } else {
                modfile.action = NEWFILEPATTERN.matcher(l).matches() ? "added" : "modified";
            }
            modfile.revision = mod.revision;
            diffmode = true;
        }
    }

    static String gitRevision(Date dt) {
        String dts = "@{ " + dt.getTime() / 1000L + "}";
        return Util.isWindows() ? "\"" + dts + "\"" : dts;
    }
}

