/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.sourcecontrols;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Modification;
import net.sourceforge.cruisecontrol.SourceControl;
import net.sourceforge.cruisecontrol.sourcecontrols.SourceControlProperties;
import net.sourceforge.cruisecontrol.util.Commandline;
import net.sourceforge.cruisecontrol.util.IO;
import net.sourceforge.cruisecontrol.util.StreamLogger;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Darcs
implements SourceControl {
    private static final long serialVersionUID = 7976081409836256093L;
    private static final Logger LOGGER = Logger.getLogger(Darcs.class);
    private static final DateFormat DARCS_DATE_FORMAT_IN = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private String workingDir;
    private String repositoryLocation;
    private final SourceControlProperties properties = new SourceControlProperties();

    public void setProperty(String property) {
        this.properties.assignPropertyName(property);
    }

    public void setPropertyOnDelete(String propertyOnDelete) {
        this.properties.assignPropertyOnDeleteName(propertyOnDelete);
    }

    public void setRepositoryLocation(String repositoryLocation) {
        this.repositoryLocation = repositoryLocation;
    }

    public void setWorkingDir(String workingDir) {
        this.workingDir = workingDir;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties.getPropertiesAndReset();
    }

    @Override
    public void validate() throws CruiseControlException {
        ValidationHelper.assertTrue(this.repositoryLocation != null || this.workingDir != null, "At least 'repositoryLocation'or 'workingDir' is a required attribute on the Darcs task ");
        if (this.workingDir != null) {
            File workingDirFile = new File(this.workingDir);
            ValidationHelper.assertTrue(workingDirFile.exists() && workingDirFile.isDirectory(), "'workingDir' must be an existing directory. Was " + workingDirFile.getAbsolutePath());
        }
    }

    @Override
    public List<Modification> getModifications(Date lastBuild, Date now) {
        try {
            Commandline command = this.buildChangesCommand(lastBuild, now);
            List<Modification> modifications = this.execChangesCommand(command);
            this.fillPropertiesIfNeeded(modifications);
            return modifications;
        }
        catch (Exception e) {
            LOGGER.error((Object)"Failed to execute darcs changes command", (Throwable)e);
            return Collections.emptyList();
        }
    }

    Commandline buildChangesCommand(Date lastBuild, Date checkTime) throws CruiseControlException {
        Commandline command = new Commandline();
        command.setExecutable("darcs");
        if (this.workingDir != null) {
            command.setWorkingDirectory(this.workingDir);
        }
        command.createArgument("changes");
        command.createArgument("--xml-output");
        command.createArgument("--match");
        command.createArgument("--matches");
        command.createArgument("date \"" + DARCS_DATE_FORMAT_IN.format(lastBuild) + "/" + DARCS_DATE_FORMAT_IN.format(checkTime) + "\"");
        LOGGER.debug((Object)("Executing command: " + command));
        return command;
    }

    private List<Modification> execChangesCommand(Commandline command) throws InterruptedException, IOException, ParseException, JDOMException {
        Process p = command.execute();
        Thread stderr = this.logErrorStream(p);
        InputStream darcsStream = p.getInputStream();
        List<Modification> modifications = this.parseStream(darcsStream);
        p.waitFor();
        stderr.join();
        IO.close(p);
        return modifications;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Modification> parseStream(InputStream darcsStream) throws ParseException, JDOMException, IOException {
        InputStreamReader reader = new InputStreamReader((InputStream)new BufferedInputStream(darcsStream), "UTF-8");
        try {
            List<Modification> list = DarcsXmlParser.parse(reader);
            return list;
        }
        finally {
            reader.close();
        }
    }

    private Thread logErrorStream(Process p) {
        Thread stderr = new Thread(StreamLogger.getWarnPumper(LOGGER, p.getErrorStream()));
        stderr.start();
        return stderr;
    }

    void fillPropertiesIfNeeded(List<Modification> modifications) {
        if (!modifications.isEmpty()) {
            this.properties.modificationFound();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class DarcsXmlParser {
        private static final DateFormat DARCS_DATE_FORMAT_OUT = new SimpleDateFormat("yyyyMMddHHmmss");

        private DarcsXmlParser() {
        }

        static List<Modification> parse(Reader reader) throws ParseException, JDOMException, IOException {
            SAXBuilder builder = new SAXBuilder(false);
            Document document = builder.build(reader);
            return DarcsXmlParser.parseDOMTree(document);
        }

        private static List<Modification> parseDOMTree(Document document) throws ParseException {
            ArrayList<Modification> modifications = new ArrayList<Modification>();
            Element rootElement = document.getRootElement();
            List patches = rootElement.getChildren("patch");
            if (patches != null) {
                for (Element patch : patches) {
                    modifications.add(DarcsXmlParser.parsePatch(patch));
                }
            }
            return modifications;
        }

        private static Modification parsePatch(Element patch) throws ParseException {
            Modification modification = new Modification("darcs");
            modification.modifiedTime = DARCS_DATE_FORMAT_OUT.parse(patch.getAttributeValue("date"));
            String email = patch.getAttributeValue("author");
            modification.userName = DarcsXmlParser.parseUser(email);
            modification.emailAddress = email;
            modification.comment = patch.getChildText("name");
            return modification;
        }

        private static String parseUser(String email) {
            return email.substring(0, email.indexOf(64));
        }
    }
}

