/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.sourcecontrols;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Modification;
import net.sourceforge.cruisecontrol.SourceControl;
import net.sourceforge.cruisecontrol.sourcecontrols.SourceControlProperties;
import net.sourceforge.cruisecontrol.sourcecontrols.Targets;
import net.sourceforge.cruisecontrol.sourcecontrols.Triggers;
import net.sourceforge.cruisecontrol.util.ValidationHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Compound
implements SourceControl {
    private final SourceControlProperties properties = new SourceControlProperties();
    private Triggers triggers = null;
    private Targets targets = null;
    private boolean includeTriggerChanges = false;

    public void setProperty(String propertyName) {
        this.properties.assignPropertyName(propertyName);
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties.getPropertiesAndReset();
    }

    @Override
    public List<Modification> getModifications(Date lastBuild, Date now) {
        ArrayList<Modification> targetMods = new ArrayList<Modification>();
        List<Modification> triggerMods = this.triggers.getModifications(lastBuild, now);
        if (!triggerMods.isEmpty()) {
            targetMods = this.targets.getModifications(lastBuild, now);
            this.properties.putAll(this.targets.getProperties());
        }
        if (this.includeTriggerChanges) {
            targetMods.addAll(triggerMods);
            this.properties.putAll(this.triggers.getProperties());
        }
        if (!targetMods.isEmpty()) {
            this.properties.modificationFound();
        }
        return targetMods;
    }

    @Override
    public void validate() throws CruiseControlException {
        ValidationHelper.assertTrue(this.triggers != null, "Error: there must be exactly one \"triggers\" block in a compound block.");
        ValidationHelper.assertTrue(this.targets != null, "Error: there must be exactly one \"targets\" block in a compound block.");
    }

    public Object createTriggers() {
        Triggers tr;
        this.triggers = tr = new Triggers(this);
        return tr;
    }

    public Object createTargets() {
        Targets targ;
        this.targets = targ = new Targets(this);
        return targ;
    }

    public void setIncludeTriggerChanges(String changes) {
        this.includeTriggerChanges = changes.equalsIgnoreCase("true");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Entry
    implements SourceControl {
        private final SourceControlProperties properties = new SourceControlProperties();
        private final List<SourceControl> sourceControls = new ArrayList<SourceControl>();
        private SourceControl parent;

        public Entry() {
        }

        public Entry(SourceControl parent) {
            this.parent = parent;
        }

        @Override
        public Map<String, String> getProperties() {
            return this.properties.getPropertiesAndReset();
        }

        @Override
        public List<Modification> getModifications(Date lastBuild, Date now) {
            ArrayList<Modification> retVal = new ArrayList<Modification>();
            for (SourceControl sourceControl : this.sourceControls) {
                retVal.addAll(sourceControl.getModifications(lastBuild, now));
                this.properties.putAll(sourceControl.getProperties());
            }
            return retVal;
        }

        @Override
        public void validate() throws CruiseControlException {
            if (this.sourceControls.isEmpty()) {
                throw new CruiseControlException("Error: there must be at least one source control in a " + this.getEntryName() + " block.");
            }
            if (this.parent == null) {
                throw new CruiseControlException("Error: " + this.getEntryName() + " blocks must be contained within compound blocks.");
            }
        }

        public void add(SourceControl sc) {
            this.sourceControls.add(sc);
        }

        private String getEntryName() {
            String classname = this.getClass().getName();
            int index = classname.lastIndexOf(46);
            if (index != -1) {
                return classname.substring(index + 1).toLowerCase();
            }
            return classname.toLowerCase();
        }
    }
}

