/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.sourcecontrols;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.sourceforge.cruisecontrol.Modification;
import org.apache.log4j.Logger;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.IllegalDataException;
import org.jdom.output.XMLOutputter;

public class CMSynergyModification
extends Modification {
    private static final Logger LOG = Logger.getLogger(CMSynergyModification.class);
    private static final String MODIFICATION_TYPE = "ccmtask";
    private static final String TAGNAME_MODIFICATION = "modification";
    private static final String TAGNAME_OBJECT = "ccmobject";
    private static final String TAGNAME_CHANGEREQUEST = "ccmcr";
    private static final String TAGNAME_NAME = "name";
    private static final String TAGNAME_TASKNUMBER = "task";
    private static final String TAGNAME_VERSION = "version";
    private static final String TAGNAME_TYPE = "type";
    private static final String TAGNAME_INSTANCE = "instance";
    private static final String TAGNAME_PROJECT = "project";
    private static final String TAGNAME_COMMENT = "comment";
    private static final String TAGNAME_DATE = "date";
    private static final String TAGNAME_USER = "user";
    private static final String TAGNAME_EMAIL = "email";
    private static final String TAGNAME_REVISION = "revision";
    private static final String TAGNAME_HTML_LINK = "a";
    private static final String TAGNAME_HTML_LINK_HREF = "href";
    private static final String TAGNAME_HTML_INS = "ins";
    public String taskNumber;
    public List<ChangeRequest> changeRequests = new ArrayList<ChangeRequest>();

    public CMSynergyModification() {
        super(MODIFICATION_TYPE);
    }

    public final ModifiedObject createModifiedObject() {
        ModifiedObject obj = new ModifiedObject();
        this.files.add(obj);
        return obj;
    }

    public final ModifiedObject createModifiedObject(String name, String version, String type, String instance, String project, String comment) {
        ModifiedObject obj = this.createModifiedObject();
        obj.name = name;
        obj.version = version;
        obj.type = type;
        obj.instance = instance;
        obj.project = project;
        obj.comment = comment;
        return obj;
    }

    public final ChangeRequest createChangeRequest(String number) {
        ChangeRequest cr = new ChangeRequest();
        cr.number = number;
        this.changeRequests.add(cr);
        return cr;
    }

    public Element toElement(DateFormat formatter) {
        Element modificationElement = new Element(TAGNAME_MODIFICATION);
        modificationElement.setAttribute(TAGNAME_TYPE, this.type);
        if (this.modifiedTime != null) {
            Element dateElement = new Element(TAGNAME_DATE);
            dateElement.addContent(formatter.format(this.modifiedTime));
            modificationElement.addContent((Content)dateElement);
        }
        if (this.userName != null) {
            Element userElement = new Element(TAGNAME_USER);
            userElement.addContent(this.userName);
            modificationElement.addContent((Content)userElement);
        }
        if (this.comment != null) {
            CDATA cd;
            Element commentElement = new Element(TAGNAME_COMMENT);
            try {
                cd = new CDATA(this.comment);
            }
            catch (IllegalDataException e) {
                LOG.error((Object)e);
                cd = new CDATA("Unable to parse comment. It contains illegal data.");
            }
            commentElement.addContent((Content)cd);
            modificationElement.addContent((Content)commentElement);
        }
        if (this.taskNumber != null) {
            Element taskNumberElement = new Element(TAGNAME_TASKNUMBER);
            taskNumberElement.addContent(this.taskNumber);
            modificationElement.addContent((Content)taskNumberElement);
        }
        if (this.revision != null) {
            Element revisionElement = new Element(TAGNAME_REVISION);
            revisionElement.addContent(this.revision);
            modificationElement.addContent((Content)revisionElement);
        }
        if (this.emailAddress != null) {
            Element emailAddressElement = new Element(TAGNAME_EMAIL);
            emailAddressElement.addContent(this.emailAddress);
            modificationElement.addContent((Content)emailAddressElement);
        }
        for (Modification.ModifiedFile file : this.files) {
            ModifiedObject obj = (ModifiedObject)file;
            modificationElement.addContent((Content)obj.toElement());
        }
        for (ChangeRequest cr : this.changeRequests) {
            modificationElement.addContent((Content)cr.toElement());
        }
        return modificationElement;
    }

    public String toString() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        StringBuffer sb = new StringBuffer();
        sb.append("Task Number: ").append(this.taskNumber).append('\n');
        sb.append("Owner: ").append(this.userName).append('\n');
        sb.append("Release: ").append(this.revision).append('\n');
        sb.append("Completion Date: ").append(formatter.format(this.modifiedTime)).append('\n');
        sb.append("Synopsis: ").append(this.comment).append('\n');
        for (ChangeRequest cr : this.changeRequests) {
            sb.append("\tChange Request: ").append(cr.number).append('\n');
        }
        for (Modification.ModifiedFile file : this.files) {
            ModifiedObject obj = (ModifiedObject)file;
            sb.append("\tAssociated Object: ").append(obj.name).append('\n');
            sb.append("\tVersion: ").append(obj.version).append('\n');
            sb.append("\tType: ").append(obj.type).append('\n');
            sb.append("\tInstance: ").append(obj.instance).append('\n');
            sb.append("\tProject: ").append(obj.project).append('\n');
            sb.append("\tComment: ").append(obj.comment).append('\n');
        }
        sb.append('\n');
        return sb.toString();
    }

    public void log(DateFormat formatter) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Task Number: " + this.taskNumber));
            LOG.debug((Object)("Owner: " + this.userName));
            LOG.debug((Object)("Release: " + this.revision));
            LOG.debug((Object)("Completion Date: " + formatter.format(this.modifiedTime)));
            LOG.debug((Object)("Synopsis: " + this.comment));
            for (ChangeRequest cr : this.changeRequests) {
                LOG.debug((Object)("\tChange Request: " + cr.number + "\n"));
            }
            for (Modification.ModifiedFile file : this.files) {
                ModifiedObject obj = (ModifiedObject)file;
                LOG.debug((Object)("\tAssociated Object: " + obj.name));
                LOG.debug((Object)("\tVersion: " + obj.version));
                LOG.debug((Object)("\tType: " + obj.type));
                LOG.debug((Object)("\tInstance: " + obj.instance));
                LOG.debug((Object)("\tProject: " + obj.project));
                LOG.debug((Object)("\tComment: " + obj.comment));
            }
            LOG.debug((Object)"");
        }
    }

    public void fromElement(Element modification, DateFormat formatter) {
        this.type = modification.getAttributeValue(TAGNAME_TYPE);
        try {
            String s = modification.getChildText(TAGNAME_DATE);
            if (s == null) {
                XMLOutputter outputter = new XMLOutputter();
                LOG.info((Object)("XML: " + outputter.outputString(modification)));
            }
            this.modifiedTime = formatter.parse(s);
        }
        catch (ParseException e) {
            this.modifiedTime = new Date();
        }
        this.taskNumber = modification.getChildText(TAGNAME_TASKNUMBER);
        this.revision = modification.getChildText(TAGNAME_REVISION);
        this.userName = modification.getChildText(TAGNAME_USER);
        this.comment = modification.getChildText(TAGNAME_COMMENT);
        this.emailAddress = modification.getChildText(TAGNAME_EMAIL);
        this.files.clear();
        List modfiles = modification.getChildren(TAGNAME_OBJECT);
        if (modfiles != null) {
            for (Element modfileElement : modfiles) {
                ModifiedObject modfile = new ModifiedObject();
                modfile.fromElement(modfileElement);
                this.files.add(modfile);
            }
        }
        this.changeRequests.clear();
        List crs = modification.getChildren(TAGNAME_CHANGEREQUEST);
        if (crs != null) {
            for (Element crElement : crs) {
                ChangeRequest cr = new ChangeRequest();
                cr.fromElement(crElement);
                this.changeRequests.add(cr);
            }
        }
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof CMSynergyModification)) {
            return false;
        }
        CMSynergyModification mod = (CMSynergyModification)o;
        return this.type.equals(mod.type) && this.taskNumber.equals(mod.taskNumber);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode()) + (this.taskNumber == null ? 0 : this.taskNumber.hashCode());
        return result;
    }

    public class ChangeRequest {
        public String href = null;
        public String number = "";

        protected ChangeRequest() {
        }

        public Element toElement() {
            Element element = new Element(CMSynergyModification.TAGNAME_CHANGEREQUEST);
            if (this.href != null) {
                Element linkElement = new Element(CMSynergyModification.TAGNAME_HTML_LINK);
                linkElement.setAttribute(CMSynergyModification.TAGNAME_HTML_LINK_HREF, this.href);
                linkElement.addContent(this.number);
                element.addContent((Content)linkElement);
            } else {
                Element insElement = new Element(CMSynergyModification.TAGNAME_HTML_INS);
                insElement.addContent(this.number);
                element.addContent((Content)insElement);
            }
            return element;
        }

        public void fromElement(Element modification) {
            Element linkElement = modification.getChild(CMSynergyModification.TAGNAME_HTML_LINK);
            if (linkElement != null) {
                this.href = linkElement.getAttributeValue(CMSynergyModification.TAGNAME_HTML_LINK_HREF);
                this.number = linkElement.getText();
            } else {
                Element insElement = modification.getChild(CMSynergyModification.TAGNAME_HTML_INS);
                if (insElement != null) {
                    this.number = insElement.getText();
                }
            }
        }
    }

    public class ModifiedObject
    extends Modification.ModifiedFile {
        public String name;
        public String version;
        public String type;
        public String instance;
        public String project;
        public String comment;

        protected ModifiedObject() {
            super(null, null, null, null);
            this.name = "";
            this.version = "";
            this.type = "";
            this.instance = "";
            this.project = "";
            this.comment = "";
        }

        public Element toElement() {
            CDATA cd;
            Element element = new Element(CMSynergyModification.TAGNAME_OBJECT);
            Element nameElement = new Element(CMSynergyModification.TAGNAME_NAME);
            nameElement.addContent(this.name);
            element.addContent((Content)nameElement);
            Element versionElement = new Element(CMSynergyModification.TAGNAME_VERSION);
            versionElement.addContent(this.version);
            element.addContent((Content)versionElement);
            Element typeElement = new Element(CMSynergyModification.TAGNAME_TYPE);
            typeElement.addContent(this.type);
            element.addContent((Content)typeElement);
            Element instanceElement = new Element(CMSynergyModification.TAGNAME_INSTANCE);
            instanceElement.addContent(this.instance);
            element.addContent((Content)instanceElement);
            Element projectElement = new Element(CMSynergyModification.TAGNAME_PROJECT);
            projectElement.addContent(this.project);
            element.addContent((Content)projectElement);
            Element commentElement = new Element(CMSynergyModification.TAGNAME_COMMENT);
            try {
                cd = new CDATA(this.comment);
            }
            catch (IllegalDataException e) {
                LOG.error((Object)e);
                cd = new CDATA("Unable to parse comment.  It contains illegal data.");
            }
            commentElement.addContent((Content)cd);
            element.addContent((Content)commentElement);
            return element;
        }

        public void fromElement(Element modification) {
            this.name = modification.getChildText(CMSynergyModification.TAGNAME_NAME);
            this.version = modification.getChildText(CMSynergyModification.TAGNAME_VERSION);
            this.type = modification.getChildText(CMSynergyModification.TAGNAME_TYPE);
            this.instance = modification.getChildText(CMSynergyModification.TAGNAME_INSTANCE);
            this.project = modification.getChildText(CMSynergyModification.TAGNAME_PROJECT);
            this.comment = modification.getChildText(CMSynergyModification.TAGNAME_COMMENT);
        }
    }
}

