/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.sourcecontrols;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.SourceControl;
import net.sourceforge.cruisecontrol.sourcecontrols.CMSynergyModification;
import net.sourceforge.cruisecontrol.sourcecontrols.SourceControlProperties;
import net.sourceforge.cruisecontrol.util.ManagedCommandline;
import net.sourceforge.cruisecontrol.util.Util;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import org.apache.log4j.Logger;

public class CMSynergy
implements SourceControl {
    public static final String CCM_ATTR_DELIMITER = "@#@#@#@";
    public static final String CCM_END_OBJECT = "<<<#@#@#>>>";
    public static final String CCM_EXE = "ccm";
    public static final String CCM_SESSION_VAR = "CCM_ADDR";
    public static final String CCM_SESSION_FILE = System.getProperty("user.home") + File.separator + ".ccmsessionmap";
    private static final Logger LOG = Logger.getLogger(CMSynergy.class);
    private SourceControlProperties properties = new SourceControlProperties();
    private String property = "cc.ccm.haschanged";
    private String ccmDelimiter = "-";
    private String changeSynergyURL;
    private String ccmDb;
    private String ccmExe;
    private String projectSpec;
    private String projectInstance = "1";
    private String projectFourPartName;
    private boolean updateFolders = true;
    private File sessionFile;
    private String sessionName;
    private String ccmDateFormat = "EEE MMM dd HH:mm:ss yyyy";
    private boolean reconfigure = false;
    private boolean recurse = true;
    private boolean useBindTime = false;
    private boolean ignoreWorkarea = false;
    private Locale locale;
    private String language = "en";
    private ManagedCommandline cmd;
    private String country = "US";
    private int numTasks;
    private int numObjects;

    public void setCcmExe(String ccmExe) {
        this.ccmExe = ccmExe;
    }

    public void setProject(String projectSpec) {
        this.projectSpec = projectSpec;
    }

    public void setInstance(String projectInstance) {
        this.projectInstance = projectInstance;
    }

    public void setChangeSynergyURL(String url) {
        this.changeSynergyURL = url;
    }

    public void setCcmDb(String db) {
        this.ccmDb = db;
    }

    public void setUpdateFolders(boolean updateFolders) {
        this.updateFolders = updateFolders;
    }

    public void setSessionFile(String sessionFile) {
        this.sessionFile = new File(sessionFile);
    }

    public void setSessionName(String sessionName) {
        this.sessionName = sessionName;
    }

    public void setCcmDateFormat(String format) {
        this.ccmDateFormat = format;
    }

    public void setReconfigure(boolean reconfigure) {
        this.reconfigure = reconfigure;
    }

    public void setUseBindTime(boolean useBindTime) {
        this.useBindTime = useBindTime;
    }

    public void setRecurse(boolean recurse) {
        this.recurse = recurse;
    }

    public void setIgnoreWorkarea(boolean ignoreWorkarea) {
        this.ignoreWorkarea = ignoreWorkarea;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public Map getProperties() {
        return this.properties.getPropertiesAndReset();
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public void validate() throws CruiseControlException {
        ValidationHelper.assertIsSet((Object)this.projectSpec, "project", this.getClass());
    }

    public List getModifications(Date lastBuild, Date now) {
        this.locale = new Locale(this.language, this.country);
        if (!this.locale.equals(Locale.US)) {
            LOG.info((Object)("Locale has been set to " + this.locale.toString()));
        }
        this.cmd = CMSynergy.createCcmCommand(this.ccmExe, this.sessionName, this.sessionFile);
        this.cmd.createArgument("delimiter");
        try {
            this.cmd.execute();
            this.cmd.assertExitCode(0);
            this.ccmDelimiter = this.cmd.getStdoutAsString().trim();
        }
        catch (Exception e) {
            StringBuffer message = new StringBuffer("Could not connect to provided CM Synergy session: ");
            message.append(this.sessionName).append(" with session file:").append(this.sessionFile.getAbsolutePath());
            LOG.error((Object)message.toString(), (Throwable)e);
            throw new OpperationFailedException(message.toString(), e);
        }
        this.projectFourPartName = this.projectSpec + ":project:" + this.projectInstance;
        LOG.info((Object)("Checking for modifications between " + lastBuild.toString() + " and " + now.toString()));
        if (this.updateFolders) {
            this.refreshReconfigureProperties();
        }
        this.numObjects = 0;
        this.numTasks = 0;
        List modifications = this.getModifiedTasks(lastBuild);
        LOG.info((Object)("Found " + this.numObjects + " modified object(s) in " + this.numTasks + " new task(s)."));
        if (this.reconfigure && this.numObjects > 0) {
            this.reconfigureProject();
        }
        this.properties.put("cc.ccm.project", this.projectFourPartName);
        this.properties.put("cc.ccm.dateformat", this.ccmDateFormat);
        String sessionID = this.cmd.getVariable(CCM_SESSION_VAR);
        if (sessionID != null) {
            this.properties.put("cc.ccm.session", sessionID);
        }
        if (this.numObjects > 0) {
            this.properties.put(this.property, "true");
        }
        if (!this.ignoreWorkarea) {
            this.properties.put("cc.ccm.workarea", this.getWorkarea());
        }
        return modifications;
    }

    private void refreshReconfigureProperties() {
        LOG.debug((Object)("Refreshing reconfigure properties for project " + this.projectFourPartName + "."));
        this.cmd.clearArgs();
        this.cmd.createArgument("reconfigure_properties");
        if (this.recurse) {
            this.cmd.createArgument("-recurse");
        }
        this.cmd.createArguments("-refresh", this.projectFourPartName);
        try {
            this.cmd.execute();
            this.cmd.assertExitCode(0);
        }
        catch (Exception e) {
            String message = "Could not refresh reconfigure properties for project \"" + this.projectFourPartName + "\".";
            LOG.error((Object)message, (Throwable)e);
            throw new OpperationFailedException(message, e);
        }
    }

    private List getModifiedTasks(Date lastBuild) {
        SimpleDateFormat toCcmDate = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss", this.locale);
        boolean isBaselineBasedProject = false;
        this.cmd.clearArgs();
        this.cmd.createArgument("prop");
        this.cmd.createArgument("-p");
        this.cmd.createArgument(this.projectFourPartName);
        this.cmd.createArgument("-f");
        this.cmd.createArgument("%purpose");
        try {
            this.cmd.execute();
        }
        catch (Exception e) {
            String message = "Could not query for new tasks.";
            LOG.error((Object)message, (Throwable)e);
            throw new OpperationFailedException(message, e);
        }
        if (this.cmd.getStdoutAsString().startsWith("System Testing")) {
            isBaselineBasedProject = true;
        } else if (this.cmd.getStdoutAsString().startsWith("Insulated Development")) {
            isBaselineBasedProject = true;
        }
        String release = this.getProjectRelease(this.projectFourPartName);
        String latestBaseline = this.getLatestBaseline(release);
        this.cmd.clearArgs();
        this.cmd.createArgument("query");
        this.cmd.createArgument("-u");
        this.cmd.createArgument("-f");
        this.cmd.createArgument("%displayname@#@#@#@%release@#@#@#@%owner@#@#@#@%completion_date@#@#@#@%task_synopsis<<<#@#@#>>>");
        if (this.useBindTime & !isBaselineBasedProject) {
            this.cmd.createArgument("is_task_in_folder_of(is_folder_in_rp_of('" + this.projectFourPartName + "'), '>', time('" + toCcmDate.format(lastBuild) + "'))");
        } else if (!isBaselineBasedProject) {
            this.cmd.createArgument("is_task_in_folder_of(is_folder_in_rp_of('" + this.projectFourPartName + "')) and completion_date>time('" + toCcmDate.format(lastBuild) + "')");
        } else if (this.useBindTime & isBaselineBasedProject) {
            this.cmd.createArgument("is_task_in_baseline_of('" + latestBaseline + "'), '>', time('" + toCcmDate.format(lastBuild) + "') or is_task_in_folder_of(is_folder_in_rp_of('" + this.projectFourPartName + "'), '>', time('" + toCcmDate.format(lastBuild) + "'))");
        } else {
            this.cmd.createArgument("is_task_in_baseline_of('" + latestBaseline + "') and completion_date>time('" + toCcmDate.format(lastBuild) + "') or is_task_in_folder_of(is_folder_in_rp_of('" + this.projectFourPartName + "')) and completion_date>time('" + toCcmDate.format(lastBuild) + "')");
        }
        try {
            this.cmd.execute();
        }
        catch (Exception e) {
            String message = "Could not query for new tasks.";
            LOG.error((Object)message, (Throwable)e);
            throw new OpperationFailedException(message, e);
        }
        ArrayList<CMSynergyModification> modificationList = new ArrayList<CMSynergyModification>();
        Iterator tasks = this.format(this.cmd.getStdoutAsList()).iterator();
        while (tasks.hasNext()) {
            ++this.numTasks;
            String[] attributes = this.tokeniseEntry((String)tasks.next(), 5);
            if (attributes == null) {
                LOG.warn((Object)"Could not determine attributes for at least one discovered task! The modification set is suspect.");
                continue;
            }
            CMSynergyModification mod = new CMSynergyModification();
            mod.taskNumber = attributes[0];
            mod.revision = attributes[1];
            mod.userName = attributes[2];
            mod.modifiedTime = this.getDateFromSynergy(attributes[3]);
            mod.comment = attributes[4];
            this.getModifiedObjects(mod);
            this.getAssociatedCRs(mod);
            modificationList.add(mod);
        }
        return modificationList;
    }

    private String getLatestBaseline(String release) {
        this.cmd.clearArgs();
        this.cmd.createArgument("query");
        this.cmd.createArgument("-u");
        this.cmd.createArgument("-ns");
        this.cmd.createArgument("-f");
        this.cmd.createArgument("%objectname");
        this.cmd.createArgument("status='published_baseline' and release='" + release + "'");
        try {
            this.cmd.execute();
        }
        catch (Exception e) {
            String message = "Could not query for latest baseline";
            LOG.error((Object)message, (Throwable)e);
            throw new OpperationFailedException(message, e);
        }
        String baselineString = this.cmd.getStdoutAsString();
        String[] baselineList = baselineString.split("\r\n|\r|\n");
        return baselineList[baselineList.length - 1].trim();
    }

    private String getProjectRelease(String projectFourPartName) {
        this.cmd.clearArgs();
        this.cmd.createArgument("prop");
        this.cmd.createArgument("-p");
        this.cmd.createArgument(projectFourPartName);
        this.cmd.createArgument("-f");
        this.cmd.createArgument("%release");
        try {
            this.cmd.execute();
        }
        catch (Exception e) {
            String message = "Could not get project release";
            LOG.error((Object)message, (Throwable)e);
            throw new OpperationFailedException(message, e);
        }
        String[] release = this.cmd.getStdoutAsString().split("\r\n|\r|\n");
        return release[0].trim();
    }

    private String[] tokeniseEntry(String line, int maxTokens) {
        int minTokens = maxTokens - 1;
        Object[] tokens = new String[maxTokens];
        Arrays.fill(tokens, "");
        int tokenIndex = 0;
        int oldIndex = 0;
        int index = line.indexOf(CCM_ATTR_DELIMITER, 0);
        while (true) {
            if (tokenIndex > maxTokens) {
                LOG.debug((Object)"Too many tokens; skipping entry");
                return null;
            }
            if (index == -1) break;
            tokens[tokenIndex] = line.substring(oldIndex, index);
            oldIndex = index + CCM_ATTR_DELIMITER.length();
            index = line.indexOf(CCM_ATTR_DELIMITER, oldIndex);
            ++tokenIndex;
        }
        tokens[tokenIndex] = line.substring(oldIndex);
        if (tokenIndex < minTokens) {
            LOG.debug((Object)"Not enough tokens; skipping entry");
            return null;
        }
        return tokens;
    }

    private void getModifiedObjects(CMSynergyModification mod) {
        this.cmd.clearArgs();
        this.cmd.createArgument("task");
        this.cmd.createArguments("-show", "objects");
        this.cmd.createArgument("-f");
        this.cmd.createArgument("%name@#@#@#@%version@#@#@#@%type@#@#@#@%instance@#@#@#@%project@#@#@#@%comment<<<#@#@#>>>");
        this.cmd.createArgument(mod.taskNumber);
        try {
            this.cmd.execute();
        }
        catch (Exception e) {
            LOG.warn((Object)("Could not query for objects in task \"" + mod.taskNumber + "\". The modification list will be incomplete!"), (Throwable)e);
        }
        Iterator objects = this.format(this.cmd.getStdoutAsList()).iterator();
        while (objects.hasNext()) {
            ++this.numObjects;
            String object = (String)objects.next();
            String[] attributes = this.tokeniseEntry(object, 6);
            if (attributes == null) {
                LOG.warn((Object)("Could not determine attributes for object associated with task \"" + mod.revision + "\"."));
                continue;
            }
            mod.createModifiedObject(attributes[0], attributes[1], attributes[2], attributes[3], attributes[4], attributes[5]);
        }
    }

    private void getAssociatedCRs(CMSynergyModification mod) {
        this.cmd.clearArgs();
        this.cmd.createArgument("query");
        this.cmd.createArgument("-u");
        this.cmd.createArguments("-f", "%displayname");
        this.cmd.createArgument("cvtype='problem' and has_associated_task('task" + mod.taskNumber + this.ccmDelimiter + "1:task:probtrac')");
        try {
            this.cmd.execute();
        }
        catch (Exception e) {
            LOG.warn((Object)"Could not query for associated CRs. The modification list may be incomplete!", (Throwable)e);
        }
        List crList = this.cmd.getStdoutAsList();
        if (crList != null) {
            Iterator crs = crList.iterator();
            while (crs.hasNext()) {
                String crNum = ((String)crs.next()).trim();
                CMSynergyModification.ChangeRequest cr = mod.createChangeRequest(crNum);
                if (this.changeSynergyURL == null || this.ccmDb == null) continue;
                StringBuffer href = new StringBuffer(this.changeSynergyURL);
                href.append("/servlet/com.continuus.webpt.servlet.PTweb?");
                href.append("ACTION_FLAG=frameset_form&#38;TEMPLATE_FLAG=ProblemReportView&#38;database=");
                href.append(this.ccmDb);
                href.append("&#38;role=User&#38;problem_number=");
                href.append(crNum);
                cr.href = href.toString();
            }
        }
    }

    private String getWorkarea() {
        String defaultWorkarea = ".";
        this.cmd.clearArgs();
        this.cmd.createArgument("attribute");
        this.cmd.createArguments("-show", "wa_path");
        this.cmd.createArguments("-project", this.projectFourPartName);
        try {
            this.cmd.execute();
            this.cmd.assertExitCode(0);
        }
        catch (Exception e) {
            LOG.warn((Object)("Could not determine the workarea location for project \"" + this.projectFourPartName + "\"."), (Throwable)e);
            return defaultWorkarea;
        }
        File workareaPath = new File(this.cmd.getStdoutAsString().trim());
        if (!workareaPath.isDirectory()) {
            LOG.warn((Object)("The workarea reported by Synergy does not exist or is not accessible by this session - \"" + workareaPath.toString() + "\"."));
            return defaultWorkarea;
        }
        String[] dirs = workareaPath.list();
        if (dirs.length != 1) {
            LOG.warn((Object)("The workarea reported by Synergy is invalid - \"" + workareaPath.toString() + "\"."));
            return defaultWorkarea;
        }
        return workareaPath.getAbsolutePath() + File.separator + dirs[0];
    }

    private void reconfigureProject() {
        LOG.debug((Object)("Reconfiguring project " + this.projectFourPartName + "."));
        this.cmd.clearArgs();
        this.cmd.createArgument("reconfigure");
        if (this.recurse) {
            this.cmd.createArgument("-recurse");
        }
        this.cmd.createArguments("-project", this.projectFourPartName);
        try {
            this.cmd.execute();
            this.cmd.assertExitCode(0);
        }
        catch (Exception e) {
            String message = "Could not reconfigure project \"" + this.projectFourPartName + "\".";
            LOG.error((Object)message, (Throwable)e);
            throw new OpperationFailedException(message, e);
        }
    }

    private List format(List in) {
        ArrayList<String> out = new ArrayList<String>();
        Iterator it = in.iterator();
        StringBuffer buff = new StringBuffer();
        while (it.hasNext()) {
            buff.append((String)it.next());
            int index = buff.toString().lastIndexOf(CCM_END_OBJECT);
            if (index <= -1) continue;
            buff.delete(index, buff.length());
            out.add(buff.toString());
            buff = new StringBuffer();
        }
        return out;
    }

    private Date getDateFromSynergy(String dateString) {
        Date date;
        SimpleDateFormat fromCcmDate = new SimpleDateFormat(this.ccmDateFormat, this.locale);
        try {
            date = fromCcmDate.parse(dateString);
        }
        catch (ParseException e) {
            LOG.warn((Object)("Could not parse CM Synergy date \"" + dateString + "\" into Java Date using format \"" + this.ccmDateFormat + "\"."), (Throwable)e);
            date = new Date();
        }
        return date;
    }

    public static String getSessionID(String sessionName, File sessionFile) throws CruiseControlException {
        Properties sessionProperties;
        if (sessionFile == null) {
            sessionFile = new File(CCM_SESSION_FILE);
        }
        try {
            sessionProperties = Util.loadPropertiesFromFile(sessionFile);
        }
        catch (IOException e) {
            throw new CruiseControlException(e);
        }
        return sessionProperties.getProperty(sessionName);
    }

    public static ManagedCommandline createCcmCommand(String ccmExe, String sessionName, File sessionFile) {
        if (ccmExe == null) {
            ccmExe = CCM_EXE;
        }
        String sessionID = null;
        if (sessionName != null) {
            try {
                sessionID = CMSynergy.getSessionID(sessionName, sessionFile);
                if (sessionID == null) {
                    LOG.error((Object)("Could not find a session ID for CM Synergy session named \"" + sessionName + "\". Attempting to use the default (current) session."));
                }
            }
            catch (CruiseControlException e) {
                LOG.error((Object)("Failed to look up CM Synergy session named \"" + sessionName + "\". Attempting to use the default (current) session."), (Throwable)e);
            }
        }
        ManagedCommandline command = new ManagedCommandline(ccmExe);
        if (sessionID != null) {
            command.setVariable(CCM_SESSION_VAR, sessionID);
        }
        return command;
    }

    class OpperationFailedException
    extends RuntimeException {
        public OpperationFailedException(String message, Exception e) {
            super(message, e);
        }
    }
}

