/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.sourcecontrols;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Modification;
import net.sourceforge.cruisecontrol.SourceControl;
import net.sourceforge.cruisecontrol.sourcecontrols.AlienBrainCore;
import net.sourceforge.cruisecontrol.sourcecontrols.SourceControlProperties;
import net.sourceforge.cruisecontrol.util.ManagedCommandline;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlienBrain
extends AlienBrainCore
implements SourceControl {
    private static final Logger LOG = Logger.getLogger(AlienBrain.class);
    private static final long FILETIME_EPOCH_DIFF = 11644473600000L;
    private static final long HUNDRED_NANO_PER_MILLI_RATIO = 10000L;
    private static final String AB_NO_MODIFICATIONS = "No files or folders found!";
    private static final String AB_MODIFICATION_SUMMARY_PREFIX = "Total of ";
    private final SourceControlProperties properties = new SourceControlProperties();

    @Override
    public Map<String, String> getProperties() {
        return this.properties.getPropertiesAndReset();
    }

    public void setProperty(String propertyName) {
        this.properties.assignPropertyName(propertyName);
    }

    @Override
    public void validate() throws CruiseControlException {
        ValidationHelper.assertIsSet((Object)this.getPath(), "path", this.getClass());
    }

    @Override
    public List<Modification> getModifications(Date lastBuild, Date now) {
        List<Object> mods = new ArrayList();
        try {
            this.validate();
            mods = this.getModificationsFromAlienBrain(lastBuild, now);
        }
        catch (Exception e) {
            LOG.error((Object)"Log command failed to execute succesfully", (Throwable)e);
        }
        if (!mods.isEmpty()) {
            this.properties.modificationFound();
        }
        return mods;
    }

    public static long dateToFiletime(Date date) {
        long milliSecsSinceUnixEpoch = date.getTime();
        long milliSecsSinceFiletimeEpoch = milliSecsSinceUnixEpoch + 11644473600000L;
        return milliSecsSinceFiletimeEpoch * 10000L;
    }

    public static Date filetimeToDate(long filetime) {
        long milliSecsSinceFiletimeEpoch = filetime / 10000L;
        long milliSecsSinceUnixEpoch = milliSecsSinceFiletimeEpoch - 11644473600000L;
        return new Date(milliSecsSinceUnixEpoch);
    }

    protected ManagedCommandline buildGetModificationsCommand(Date lastBuild, Date now) {
        ManagedCommandline cmdLine = this.buildCommonCommand();
        cmdLine.createArguments("find", this.getPath());
        cmdLine.createArguments("-regex", "SCIT > " + AlienBrain.dateToFiletime(lastBuild));
        cmdLine.createArguments("-format", "#SCIT#|#DbPath#|#Changed By#|#CheckInComment#");
        return cmdLine;
    }

    protected List<Modification> getModificationsFromAlienBrain(Date lastBuild, Date now) throws IOException, CruiseControlException {
        if (this.getBranch() != null) {
            this.setActiveBranch(this.getBranch());
        }
        ManagedCommandline cmdLine = this.buildGetModificationsCommand(lastBuild, now);
        LOG.debug((Object)("Executing: " + cmdLine.toString()));
        cmdLine.execute();
        return this.parseModifications(cmdLine.getStdoutAsList());
    }

    protected List<Modification> parseModifications(List modifications) {
        ArrayList<Modification> mods = new ArrayList<Modification>();
        for (String line : modifications) {
            if ((line = line.trim()).equals("Invalid session please logon!")) {
                LOG.error((Object)"Invalid session please logon!");
                continue;
            }
            if (line.equals(AB_NO_MODIFICATIONS) || line.startsWith(AB_MODIFICATION_SUMMARY_PREFIX)) continue;
            if (line.startsWith("|")) {
                line = "0" + line;
            }
            Modification m = AlienBrain.parseModificationDescription(line);
            mods.add(m);
        }
        return mods;
    }

    protected static Modification parseModificationDescription(String description) {
        Modification m = new Modification("AlienBrain");
        StringTokenizer st = new StringTokenizer(description, "|");
        m.modifiedTime = AlienBrain.filetimeToDate(Long.parseLong(st.nextToken()));
        m.createModifiedFile(st.nextToken(), null);
        m.userName = st.nextToken();
        while (st.hasMoreTokens()) {
            m.comment = m.comment + st.nextToken();
        }
        return m;
    }
}

