/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.sourcecontrols;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Modification;
import net.sourceforge.cruisecontrol.SourceControl;
import net.sourceforge.cruisecontrol.sourcecontrols.SourceControlProperties;
import net.sourceforge.cruisecontrol.sourcecontrols.accurev.AccurevCommand;
import net.sourceforge.cruisecontrol.sourcecontrols.accurev.AccurevCommandline;
import net.sourceforge.cruisecontrol.sourcecontrols.accurev.AccurevInputParser;
import net.sourceforge.cruisecontrol.sourcecontrols.accurev.DateTimespec;
import net.sourceforge.cruisecontrol.sourcecontrols.accurev.Runner;
import org.apache.log4j.Logger;

public class Accurev
implements SourceControl,
AccurevInputParser {
    private static final Logger LOG = Logger.getLogger(Accurev.class);
    private String stream;
    private boolean verbose;
    private ArrayList modifications;
    private Runner runner;
    private SourceControlProperties properties = new SourceControlProperties();

    public void setStream(String stream) {
        this.stream = stream;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setProperty(String propertyName) {
        this.properties.assignPropertyName(propertyName);
    }

    public void validate() throws CruiseControlException {
        if (this.stream == null) {
            throw new CruiseControlException("'stream' is a required attribute for Accurev");
        }
    }

    public List getModifications(Date lastBuild, Date now) {
        LOG.info((Object)("Accurev: getting modifications for " + this.stream));
        AccurevCommandline hist = AccurevCommand.HIST.create();
        if (this.runner != null) {
            hist.setRunner(this.runner);
        }
        hist.setVerbose(this.verbose);
        hist.setInputParser(this);
        hist.setStream(this.stream);
        hist.setTransactionRange(new DateTimespec(lastBuild), new DateTimespec(now));
        hist.run();
        return this.modifications;
    }

    public boolean parseStream(InputStream input) throws IOException, CruiseControlException {
        String line;
        this.modifications = new ArrayList();
        Modification modification = null;
        BufferedReader reader = new BufferedReader(new InputStreamReader(input));
        while ((line = reader.readLine()) != null) {
            LOG.debug((Object)line);
            if (line.startsWith("transaction")) {
                modification = new Modification();
                String[] parts = this.getParts(line);
                modification.comment = "";
                modification.revision = parts[0].substring(parts[0].indexOf(32) + 1);
                modification.type = parts[1].trim();
                modification.modifiedTime = DateTimespec.parse(parts[2].trim());
                modification.userName = parts[3].substring(6).trim();
                this.modifications.add(modification);
                this.properties.modificationFound();
                continue;
            }
            if (line.startsWith("  #")) {
                if (modification != null) {
                    modification.comment = modification.comment + line.substring(3) + "\n";
                    continue;
                }
                LOG.warn((Object)"Comment outside modification - skipping");
                continue;
            }
            if (!line.startsWith("  \\.\\") && !line.startsWith("  /./")) continue;
            char separator = line.charAt(2);
            int lastSlash = line.lastIndexOf(separator);
            int lastSpace = line.lastIndexOf(32);
            if ((lastSpace = line.lastIndexOf(32, lastSpace - 1)) <= lastSlash) continue;
            String fileName = line.substring(lastSlash + 1, lastSpace);
            String folderName = (lastSlash > 5 ? line.substring(5, lastSlash) : line.substring(5)).replace(separator, '/');
            Modification.ModifiedFile modfile = modification.createModifiedFile(fileName, folderName);
            modfile.action = "change";
        }
        return true;
    }

    private String[] getParts(String line) {
        ArrayList<String> partsList = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(line, ";");
        while (tokenizer.hasMoreTokens()) {
            partsList.add(tokenizer.nextToken());
        }
        String[] parts = new String[partsList.size()];
        partsList.toArray(parts);
        return parts;
    }

    public void setRunner(Runner runner) {
        this.runner = runner;
    }

    public Map getProperties() {
        return this.properties.getPropertiesAndReset();
    }
}

