/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.publishers.sfee;

import com.vasoftware.sf.soap42.webservices.ClientSoapStubFactory;
import com.vasoftware.sf.soap42.webservices.filestorage.IFileStorageAppSoap;
import com.vasoftware.sf.soap42.webservices.frs.FrsFileSoapList;
import com.vasoftware.sf.soap42.webservices.frs.FrsFileSoapRow;
import com.vasoftware.sf.soap42.webservices.frs.IFrsAppSoap;
import com.vasoftware.sf.soap42.webservices.sfmain.ISourceForgeSoap;
import java.io.File;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import javax.activation.DataHandler;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.publishers.sfee.SfeePublisher;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import org.jdom.Element;

public class SfeeFrsPublisher
extends SfeePublisher {
    private File file;
    private String releaseID;
    private String uploadName;

    public void setFile(String filename) {
        this.file = new File(filename);
    }

    public void setReleaseID(String releaseID) {
        this.releaseID = releaseID;
    }

    public void setUploadname(String uploadname) {
        this.uploadName = uploadname;
    }

    public void publish(Element cruisecontrolLog) throws CruiseControlException {
        ValidationHelper.assertExists(this.getFile(), "file", this.getClass());
        ValidationHelper.assertIsNotDirectory(this.getFile(), "file", this.getClass());
        ValidationHelper.assertIsReadable(this.getFile(), "file", this.getClass());
        if (this.uploadName == null) {
            this.uploadName = this.getFile().getName();
        }
        ISourceForgeSoap soap = (ISourceForgeSoap)ClientSoapStubFactory.getSoapStub(ISourceForgeSoap.class, (String)this.getServerURL());
        try {
            String sessionID = soap.login(this.getUsername(), this.getPassword());
            IFrsAppSoap frsApp = (IFrsAppSoap)ClientSoapStubFactory.getSoapStub(IFrsAppSoap.class, (String)this.getServerURL());
            FrsFileSoapList fileList = frsApp.getFrsFileList(sessionID, this.releaseID);
            Collection existingFiles = SfeeFrsPublisher.findExistingFiles(fileList, this.uploadName);
            for (String id : existingFiles) {
                frsApp.deleteFrsFile(sessionID, id);
            }
            DataHandler dataHandler = new DataHandler(this.getFile().toURI().toURL());
            IFileStorageAppSoap fileStorageApp = (IFileStorageAppSoap)ClientSoapStubFactory.getSoapStub(IFileStorageAppSoap.class, (String)this.getServerURL());
            String storedFileId = fileStorageApp.uploadFile(sessionID, dataHandler);
            frsApp.createFrsFile(sessionID, this.releaseID, this.uploadName, dataHandler.getContentType(), storedFileId);
        }
        catch (RemoteException e) {
            throw new CruiseControlException(e);
        }
        catch (MalformedURLException e) {
            throw new CruiseControlException(e);
        }
    }

    protected File getFile() {
        return this.file;
    }

    private static Collection findExistingFiles(FrsFileSoapList fileList, String filename) {
        FrsFileSoapRow[] files = fileList.getDataRows();
        ArrayList<String> duplicates = new ArrayList<String>();
        for (int i = 0; i < files.length; ++i) {
            FrsFileSoapRow nextFile = files[i];
            if (!nextFile.getFilename().equals(filename)) continue;
            duplicates.add(nextFile.getId());
        }
        return duplicates;
    }

    public void subValidate() throws CruiseControlException {
        ValidationHelper.assertIsSet((Object)this.releaseID, "releaseid", this.getClass());
        ValidationHelper.assertIsSet((Object)this.getFile(), "file", this.getClass());
    }
}

