/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.publishers.sfee;

import com.vasoftware.sf.soap42.webservices.ClientSoapStubFactory;
import com.vasoftware.sf.soap42.webservices.docman.DocumentFolderSoapDO;
import com.vasoftware.sf.soap42.webservices.docman.DocumentFolderSoapList;
import com.vasoftware.sf.soap42.webservices.docman.DocumentFolderSoapRow;
import com.vasoftware.sf.soap42.webservices.docman.DocumentSoapDO;
import com.vasoftware.sf.soap42.webservices.docman.DocumentSoapList;
import com.vasoftware.sf.soap42.webservices.docman.DocumentSoapRow;
import com.vasoftware.sf.soap42.webservices.docman.IDocumentAppSoap;
import com.vasoftware.sf.soap42.webservices.filestorage.IFileStorageAppSoap;
import com.vasoftware.sf.soap42.webservices.sfmain.ISourceForgeSoap;
import java.rmi.RemoteException;
import java.util.StringTokenizer;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.publishers.sfee.SfeePublisher;
import net.sourceforge.cruisecontrol.publishers.sfee.SfeeUtils;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import net.sourceforge.cruisecontrol.util.XPathAwareChild;
import org.jdom.Element;

public class SfeeDocumentManagerPublisher
extends SfeePublisher {
    private String projectName;
    private XPathAwareChild documentName;
    private XPathAwareChild description;
    private DataSource dataSrc;
    private String path;
    private Status status;
    private XPathAwareChild versionComment;
    private boolean lock;
    private String documentPath;

    public Status createStatus() {
        this.status = new Status();
        return this.status;
    }

    public XPathAwareChild createVersionComment() {
        this.versionComment = new XPathAwareChild();
        return this.versionComment;
    }

    public void setLock(boolean lock) {
        this.lock = lock;
    }

    public void setData(DataSource dataSrc) {
        this.dataSrc = dataSrc;
    }

    public XPathAwareChild createDocumentName() {
        this.documentName = new XPathAwareChild();
        return this.documentName;
    }

    public XPathAwareChild createDescription() {
        this.description = new XPathAwareChild();
        return this.description;
    }

    public void setProjectName(String name) {
        this.projectName = name;
    }

    public void setFolder(String path) {
        this.path = path;
    }

    public void publish(Element cruisecontrolLog) throws CruiseControlException {
        DocumentSoapDO existingDocument;
        String mimeType;
        String fileID;
        String sessionID;
        ISourceForgeSoap sfee = (ISourceForgeSoap)ClientSoapStubFactory.getSoapStub(ISourceForgeSoap.class, (String)this.getServerURL());
        try {
            sessionID = sfee.login(this.getUsername(), this.getPassword());
        }
        catch (RemoteException e) {
            throw new CruiseControlException(e);
        }
        IFileStorageAppSoap fileStorage = (IFileStorageAppSoap)ClientSoapStubFactory.getSoapStub(IFileStorageAppSoap.class, (String)this.getServerURL());
        try {
            if (this.documentPath != null) {
                this.dataSrc = new FileDataSource(this.documentPath);
            }
            DataHandler dataHandler = new DataHandler(this.dataSrc);
            fileID = fileStorage.uploadFile(sessionID, dataHandler);
            mimeType = dataHandler.getContentType();
        }
        catch (RemoteException e) {
            throw new CruiseControlException(e);
        }
        DocumentFolderSoapDO folder = this.findFolder(this.path);
        String intendedDocumentName = this.documentName != null ? this.documentName.lookupValue(cruisecontrolLog) : this.dataSrc.getName();
        String intendedVersionComment = this.versionComment != null ? this.versionComment.lookupValue(cruisecontrolLog) : null;
        try {
            existingDocument = this.findExistingDocument(sessionID, folder, intendedDocumentName);
        }
        catch (RemoteException e) {
            throw new CruiseControlException(e);
        }
        if (existingDocument != null) {
            this.updateExistingDocument(sessionID, existingDocument, intendedVersionComment, mimeType, fileID, cruisecontrolLog);
        } else {
            this.createNewDocument(cruisecontrolLog, sessionID, intendedDocumentName, intendedVersionComment, folder, mimeType, fileID);
        }
    }

    private void updateExistingDocument(String sessionID, DocumentSoapDO existingDocument, String versionComment, String mimeType, String fileID, Element cruiseControlLog) throws CruiseControlException {
        IDocumentAppSoap docApp = (IDocumentAppSoap)ClientSoapStubFactory.getSoapStub(IDocumentAppSoap.class, (String)this.getServerURL());
        existingDocument.setDescription(this.description.lookupValue(cruiseControlLog));
        existingDocument.setStatus(this.status.lookupValue(cruiseControlLog));
        if (this.lock) {
            existingDocument.setLockedBy(this.getUsername());
        } else {
            existingDocument.setLockedBy(null);
        }
        existingDocument.setMimeType(mimeType);
        existingDocument.setVersionComment(versionComment);
        try {
            docApp.setDocumentData(sessionID, existingDocument, fileID);
        }
        catch (RemoteException e) {
            throw new CruiseControlException(e);
        }
    }

    private DocumentSoapDO findExistingDocument(String sessionID, DocumentFolderSoapDO folder, String intendedDocumentName) throws RemoteException {
        IDocumentAppSoap docApp = (IDocumentAppSoap)ClientSoapStubFactory.getSoapStub(IDocumentAppSoap.class, (String)this.getServerURL());
        DocumentSoapList documentList = docApp.getDocumentList(sessionID, folder.getId(), null);
        DocumentSoapRow[] existingDocuments = documentList.getDataRows();
        for (int i = 0; i < existingDocuments.length; ++i) {
            DocumentSoapRow existingDocument = existingDocuments[i];
            if (!existingDocument.getTitle().equals(intendedDocumentName)) continue;
            return docApp.getDocumentData(sessionID, existingDocument.getId(), existingDocument.getCurrentVersion());
        }
        return null;
    }

    private void createNewDocument(Element cruisecontrolLog, String sessionID, String intendedDocumentName, String intendedVersionComment, DocumentFolderSoapDO folder, String mimeType, String fileID) throws CruiseControlException {
        IDocumentAppSoap docApp = (IDocumentAppSoap)ClientSoapStubFactory.getSoapStub(IDocumentAppSoap.class, (String)this.getServerURL());
        try {
            docApp.createDocument(sessionID, folder.getId(), intendedDocumentName, this.description.lookupValue(cruisecontrolLog), intendedVersionComment, this.status.lookupValue(cruisecontrolLog), this.lock, intendedDocumentName, mimeType, fileID);
        }
        catch (RemoteException e) {
            throw new CruiseControlException(e);
        }
    }

    public void subValidate() throws CruiseControlException {
        ValidationHelper.assertIsSet((Object)this.path, "folder", SfeeDocumentManagerPublisher.class);
        ValidationHelper.assertIsSet((Object)this.projectName, "projectName", SfeeDocumentManagerPublisher.class);
        if (this.documentPath == null && this.dataSrc == null) {
            throw new CruiseControlException("Either a document or a datasource must be specified.");
        }
        ValidationHelper.assertHasChild(this.description, "description", SfeeDocumentManagerPublisher.class);
        this.description.validate();
        ValidationHelper.assertHasChild(this.status, "status", SfeeDocumentManagerPublisher.class);
        this.status.validate();
        if (this.documentName != null) {
            this.documentName.validate();
        }
        if (this.versionComment != null) {
            this.versionComment.validate();
        }
    }

    DocumentFolderSoapDO findFolder(String path) throws CruiseControlException {
        DocumentFolderSoapDO folder;
        if (path == null) {
            throw new IllegalArgumentException("path can not be null.");
        }
        StringTokenizer tokens = new StringTokenizer(path, "/");
        try {
            ISourceForgeSoap soap = (ISourceForgeSoap)ClientSoapStubFactory.getSoapStub(ISourceForgeSoap.class, (String)this.getServerURL());
            String sessionID = soap.login(this.getUsername(), this.getPassword());
            String projectID = SfeeUtils.findProjectID(soap, sessionID, this.projectName);
            IDocumentAppSoap docApp = (IDocumentAppSoap)ClientSoapStubFactory.getSoapStub(IDocumentAppSoap.class, (String)this.getServerURL());
            folder = SfeeDocumentManagerPublisher.findFolderInternal(sessionID, projectID, tokens, docApp);
        }
        catch (RemoteException e) {
            throw new CruiseControlException(e);
        }
        if (folder == null) {
            throw new CruiseControlException("Unable to find a folder for the path specified [" + path + "].");
        }
        return folder;
    }

    private static DocumentFolderSoapDO findFolderInternal(String sessionID, String parentID, StringTokenizer pathTokens, IDocumentAppSoap docApp) throws RemoteException {
        if (!pathTokens.hasMoreTokens()) {
            return null;
        }
        DocumentFolderSoapList folderList = docApp.getDocumentFolderList(sessionID, parentID, false);
        DocumentFolderSoapRow[] folders = folderList.getDataRows();
        String nextPathElement = pathTokens.nextToken();
        boolean isFinalPathElement = !pathTokens.hasMoreTokens();
        for (int i = 0; i < folders.length; ++i) {
            DocumentFolderSoapRow nextFolder = folders[i];
            String nextFolderTitle = nextFolder.getTitle();
            boolean folderNamesMatch = nextFolderTitle.equals(nextPathElement);
            if (folderNamesMatch && isFinalPathElement) {
                return docApp.getDocumentFolderData(sessionID, nextFolder.getId());
            }
            if (!folderNamesMatch) continue;
            return SfeeDocumentManagerPublisher.findFolderInternal(sessionID, nextFolder.getId(), pathTokens, docApp);
        }
        return null;
    }

    public void setDocument(String documentPath) {
        this.documentPath = documentPath;
    }

    public static class Status
    extends XPathAwareChild {
        public void validate() throws CruiseControlException {
            if (this.getXpathExpression() == null && this.getFixedValue() != null && !this.getFixedValue().equalsIgnoreCase("final") && !this.getFixedValue().equalsIgnoreCase("draft")) {
                throw new CruiseControlException("Status value specified [] is not valid. Valid values are 'final' and 'draft'.");
            }
            super.validate();
        }
    }
}

