/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.publishers.rss;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jdom.Element;

public class Item
implements Comparable {
    private String title;
    private String link;
    private String description;
    private Date publishDate;
    private final SimpleDateFormat rssDateFormatter = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z");

    public Item() {
    }

    public Item(Element itemNode) {
        if (itemNode.getChild("title") != null) {
            this.title = itemNode.getChild("title").getText();
        }
        if (itemNode.getChild("link") != null) {
            this.link = itemNode.getChild("link").getText();
        }
        if (itemNode.getChild("description") != null) {
            this.description = itemNode.getChild("description").getText();
        }
        if (itemNode.getChild("pubDate") != null) {
            try {
                this.publishDate = this.rssDateFormatter.parse(itemNode.getChild("pubDate").getText());
            }
            catch (ParseException pex) {
                this.publishDate = new Date(0L);
            }
        }
    }

    public int compareTo(Object o) {
        Item other = (Item)o;
        return other.getPublishDate().compareTo(this.getPublishDate());
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public Date getPublishDate() {
        return this.publishDate;
    }

    public void setPublishDate(Date publishDate) {
        this.publishDate = publishDate;
    }

    public String toXml() {
        StringBuffer output = new StringBuffer();
        output.append("    <");
        output.append("item");
        output.append(">\n");
        output.append("        <");
        output.append("title");
        output.append(">");
        if (this.getTitle() != null) {
            output.append(this.getTitle());
        }
        output.append("</");
        output.append("title");
        output.append(">\n");
        output.append("        <");
        output.append("link");
        output.append(">");
        if (this.getLink() != null) {
            output.append(this.getLink());
        }
        output.append("</");
        output.append("link");
        output.append(">\n");
        output.append("        <");
        output.append("description");
        output.append("><![CDATA[");
        if (this.getDescription() != null) {
            output.append(this.getDescription());
        }
        output.append("]]></");
        output.append("description");
        output.append(">\n");
        if (this.getPublishDate() != null) {
            output.append("        <");
            output.append("pubDate");
            output.append(">");
            output.append(this.rssDateFormatter.format(this.getPublishDate()));
            output.append("</");
            output.append("pubDate");
            output.append(">\n");
        }
        output.append("        <");
        output.append("guid");
        output.append(" ");
        output.append("isPermaLink");
        output.append("=\"true\">");
        if (this.getLink() != null) {
            output.append(this.getLink());
        }
        output.append("</");
        output.append("guid");
        output.append(">\n");
        output.append("    </");
        output.append("item");
        output.append(">\n");
        return output.toString();
    }
}

