/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.publishers.rss;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Modification;
import net.sourceforge.cruisecontrol.publishers.rss.Item;
import net.sourceforge.cruisecontrol.util.DateUtil;
import net.sourceforge.cruisecontrol.util.XMLLogHelper;
import org.apache.log4j.Logger;

public class CruiseControlItem
extends Item {
    private static final Logger LOG = Logger.getLogger(CruiseControlItem.class);

    public CruiseControlItem(XMLLogHelper logHelper, String buildResultsURL) throws CruiseControlException {
        this.setTitle(this.createTitle(logHelper));
        this.setLink(this.createLink(logHelper, buildResultsURL));
        this.setDescription(this.createDescription(logHelper));
        try {
            this.setPublishDate(DateUtil.parseFormattedTime(logHelper.getBuildTimestamp(), "cctimestamp"));
        }
        catch (CruiseControlException ccex) {
            this.setPublishDate(new Date());
        }
    }

    private String createTitle(XMLLogHelper logHelper) throws CruiseControlException {
        StringBuffer title = new StringBuffer();
        title.append(logHelper.getProjectName());
        if (logHelper.isBuildSuccessful()) {
            String label = logHelper.getLabel();
            if (label.length() > 0) {
                title.append(" ");
                title.append(label);
            }
            if (logHelper.isBuildFix()) {
                title.append(" Build Fixed");
            } else {
                title.append(" Build Successful");
            }
        } else {
            title.append(" Build Failed");
        }
        return title.toString();
    }

    private String createLink(XMLLogHelper logHelper, String buildResultsURL) throws CruiseControlException {
        if (buildResultsURL == null) {
            return "";
        }
        String logFileName = logHelper.getLogFileName();
        int startName = logFileName.lastIndexOf(File.separator) + 1;
        int endName = logFileName.lastIndexOf(".");
        String baseLogFileName = logFileName.substring(startName, endName);
        StringBuffer url = new StringBuffer(buildResultsURL);
        if (buildResultsURL.indexOf("?") == -1) {
            url.append("?");
        } else {
            url.append("&");
        }
        url.append("log=");
        url.append(baseLogFileName);
        return url.toString();
    }

    private String createDescription(XMLLogHelper logHelper) throws CruiseControlException {
        StringBuffer description = new StringBuffer();
        description.append("<em>Build Time:</em> ");
        try {
            description.append(DateUtil.parseFormattedTime(logHelper.getBuildTimestamp(), "cctimestamp"));
        }
        catch (CruiseControlException ccex) {
            LOG.error((Object)"exception trying to resolve cctimestamp", (Throwable)ccex);
            description.append("not available");
        }
        catch (NullPointerException npe) {
            LOG.error((Object)"NPE trying to resolve cctimestamp", (Throwable)npe);
            description.append("not available");
        }
        description.append("<br/>");
        description.append("<em>Label:</em> ");
        if (logHelper.getLabel() != null) {
            description.append(logHelper.getLabel());
        }
        description.append("<br/>");
        description.append("<em>Modifications: </em>");
        try {
            ArrayList<Modification> modifications = new ArrayList<Modification>(logHelper.getModifications());
            Collections.sort(modifications, new ModificationComparator());
            description.append(modifications.size());
            for (Modification mod : modifications) {
                description.append("<li>");
                description.append(mod.getFileName());
                description.append("  by ");
                if (mod.userName != null) {
                    description.append(mod.userName);
                } else {
                    description.append("[no user]");
                }
                description.append(" (");
                if (mod.comment != null) {
                    description.append(mod.comment);
                } else {
                    description.append("[no comment]");
                }
                description.append(")</li>");
            }
            description.append("</ul>");
        }
        catch (NullPointerException npe) {
            LOG.error((Object)"NPE trying to build String representation of modifications in description", (Throwable)npe);
            description.append("0");
        }
        description.append("<br/>\n<ul>");
        return description.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ModificationComparator
    implements Comparator<Modification> {
        ModificationComparator() {
        }

        @Override
        public int compare(Modification mod1, Modification mod2) {
            long modifiedTimeDifference = mod1.modifiedTime.getTime() - mod2.modifiedTime.getTime();
            if (modifiedTimeDifference != 0L) {
                return modifiedTimeDifference > 0L ? 1 : -1;
            }
            return mod1.getFileName().compareTo(mod2.getFileName());
        }
    }
}

