/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.publishers.rss;

import java.io.File;
import net.sourceforge.cruisecontrol.publishers.rss.Feed;

public class CruiseControlFeed
extends Feed {
    private int projectCount;
    private String projectName;

    public CruiseControlFeed(File publishToFile) {
        super(publishToFile);
    }

    public void incrementProjectCount() {
        ++this.projectCount;
    }

    public int getProjectCount() {
        return this.projectCount;
    }

    public void setProjectName(String name) {
        this.projectName = CruiseControlFeed.isNotEmpty(this.projectName) ? this.projectName + ", " + name : name;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getDescription() {
        if (CruiseControlFeed.isNotEmpty(super.getDescription())) {
            return super.getDescription();
        }
        if (CruiseControlFeed.isNotEmpty(this.projectName)) {
            return "Automated build results for CruiseControl project(s) " + this.projectName;
        }
        return "Automated build results for CruiseControl.";
    }

    public String getTitle() {
        if (CruiseControlFeed.isNotEmpty(super.getTitle())) {
            return super.getTitle();
        }
        return "CruiseControl Build Results";
    }

    private static boolean isNotEmpty(String string) {
        return string != null && string.trim().length() > 0;
    }
}

