/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.publishers.origo;

import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import net.sourceforge.cruisecontrol.publishers.OrigoPublisher;
import org.apache.log4j.Logger;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;

public class OrigoApiClient {
    private static final Logger LOG = Logger.getLogger(OrigoPublisher.class);
    private final XmlRpcClient client;

    public OrigoApiClient(URL apiUrl) {
        this.client = new XmlRpcClient(apiUrl);
    }

    protected synchronized Object call(String method, Vector params) throws XmlRpcException, IOException {
        LOG.debug((Object)("Executing call " + method + " " + params));
        return this.client.execute(method, params);
    }

    public String login(String userKey, String applicationKey) throws XmlRpcException, IOException {
        Vector<String> params = new Vector<String>();
        params.addElement(userKey);
        params.addElement(applicationKey);
        return (String)this.call("user.login_key", params);
    }

    public Integer retrieveProjectId(String session, String projectName) throws XmlRpcException, IOException {
        Vector<String> params = new Vector<String>();
        params.addElement(session);
        params.addElement(projectName);
        return (Integer)this.call("project.retrieve_id", params);
    }

    public Vector searchIssue(String session, Integer projectId, Hashtable searchArgs) throws XmlRpcException, IOException {
        Vector<Object> params = new Vector<Object>();
        params.addElement(session);
        params.addElement(projectId);
        params.addElement(searchArgs);
        return (Vector)this.call("issue.search", params);
    }

    public void extendedCommentIssue(String session, Integer projectId, Integer bugId, String description, String tags) throws XmlRpcException, IOException {
        Vector<Object> params = new Vector<Object>();
        params.addElement(session);
        params.addElement(projectId);
        params.addElement(bugId);
        params.addElement(description);
        params.addElement(tags);
        this.call("issue.comment_extended", params);
    }

    public void addIssue(String session, Integer projectId, String issueSubject, String issueDescription, String issueTag, Boolean issuePrivate) throws XmlRpcException, IOException {
        Vector<Object> params = new Vector<Object>();
        params.addElement(session);
        params.addElement(projectId);
        params.addElement(issueSubject);
        params.addElement(issueDescription);
        params.addElement(issueTag);
        params.addElement(issuePrivate);
        this.call("issue.add", params);
    }
}

