/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.publishers.email;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.publishers.email.EmailAddressMapper;
import net.sourceforge.cruisecontrol.util.ValidationHelper;

public class PropertiesMapper
extends EmailAddressMapper {
    private String file = null;
    private final Properties props = new Properties();

    public void setFile(String file) {
        this.file = file;
    }

    public String getFile() {
        return this.file;
    }

    public void validate() throws CruiseControlException {
        ValidationHelper.assertIsSet((Object)this.file, "file", this.getClass());
        ValidationHelper.assertFalse(this.file.equals(""), "empty string is not a valid value of file for " + this.getClass().getName());
        File f = new File(this.file);
        ValidationHelper.assertExists(f, "file", this.getClass());
        ValidationHelper.assertIsReadable(f, "file", this.getClass());
        if (!f.isFile()) {
            throw new CruiseControlException(this.file + " is not a file");
        }
    }

    public void open() throws CruiseControlException {
        File f = new File(this.getFile());
        try {
            this.props.load(new BufferedInputStream(new FileInputStream(f)));
        }
        catch (IOException ie) {
            throw new CruiseControlException(ie);
        }
    }

    public void close() {
        this.props.clear();
    }

    public String mapUser(String user) {
        return this.props.getProperty(user);
    }
}

