/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.publishers.email;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sourceforge.cruisecontrol.publishers.EmailPublisher;
import net.sourceforge.cruisecontrol.publishers.email.EmailMapper;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmailMapperHelper
implements Serializable {
    private static final long serialVersionUID = 3831878181334595122L;
    private static final Logger LOG = Logger.getLogger(EmailMapperHelper.class);
    private static final Map<Object, Map<String, String>> CACHE = new Hashtable<Object, Map<String, String>>();

    public static void addCacheEntry(Object cache, String user, String mappedUser) {
        Map<String, String> map = CACHE.get(cache);
        if (map == null) {
            map = new Hashtable<String, String>();
            CACHE.put(cache, map);
        }
        map.put(user, mappedUser);
    }

    public static String getCachedUser(Object cache, String user) {
        String mappedUser = null;
        Map<String, String> map = CACHE.get(cache);
        if (map != null) {
            mappedUser = map.get(user);
        }
        return mappedUser;
    }

    public void mapUsers(EmailPublisher publisher, Set<String> users, Set<String> mappedUsers) {
        Iterator<String> userIterator = users.iterator();
        while (userIterator.hasNext()) {
            String user = userIterator.next();
            String mappedUser = EmailMapperHelper.getCachedUser(publisher, user);
            if (mappedUser == null) continue;
            LOG.debug((Object)("User " + user + " found in cache.  Mapped to: " + mappedUser));
            userIterator.remove();
            mappedUsers.add(mappedUser);
        }
        EmailMapper[] mappers = publisher.getEmailMapper();
        for (int i = 0; i < mappers.length; ++i) {
            mappers[i].mapUsers(users, mappedUsers);
        }
        Iterator<String> userIterator2 = users.iterator();
        while (userIterator2.hasNext()) {
            mappedUsers.add(userIterator2.next());
            userIterator2.remove();
        }
    }
}

