/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.publishers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Publisher;
import net.sourceforge.cruisecontrol.util.IO;
import net.sourceforge.cruisecontrol.util.Util;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import net.sourceforge.cruisecontrol.util.XMLLogHelper;
import org.apache.log4j.Logger;
import org.jdom.Element;
import org.jdom.transform.JDOMSource;

public class XSLTLogPublisher
implements Publisher {
    private static final Logger LOG = Logger.getLogger(XSLTLogPublisher.class);
    private String directory;
    private String xsltFile;
    private boolean publishOnFail = true;
    private String outFileName;

    public void setXsltFile(String fileName) {
        this.xsltFile = fileName;
    }

    public void setOutFileName(String name) {
        this.outFileName = name;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public void setPublishOnFail(boolean pof) {
        this.publishOnFail = pof;
    }

    public void validate() throws CruiseControlException {
        ValidationHelper.assertIsSet((Object)this.xsltFile, "xsltFile", this.getClass());
        ValidationHelper.assertIsSet((Object)this.directory, "directory", this.getClass());
    }

    public void publish(Element cruisecontrolLog) throws CruiseControlException {
        XMLLogHelper helper = new XMLLogHelper(cruisecontrolLog);
        Boolean buildSuccess = null;
        try {
            buildSuccess = helper.isBuildSuccessful() ? Boolean.TRUE : Boolean.FALSE;
        }
        catch (NullPointerException ne) {
            // empty catch block
        }
        if (cruisecontrolLog == null || buildSuccess == null) {
            return;
        }
        if (!buildSuccess.booleanValue() && !this.publishOnFail) {
            LOG.info((Object)"Build failed and publishOnFail is false: Not publishing log.");
            return;
        }
        if (this.outFileName == null) {
            String label = helper.getCruiseControlInfoProperty("label");
            if (label == null || label.trim().length() == 0) {
                throw new CruiseControlException("The Label property is not set in the log file...unable to publish the log.");
            }
            LOG.debug((Object)("Using the cruise control info label property to construct the file name which is set to: " + label));
            this.outFileName = label + ".log";
        }
        File dir = new File(this.directory);
        Util.doMkDirs(dir);
        if (!dir.isDirectory()) {
            throw new CruiseControlException("Unable to locate or create the output directory (" + this.directory + "): Failed to publish log file.");
        }
        String filePath = this.directory + File.separator + this.outFileName;
        LOG.info((Object)("Publishing log file to: " + filePath));
        this.writeFile(cruisecontrolLog, filePath);
        LOG.info((Object)("Log file successfully published to the file at path: " + filePath));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void writeFile(Element cruisecontrolLog, String path) throws CruiseControlException {
        FileInputStream xslFileStream = null;
        FileOutputStream out = null;
        try {
            try {
                xslFileStream = new FileInputStream(this.xsltFile);
            }
            catch (IOException ioe) {
                throw new CruiseControlException("Error reading the xsltFile: " + this.xsltFile, ioe);
            }
            try {
                out = new FileOutputStream(path);
            }
            catch (IOException ioe) {
                throw new CruiseControlException("Unable to write to the file location: " + path);
            }
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer(new StreamSource(xslFileStream));
            XMLLogHelper helper = new XMLLogHelper(cruisecontrolLog);
            String logFileName = helper.getLogFileName();
            LOG.info((Object)("Transforming the log file: " + logFileName + " to: " + path + " using the xslt: " + this.xsltFile));
            transformer.transform((Source)new JDOMSource(cruisecontrolLog), new StreamResult(out));
        }
        catch (TransformerException te) {
            try {
                throw new CruiseControlException("An error occurred during the transformation process", te);
                catch (Exception ioe) {
                    throw new CruiseControlException("An unexpected exception occurred, unable to publish the log file.", ioe);
                }
            }
            catch (Throwable throwable) {
                IO.close(xslFileStream);
                IO.close(out);
                throw throwable;
            }
        }
        IO.close(xslFileStream);
        IO.close(out);
    }
}

