/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.publishers;

import com.jpeterson.x10.Gateway;
import com.jpeterson.x10.GatewayException;
import com.jpeterson.x10.SerialGateway;
import com.jpeterson.x10.Transmitter;
import com.jpeterson.x10.event.AddressEvent;
import com.jpeterson.x10.event.OffEvent;
import com.jpeterson.x10.event.OnEvent;
import com.jpeterson.x10.event.X10Event;
import com.jpeterson.x10.module.CM11A;
import com.jpeterson.x10.module.CM17A;
import java.io.IOException;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Publisher;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import net.sourceforge.cruisecontrol.util.XMLLogHelper;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class X10Publisher
implements Publisher {
    private static final Logger LOG = Logger.getLogger(X10Publisher.class);
    private String houseCode;
    private String deviceCode;
    private String port;
    private boolean onWhenBroken = true;
    private String interfaceModel;

    public void publish(Element cruisecontrolLog) throws CruiseControlException {
        XMLLogHelper logHelper = new XMLLogHelper(cruisecontrolLog);
        this.handleBuild(!logHelper.isBuildSuccessful());
    }

    public void handleBuild(boolean isBroken) throws CruiseControlException {
        if (isBroken && this.onWhenBroken || !isBroken && !this.onWhenBroken) {
            this.turnOn();
        } else {
            this.turnOff();
        }
    }

    public void turnOn() throws CruiseControlException {
        char houseCodeChar = this.houseCode.charAt(0);
        int deviceCodeInt = Integer.valueOf(this.deviceCode);
        X10Event[] events = new X10Event[]{new AddressEvent((Object)this, houseCodeChar, deviceCodeInt), new OnEvent((Object)this, houseCodeChar)};
        this.send(events);
    }

    public void turnOff() throws CruiseControlException {
        char houseCodeChar = this.houseCode.charAt(0);
        int deviceCodeInt = Integer.valueOf(this.deviceCode);
        X10Event[] events = new X10Event[]{new AddressEvent((Object)this, houseCodeChar, deviceCodeInt), new OffEvent((Object)this, houseCodeChar)};
        this.send(events);
    }

    private void send(X10Event[] events) throws CruiseControlException {
        LOG.info((Object)"Sending X10 events...");
        Transmitter transmitter = this.getTransmitter();
        if (this.port != null) {
            ((SerialGateway)transmitter).setPortName(this.port);
        }
        try {
            ((Gateway)transmitter).allocate();
        }
        catch (Exception e) {
            throw new CruiseControlException("Trouble allocating the x10 gateway.", e);
        }
        for (int j = 0; j < events.length; ++j) {
            LOG.debug((Object)("Transmitting: " + events[j]));
            try {
                transmitter.transmit(events[j]);
                continue;
            }
            catch (IOException e) {
                throw new CruiseControlException("Trouble transmitting event " + events[j], e);
            }
        }
        if (transmitter instanceof Gateway) {
            Gateway gateway = (Gateway)transmitter;
            try {
                LOG.debug((Object)"Wait for empty queue...");
                gateway.waitGatewayState(64L);
                LOG.debug((Object)"Done");
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            LOG.debug((Object)"Deallocating...");
            try {
                gateway.deallocate();
            }
            catch (GatewayException e) {
                LOG.warn((Object)("Error deallocation gateway: " + e.getMessage()), (Throwable)e);
            }
            LOG.debug((Object)"Done");
        }
        LOG.debug((Object)"Done sending X10 events...");
    }

    protected Transmitter getTransmitter() throws CruiseControlException {
        if (this.interfaceModel != null && this.interfaceModel.equalsIgnoreCase("CM17A")) {
            return new CM17A();
        }
        if (this.interfaceModel == null || this.interfaceModel.equals("") || this.interfaceModel.equalsIgnoreCase("CM11A")) {
            return new CM11A();
        }
        throw new CruiseControlException("Unknown interface model specified [" + this.interfaceModel + "].");
    }

    public void validate() throws CruiseControlException {
        ValidationHelper.assertFalse(this.houseCode == null || this.deviceCode == null, "Both houseCode and deviceCode are required fields.");
        ValidationHelper.assertTrue(X10Publisher.isLegalHouseCode(this.houseCode), "The house code must be a single alphabetic letter between A and P, inclusive. You specified [" + this.houseCode + "].");
        ValidationHelper.assertTrue(X10Publisher.isLegalDeviceCode(this.deviceCode), "The device code must be an integer between 1 and 16, inclusive. You specified [" + this.deviceCode + "]");
        ValidationHelper.assertTrue(X10Publisher.isLegalInterfaceModel(this.interfaceModel), "The interface model must is not a legal value. You specified [" + this.deviceCode + "]");
    }

    private static boolean isLegalInterfaceModel(String model) {
        return model == null || "".equals(model) || "cm11a".equalsIgnoreCase(model) || "cm17a".equalsIgnoreCase(model);
    }

    private static boolean isLegalDeviceCode(String deviceCode) {
        return "1".equals(deviceCode) || "2".equals(deviceCode) || "3".equals(deviceCode) || "4".equals(deviceCode) || "5".equals(deviceCode) || "6".equals(deviceCode) || "7".equals(deviceCode) || "8".equals(deviceCode) || "9".equals(deviceCode) || "10".equals(deviceCode) || "11".equals(deviceCode) || "12".equals(deviceCode) || "13".equals(deviceCode) || "14".equals(deviceCode) || "15".equals(deviceCode) || "16".equals(deviceCode);
    }

    private static boolean isLegalHouseCode(String houseCode) {
        return "A".equalsIgnoreCase(houseCode) || "B".equalsIgnoreCase(houseCode) || "C".equalsIgnoreCase(houseCode) || "D".equalsIgnoreCase(houseCode) || "E".equalsIgnoreCase(houseCode) || "F".equalsIgnoreCase(houseCode) || "G".equalsIgnoreCase(houseCode) || "H".equalsIgnoreCase(houseCode) || "I".equalsIgnoreCase(houseCode) || "J".equalsIgnoreCase(houseCode) || "K".equalsIgnoreCase(houseCode) || "L".equalsIgnoreCase(houseCode) || "M".equalsIgnoreCase(houseCode) || "N".equalsIgnoreCase(houseCode) || "O".equalsIgnoreCase(houseCode) || "P".equalsIgnoreCase(houseCode);
    }

    public void setHouseCode(String code) {
        this.houseCode = code;
    }

    public void setDeviceCode(String code) {
        this.deviceCode = code;
    }

    public void setPort(String portName) {
        this.port = portName;
    }

    public void setOnWhenBroken(boolean shouldTurnOn) {
        this.onWhenBroken = shouldTurnOn;
    }

    public void setInterfaceModel(String model) {
        this.interfaceModel = model;
    }
}

