/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.publishers;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Publisher;
import net.sourceforge.cruisecontrol.util.XMLLogHelper;
import org.apache.log4j.Logger;
import org.apache.xmlrpc.XmlRpcClient;
import org.jdom.Element;

public class WeblogPublisher
implements Publisher {
    private static final long serialVersionUID = -34809809594503919L;
    private static final Logger LOG = Logger.getLogger(WeblogPublisher.class);
    private static final String APP_KEY = "CruiseControl Blog Publisher";
    private static final String DEFAULT_API = "metaweblog";
    private static final String DEFAULT_REPORTSUCCESS = "always";
    private static final boolean DEFAULT_SPAMWHILEBROKEN = true;
    private String blogId;
    private String api = "metaweblog";
    private String username;
    private String password;
    private String category = "";
    private String blogUrl;
    private String buildResultsURL;
    private String reportSuccess = "always";
    private boolean spamWhileBroken = true;
    private String subjectPrefix;
    private String xslFile;
    private String xslDir;
    private String css;
    private String logDir;
    private String[] xslFileNames = new String[]{"header.xsl", "maven.xsl", "checkstyle.xsl", "compile.xsl", "javadoc.xsl", "unittests.xsl", "modifications.xsl", "distributables.xsl"};
    private static final Map API_CLIENTS = new HashMap();

    public void setXSLFile(String fullPathToXslFile) {
        this.xslFile = fullPathToXslFile;
    }

    public void setXSLDir(String xslDirectory) {
        this.xslDir = xslDirectory;
    }

    protected void setXSLFileNames(String[] fileNames) {
        if (fileNames == null) {
            throw new IllegalArgumentException("xslFileNames can't be null (but can be empty)");
        }
        this.xslFileNames = fileNames;
    }

    protected String[] getXslFileNames() {
        return this.xslFileNames;
    }

    public void setCSS(String cssFilename) {
        this.css = cssFilename;
    }

    public void setLogDir(String directory) {
        if (directory == null) {
            throw new IllegalArgumentException("logDir cannot be null!");
        }
        this.logDir = directory;
    }

    public void setApi(String api) {
        this.api = api;
    }

    public void setBlogId(String blogId) {
        this.blogId = blogId;
    }

    public void setBlogUrl(String blogUrl) {
        this.blogUrl = blogUrl;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public void setSubjectPrefix(String prefix) {
        this.subjectPrefix = prefix;
    }

    public void setBuildResultsURL(String url) {
        this.buildResultsURL = url;
    }

    public void setReportSuccess(String reportSuccess) {
        this.reportSuccess = reportSuccess;
    }

    public void setSpamWhileBroken(boolean spamWhileBroken) {
        this.spamWhileBroken = spamWhileBroken;
    }

    public void publish(Element cruisecontrolLog) {
        XMLLogHelper helper = new XMLLogHelper(cruisecontrolLog);
        try {
            if (this.shouldSend(helper)) {
                this.postBlogEntry(this.createSubject(helper), this.createMessage(helper.getProjectName(), helper.getLogFileName()));
            } else {
                LOG.debug((Object)"shouldSend() indicated we should not post a blog entry at this time");
            }
        }
        catch (CruiseControlException e) {
            LOG.error((Object)"", (Throwable)e);
        }
    }

    public BloggingApi getBloggingApiImplementation(String apiName) throws CruiseControlException {
        Class implClass = (Class)API_CLIENTS.get(apiName);
        if (implClass != null) {
            LOG.debug((Object)("Mapped " + apiName + " to " + implClass.getName()));
            try {
                return (BloggingApi)implClass.newInstance();
            }
            catch (Exception e) {
                throw new CruiseControlException("Failed to instantiate Blogging API implementation, " + implClass.getName() + ", due to a " + e.getClass().getName() + ": " + e.getMessage());
            }
        }
        return null;
    }

    public void postBlogEntry(String subject, String content) {
        LOG.debug((Object)("Posting a blog entry to " + this.blogUrl));
        LOG.debug((Object)("    blogId=" + this.blogId));
        LOG.debug((Object)("    username=" + this.username));
        LOG.debug((Object)("    subject=" + subject));
        LOG.debug((Object)("    content=" + content));
        try {
            BloggingApi apiClient = this.getBloggingApiImplementation(this.api);
            if (apiClient != null) {
                Object postId = apiClient.newPost(this.blogUrl, this.blogId, this.username, this.password, this.category, subject, content);
                if (postId != null) {
                    LOG.info((Object)("Blog entry " + postId + " created at " + this.blogUrl));
                } else {
                    LOG.debug((Object)("Blog entry ID not available from " + this.blogUrl));
                }
            } else {
                LOG.error((Object)("No API associated with '" + this.api + "'"));
            }
        }
        catch (Exception e) {
            LOG.error((Object)"", (Throwable)e);
        }
    }

    public void validate() throws CruiseControlException {
        this.validateRequiredField("username", this.username);
        this.validateRequiredField("password", this.password);
        this.validateRequiredField("blogid", this.blogId);
        this.validateRequiredField("blogurl", this.blogUrl);
        this.validateURL("blogurl", this.blogUrl);
        this.validateOneOf("api", API_CLIENTS.keySet(), this.api);
        if (this.buildResultsURL != null) {
            this.validateURL("buildresultsurl", this.buildResultsURL);
        }
        if (this.logDir != null) {
            this.verifyDirectory("WeblogPublisher.logDir", this.logDir);
        } else {
            LOG.info((Object)"Using default log directory \"logs/<projectname>\"");
        }
        if (this.xslFile == null) {
            this.verifyDirectory("WeblogPublisher.xslDir", this.xslDir);
            this.verifyFile("WeblogPublisher.css", this.css);
            String[] fileNames = this.getXslFileNames();
            if (fileNames == null) {
                throw new CruiseControlException("WeblogPublisher.getXslFileNames() can't return null");
            }
            for (int i = 0; i < fileNames.length; ++i) {
                this.verifyFile("WeblogPublisher.xslDir/" + fileNames[i], new File(this.xslDir, fileNames[i]));
            }
        } else {
            this.verifyFile("WeblogPublisher.xslFile", this.xslFile);
        }
    }

    private void validateOneOf(String fieldName, Collection validValues, String value) throws CruiseControlException {
        if (!validValues.contains(value)) {
            throw new CruiseControlException("Value for '" + fieldName + "' must be one of " + this.commaSeparated(validValues));
        }
    }

    private String commaSeparated(Collection values) {
        StringBuffer s = new StringBuffer();
        Iterator i = values.iterator();
        while (i.hasNext()) {
            s.append("'").append(i.next()).append("'");
            if (!i.hasNext()) continue;
            s.append(", ");
        }
        return s.toString();
    }

    private void validateURL(String fieldName, String url) throws CruiseControlException {
        try {
            new URL(url);
        }
        catch (MalformedURLException e) {
            throw new CruiseControlException(fieldName + " must be a valid URL: " + url);
        }
    }

    private void validateRequiredField(String fieldName, String value) throws CruiseControlException {
        if (value == null) {
            throw new CruiseControlException("Attribute " + fieldName + " is required.");
        }
    }

    private void verifyDirectory(String dirName, String dir) throws CruiseControlException {
        if (dir == null) {
            throw new CruiseControlException(dirName + " not specified in configuration file");
        }
        File dirFile = new File(dir);
        if (!dirFile.exists()) {
            throw new CruiseControlException(dirName + " does not exist : " + dirFile.getAbsolutePath());
        }
        if (!dirFile.isDirectory()) {
            throw new CruiseControlException(dirName + " is not a directory : " + dirFile.getAbsolutePath());
        }
    }

    private void verifyFile(String fileName, String file) throws CruiseControlException {
        if (file == null) {
            throw new CruiseControlException(fileName + " not specified in configuration file");
        }
        this.verifyFile(fileName, new File(file));
    }

    private void verifyFile(String fileName, File file) throws CruiseControlException {
        if (!file.exists()) {
            throw new CruiseControlException(fileName + " does not exist: " + file.getAbsolutePath());
        }
        if (!file.isFile()) {
            throw new CruiseControlException(fileName + " is not a file: " + file.getAbsolutePath());
        }
    }

    boolean shouldSend(XMLLogHelper logHelper) throws CruiseControlException {
        if (logHelper.isBuildSuccessful()) {
            return this.shouldSendForSuccessfulBuild(logHelper);
        }
        return this.shouldSendForFailedBuild(logHelper);
    }

    boolean shouldSendForFailedBuild(XMLLogHelper logHelper) throws CruiseControlException {
        if (!logHelper.wasPreviousBuildSuccessful() && logHelper.isBuildNecessary() && !this.spamWhileBroken) {
            LOG.debug((Object)"spamWhileBroken is false, not sending email");
            return false;
        }
        return true;
    }

    boolean shouldSendForSuccessfulBuild(XMLLogHelper logHelper) throws CruiseControlException {
        if (this.reportSuccess.equalsIgnoreCase(DEFAULT_REPORTSUCCESS)) {
            return true;
        }
        if (this.reportSuccess.equalsIgnoreCase("never")) {
            return false;
        }
        if (this.reportSuccess.equalsIgnoreCase("fixes") && logHelper.wasPreviousBuildSuccessful()) {
            LOG.debug((Object)"reportSuccess is set to 'fixes', not sending emails for repeated successful builds.");
            return false;
        }
        return true;
    }

    String createSubject(XMLLogHelper logHelper) throws CruiseControlException {
        String projectName = logHelper.getProjectName();
        String label = logHelper.getLabel();
        boolean buildSuccessful = logHelper.isBuildSuccessful();
        boolean isFix = logHelper.isBuildFix();
        return this.createSubject(projectName, label, buildSuccessful, isFix);
    }

    String createSubject(String projectName, String label, boolean buildSuccessful, boolean isFix) throws CruiseControlException {
        StringBuffer subject = new StringBuffer();
        if (this.subjectPrefix != null && this.subjectPrefix.trim().length() > 0) {
            subject.append(this.subjectPrefix).append(" ");
        }
        subject.append(projectName);
        if (buildSuccessful) {
            if (label.length() > 0) {
                subject.append(" ").append(label);
            }
            subject.append(isFix ? " - Build Fixed" : " - Build Successful");
        } else {
            subject.append(" - Build Failed");
        }
        return subject.toString();
    }

    String createMessage(String projectName, String logFileName) {
        String message;
        File inFile = null;
        try {
            if (this.logDir == null) {
                this.logDir = this.getDefaultLogDir(projectName);
            }
            inFile = new File(this.logDir, logFileName);
            message = this.transform(inFile);
        }
        catch (Exception ex) {
            LOG.error((Object)("error transforming " + (inFile != null ? inFile.getAbsolutePath() : "")), (Throwable)ex);
            message = this.createLinkLine(logFileName);
        }
        return message;
    }

    String getDefaultLogDir(String projectName) throws CruiseControlException {
        return "logs" + File.separator + projectName;
    }

    String transform(File xml) throws TransformerException, IOException {
        StringBuffer messageBuffer = new StringBuffer();
        if (this.xslFile != null) {
            this.transformWithSingleStylesheet(xml, messageBuffer);
        } else {
            messageBuffer.append(this.createLinkLine(xml.getName()));
            this.transformWithMultipleStylesheets(xml, messageBuffer);
        }
        return messageBuffer.toString();
    }

    void transformWithMultipleStylesheets(File inFile, StringBuffer messageBuffer) throws IOException, TransformerException {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        File xslDirectory = new File(this.xslDir);
        String[] fileNames = this.getXslFileNames();
        for (int i = 0; i < fileNames.length; ++i) {
            String fileName = fileNames[i];
            File xsl = new File(xslDirectory, fileName);
            messageBuffer.append("<p>\n");
            this.appendTransform(inFile, xsl, messageBuffer, tFactory);
        }
    }

    void transformWithSingleStylesheet(File inFile, StringBuffer messageBuffer) throws IOException, TransformerException {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        this.appendTransform(inFile, new File(this.xslFile), messageBuffer, tFactory);
    }

    void appendTransform(File xml, File xsl, StringBuffer messageBuffer, TransformerFactory tFactory) throws TransformerException {
        LOG.debug((Object)("Transforming file " + xml.getName() + " with " + xsl.getName() + " ..."));
        Transformer tformer = tFactory.newTransformer(new StreamSource(xsl));
        StringWriter sw = new StringWriter();
        try {
            tformer.transform(new StreamSource(xml), new StreamResult(sw));
            LOG.debug((Object)("Transformed file " + xml.getName() + " with " + xsl.getName() + " ..."));
        }
        catch (Exception e) {
            LOG.error((Object)("error transforming with xslFile " + xsl.getName()), (Throwable)e);
            return;
        }
        messageBuffer.append(sw.toString());
    }

    String createLinkLine(String logFileName) {
        if (this.buildResultsURL == null) {
            return "";
        }
        String url = this.createBuildResultsUrl(logFileName);
        StringBuffer linkLine = new StringBuffer();
        linkLine.append("<p>View results here -&gt; <a href=\"");
        linkLine.append(url);
        linkLine.append("\">");
        linkLine.append(url);
        linkLine.append("</a></p>");
        return linkLine.toString();
    }

    String createBuildResultsUrl(String logFileName) {
        int startName = logFileName.lastIndexOf(File.separator) + 1;
        int endName = logFileName.lastIndexOf(".");
        String baseLogFileName = logFileName.substring(startName, endName);
        StringBuffer url = new StringBuffer(this.buildResultsURL);
        if (this.buildResultsURL.indexOf("?") == -1) {
            url.append("?");
        } else {
            url.append("&");
        }
        url.append("log=");
        url.append(baseLogFileName);
        return url.toString();
    }

    static {
        API_CLIENTS.put(DEFAULT_API, MetaWeblogApiClient.class);
        API_CLIENTS.put("blogger", BloggerApiClient.class);
        API_CLIENTS.put("livejournal", LiveJournalApiClient.class);
    }

    public static class LiveJournalApiClient
    implements BloggingApi {
        private static final long serialVersionUID = -372653261263803994L;

        private String stripLineFeeds(String input) {
            StringBuffer s = new StringBuffer();
            char[] chars = input.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                if (chars[i] == '\n' || chars[i] == '\r') continue;
                s.append(chars[i]);
            }
            return s.toString();
        }

        public Object newPost(String blogUrl, String blogId, String username, String password, String category, String subject, String content) {
            Object postId = null;
            try {
                XmlRpcClient xmlrpc = new XmlRpcClient(blogUrl);
                Vector params = new Vector();
                Hashtable<String, String> struct = new Hashtable<String, String>();
                struct.put("username", username);
                struct.put("auth_method", "clear");
                struct.put("password", password);
                struct.put("subject", subject);
                struct.put("event", this.stripLineFeeds(content));
                struct.put("lineendings", "\n");
                struct.put("security", "public");
                Calendar now = Calendar.getInstance();
                struct.put("year", "" + now.get(1));
                struct.put("mon", "" + (now.get(2) + 1));
                struct.put("day", "" + now.get(5));
                struct.put("hour", "" + now.get(11));
                struct.put("min", "" + now.get(12));
                params.add(struct);
                postId = xmlrpc.execute("LJ.XMLRPC.postevent", params);
            }
            catch (Exception e) {
                LOG.error((Object)"", (Throwable)e);
            }
            return postId;
        }
    }

    public static class MetaWeblogApiClient
    implements BloggingApi {
        private static final long serialVersionUID = 5980798548858885672L;

        public Object newPost(String blogUrl, String blogId, String username, String password, String category, String subject, String content) {
            Object postId = null;
            try {
                XmlRpcClient xmlrpc = new XmlRpcClient(blogUrl);
                Vector<Object> params = new Vector<Object>();
                params.add(blogId);
                params.add(username);
                params.add(password);
                Hashtable<String, Object> struct = new Hashtable<String, Object>();
                struct.put("title", subject);
                struct.put("description", content);
                Vector<String> categories = new Vector<String>();
                if (category != null) {
                    StringTokenizer tok = new StringTokenizer(category, ",");
                    while (tok.hasMoreTokens()) {
                        categories.add(tok.nextToken().trim());
                    }
                }
                struct.put("categories", categories);
                params.add(struct);
                params.add(Boolean.TRUE);
                postId = xmlrpc.execute("metaWeblog.newPost", params);
            }
            catch (Exception e) {
                LOG.error((Object)"", (Throwable)e);
            }
            return postId;
        }
    }

    public static class BloggerApiClient
    implements BloggingApi {
        private static final long serialVersionUID = 6614787780439141028L;

        public Object newPost(String blogUrl, String blogId, String username, String password, String category, String subject, String content) {
            content = "<title>" + subject + "</title>" + content;
            Object postId = null;
            try {
                XmlRpcClient xmlrpc = new XmlRpcClient(blogUrl);
                Vector<Object> params = new Vector<Object>();
                params.add(WeblogPublisher.APP_KEY);
                params.add(blogId);
                params.add(username);
                params.add(password);
                params.add(content);
                params.add(Boolean.TRUE);
                postId = xmlrpc.execute("blogger.newPost", params);
            }
            catch (Exception e) {
                LOG.error((Object)"", (Throwable)e);
            }
            return postId;
        }
    }

    static interface BloggingApi
    extends Serializable {
        public Object newPost(String var1, String var2, String var3, String var4, String var5, String var6, String var7);
    }
}

