/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.publishers;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.rmi.UnknownHostException;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Publisher;
import net.sourceforge.cruisecontrol.publishers.SocketFactory;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import net.sourceforge.cruisecontrol.util.XMLLogHelper;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class SocketPublisher
implements Publisher {
    private static final Logger LOG = Logger.getLogger(SocketPublisher.class);
    private final SocketFactory factory;
    private String socketServer;
    private int port;
    private boolean isProjectNameSendingEnabled;
    private boolean isConsideringFixedEnabled;

    public SocketPublisher() {
        this(new SocketFactory(){

            public Socket createSocket(String server, int port) throws IOException {
                return new Socket(server, port);
            }
        });
    }

    public SocketPublisher(SocketFactory sf) {
        this.factory = sf;
        this.port = 0;
        this.isProjectNameSendingEnabled = true;
        this.isConsideringFixedEnabled = false;
    }

    public void validate() throws CruiseControlException {
        ValidationHelper.assertIsSet((Object)this.getSocketServer(), "socketServer", this.getClass());
        ValidationHelper.assertFalse(this.getPort() == 0, "'port' not specified for SocketPublisher");
    }

    public void publish(Element cruisecontrolLog) throws CruiseControlException {
        XMLLogHelper helper = new XMLLogHelper(cruisecontrolLog);
        try {
            StringBuffer messageBuffer = new StringBuffer();
            messageBuffer.append(this.getBuildResultRepresentationFor(helper));
            if (this.isProjectNameSendingEnabled) {
                messageBuffer.append(" ");
                messageBuffer.append(helper.getProjectName());
            }
            this.writeToSocket(messageBuffer.toString());
        }
        catch (IOException e) {
            throw new CruiseControlException(e);
        }
    }

    protected String getBuildResultRepresentationFor(XMLLogHelper helper) throws CruiseControlException {
        String result = "Failure";
        if (helper.isBuildSuccessful()) {
            result = "Success";
            if (this.isConsideringFixedEnabled && helper.isBuildFix()) {
                result = "Fixed";
            }
        }
        return result;
    }

    protected void writeToSocket(String result) throws IOException {
        Socket echoSocket = null;
        PrintWriter out = null;
        try {
            echoSocket = this.factory.createSocket(this.socketServer, this.getPort());
            out = new PrintWriter(echoSocket.getOutputStream(), true);
        }
        catch (UnknownHostException e) {
            LOG.error((Object)("Don't know about host:" + this.socketServer));
        }
        catch (IOException e) {
            LOG.error((Object)("Couldn't get I/O for the connection to:" + this.socketServer));
        }
        if (out != null) {
            out.write(result);
            out.close();
        }
        if (echoSocket != null) {
            echoSocket.close();
        }
    }

    public String getSocketServer() {
        return this.socketServer;
    }

    public void setSocketServer(String port) {
        this.socketServer = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setPort(String port) {
        this.port = Integer.parseInt(port);
    }

    public void setSendProjectName(boolean state) {
        this.isProjectNameSendingEnabled = state;
    }

    public void setSendFixed(boolean state) {
        this.isConsideringFixedEnabled = state;
    }
}

