/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.publishers;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Publisher;
import net.sourceforge.cruisecontrol.util.Commandline;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import net.sourceforge.cruisecontrol.util.XMLLogHelper;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class SCPPublisher
implements Publisher {
    private static final Logger LOG = Logger.getLogger(SCPPublisher.class);
    private String executableName = "scp";
    private String sourceUser;
    private String sourceHost;
    private String sourceDir = ".";
    private String targetUser;
    private String targetHost;
    private String targetDir = ".";
    private String ssh = "ssh";
    private String options;
    private String file;
    private String targetSeparator = File.separator;
    private String sourceSeparator = File.separator;

    public void setExecutableName(String executableName) {
        this.executableName = executableName;
    }

    public void setSourceUser(String sourceUser) {
        this.sourceUser = sourceUser;
    }

    public void setSourceHost(String sourceHost) {
        this.sourceHost = sourceHost;
    }

    public void setSourceDir(String sourceDir) {
        this.sourceDir = sourceDir;
    }

    public void setTargetUser(String targetUser) {
        this.targetUser = targetUser;
    }

    public void setTargetHost(String targetHost) {
        this.targetHost = targetHost;
    }

    public void setTargetDir(String targetDir) {
        this.targetDir = targetDir;
    }

    public void setSSH(String ssh) {
        this.ssh = ssh;
    }

    public void setOptions(String options) {
        this.options = options;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public void setTargetSeparator(String targetSeparator) {
        this.targetSeparator = targetSeparator;
    }

    public void setSourceSeparator(String sourceSeparator) {
        this.sourceSeparator = sourceSeparator;
    }

    public void validate() throws CruiseControlException {
        ValidationHelper.assertIsSet((Object)this.executableName, "executableName", this.getClass());
        ValidationHelper.assertNotEmpty(this.executableName, "executableName", this.getClass());
        ValidationHelper.assertFalse(this.sourceUser == null && this.sourceHost != null, "'sourceuser' not specified in configuration file");
        ValidationHelper.assertFalse(this.sourceHost == null && this.sourceUser != null, "'sourcehost' not specified in configuration file");
        ValidationHelper.assertFalse(this.targetUser == null && this.targetHost != null, "'targetuser' not specified in configuration file");
        ValidationHelper.assertFalse(this.targetHost == null && this.targetUser != null, "'targethost' not specified in configuration file");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(Element cruisecontrolLog) throws CruiseControlException {
        boolean publishCurrentLogFile;
        boolean bl = publishCurrentLogFile = this.file == null;
        if (publishCurrentLogFile) {
            this.file = this.getLogFileName(cruisecontrolLog);
            LOG.debug((Object)this.file);
        }
        try {
            Commandline command = this.createCommandline(this.file);
            this.executeCommand(command);
        }
        finally {
            if (publishCurrentLogFile) {
                this.file = null;
            }
        }
    }

    protected String getLogFileName(Element cruisecontrolLog) throws CruiseControlException {
        XMLLogHelper helper = new XMLLogHelper(cruisecontrolLog);
        return helper.getLogFileName();
    }

    protected void executeCommand(Commandline command) throws CruiseControlException {
        LOG.info((Object)("executing command: " + command));
        try {
            Process p = command.execute();
            LOG.debug((Object)"Runtime after.");
            p.waitFor();
            LOG.debug((Object)("waitfor() ended with exit code " + p.exitValue()));
            try {
                String outputLine;
                BufferedReader commandErrorResult = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                while ((outputLine = commandErrorResult.readLine()) != null) {
                    LOG.warn((Object)("Runtime.exec error returned: " + outputLine));
                }
            }
            catch (IOException e) {
                LOG.warn((Object)"Runtime.exec: reading errorStream failed");
                throw new CruiseControlException(e);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Runtime.exec exception.");
            throw new CruiseControlException(e);
        }
    }

    protected Commandline createCommandline(String file) {
        String sourcefile = this.sourceSeparator + file;
        String targetfile = this.targetSeparator;
        Commandline command = new Commandline();
        command.setExecutable(this.executableName);
        command.createArgument().setLine(this.options);
        command.createArguments("-S", this.ssh);
        this.createFileArgument(command.createArgument(), this.sourceUser, this.sourceHost, this.sourceDir, sourcefile);
        this.createFileArgument(command.createArgument(), this.targetUser, this.targetHost, this.targetDir, targetfile);
        return command;
    }

    private void createFileArgument(Commandline.Argument arg, String user, String host, String dir, String file) {
        String argValue = "";
        if (user != null && host != null) {
            argValue = user + "@" + host + ":";
        }
        argValue = argValue + dir;
        argValue = argValue + file;
        arg.setValue(argValue);
    }
}

