/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.publishers;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Publisher;
import net.sourceforge.cruisecontrol.publishers.origo.OrigoApiClient;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import net.sourceforge.cruisecontrol.util.XMLLogHelper;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class OrigoPublisher
implements Publisher {
    private static final long serialVersionUID = 4476791333216452959L;
    private static final Logger LOG = Logger.getLogger(OrigoPublisher.class);
    private OrigoApiClient client;
    private static final String APPLICATION_KEY = "KEYFORTHEORIGOCRUISECONTROLPLUGI";
    private String apiURL = "http://api.origo.ethz.ch/api/xmlrpc";
    private String projectName;
    private String userKey;
    private String issueSubject = "Cruisecontrol failed";
    private String issueTag = "cruisecontrol::failed";
    private Boolean issuePrivate = Boolean.TRUE;
    private String buildResultsURL = "http://localhost:8180/";

    public void validate() throws CruiseControlException {
        ValidationHelper.assertIsSet((Object)this.getApiURL(), "apiurl", this.getClass());
        ValidationHelper.assertIsSet((Object)this.getUserKey(), "userkey", this.getClass());
        ValidationHelper.assertIsSet((Object)this.getProjectName(), "projectname", this.getClass());
        try {
            URL url = new URL(this.getApiURL());
            this.client = new OrigoApiClient(url);
        }
        catch (MalformedURLException e) {
            ValidationHelper.fail(this.getApiURL() + " is not a valid URL", e);
        }
    }

    public String createLinkURL(String logFileName) {
        if (this.buildResultsURL == null) {
            return "";
        }
        int startName = logFileName.lastIndexOf(File.separator) + 1;
        int endName = logFileName.lastIndexOf(".");
        String baseLogFileName = logFileName.substring(startName, endName);
        StringBuffer url = new StringBuffer(this.buildResultsURL);
        if (this.buildResultsURL.indexOf("?") == -1) {
            url.append("?");
        } else {
            url.append("&");
        }
        url.append("log=");
        url.append(baseLogFileName);
        return url.toString();
    }

    public void publish(Element cruisecontrolLog) throws CruiseControlException {
        XMLLogHelper helper = new XMLLogHelper(cruisecontrolLog);
        try {
            if (helper.isBuildFix()) {
                String session = this.client.login(this.userKey, APPLICATION_KEY);
                LOG.debug((Object)("Got session " + session));
                Integer projectId = this.client.retrieveProjectId(session, this.projectName);
                Hashtable<String, String> searchArgs = new Hashtable<String, String>();
                searchArgs.put("status", "open");
                searchArgs.put("tags", this.issueTag);
                Vector bugs = this.client.searchIssue(session, projectId, searchArgs);
                if (bugs.size() == 1) {
                    Hashtable bug = (Hashtable)bugs.get(0);
                    Integer bugId = (Integer)bug.get("issue_id");
                    LOG.info((Object)("Found bug with id" + bugId));
                    this.client.extendedCommentIssue(session, projectId, bugId, "Build fixed see: " + this.createLinkURL(helper.getLogFileName()), "status::closed," + this.issueTag);
                } else {
                    LOG.warn((Object)("Did not find exactly one match, found " + bugs.size() + " bugs."));
                }
            } else if (helper.wasPreviousBuildSuccessful() && !helper.isBuildSuccessful()) {
                String session = this.client.login(this.userKey, APPLICATION_KEY);
                LOG.debug((Object)("Got session " + session));
                Integer projectId = this.client.retrieveProjectId(session, this.projectName);
                String issueDescription = "Build failed see: " + this.createLinkURL(helper.getLogFileName());
                this.client.addIssue(session, projectId, this.issueSubject, issueDescription, "status::open," + this.issueTag, this.issuePrivate);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Problem during xmlrpc call", (Throwable)e);
            throw new CruiseControlException(e);
        }
    }

    public void setApiURL(String url) {
        this.apiURL = url;
    }

    public String getApiURL() {
        return this.apiURL;
    }

    public void setUserKey(String key) {
        this.userKey = key;
    }

    public String getUserKey() {
        return this.userKey;
    }

    public String getBuildResultsURL() {
        return this.buildResultsURL;
    }

    public void setBuildResultsURL(String buildResultsURL) {
        this.buildResultsURL = buildResultsURL;
    }

    public Boolean getIssuePrivate() {
        return this.issuePrivate;
    }

    public void setIssuePrivate(Boolean issuePrivate) {
        this.issuePrivate = issuePrivate;
    }

    public String getIssueSubject() {
        return this.issueSubject;
    }

    public void setIssueSubject(String issueSubject) {
        this.issueSubject = issueSubject;
    }

    public String getIssueTag() {
        return this.issueTag;
    }

    public void setIssueTag(String issueTag) {
        this.issueTag = issueTag;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setClient(OrigoApiClient client) {
        this.client = client;
    }
}

