/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.publishers;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Publisher;
import net.sourceforge.cruisecontrol.publishers.ExecutePublisher;
import net.sourceforge.cruisecontrol.util.NamedXPathAwareChild;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class HTTPPublisher
implements Publisher {
    private static final Logger LOG = Logger.getLogger(ExecutePublisher.class);
    private static final Set METHODS = new HashSet();
    private final Collection parameters = new ArrayList();
    private String urlString;
    private String requestMethod;
    private URL url;

    public void publish(Element cruisecontrolLog) throws CruiseControlException {
        HttpURLConnection conn = null;
        try {
            if ("GET".equals(this.requestMethod)) {
                String dataSet = this.createDataSet(cruisecontrolLog);
                if (dataSet.length() > 0) {
                    dataSet = "?" + dataSet;
                }
                this.url = new URL(this.urlString + dataSet);
                conn = (HttpURLConnection)this.url.openConnection();
                conn.setRequestMethod(this.requestMethod);
            } else {
                conn = (HttpURLConnection)this.url.openConnection();
                conn.setRequestMethod(this.requestMethod);
                conn.setDoOutput(true);
                OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
                wr.write(this.createDataSet(cruisecontrolLog));
                wr.flush();
            }
            LOG.info((Object)("Sending " + this.requestMethod + " to " + this.urlString));
            conn.connect();
            LOG.info((Object)("Returned: " + conn.getResponseCode() + " : " + conn.getResponseMessage()));
        }
        catch (IOException e) {
            throw new CruiseControlException(e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    public void validate() throws CruiseControlException {
        ValidationHelper.assertIsSet((Object)this.urlString, "urlString", this.getClass());
        try {
            this.url = new URL(this.urlString);
        }
        catch (MalformedURLException e) {
            ValidationHelper.fail("URL: " + this.urlString + " is not a valid URL", e);
        }
        ValidationHelper.assertTrue(METHODS.contains(this.requestMethod), "Request Method: " + this.requestMethod + " is mot a valid HTTP Request method");
        for (NamedXPathAwareChild parameter : this.parameters) {
            parameter.validate();
        }
    }

    public void setUrl(String url) {
        this.urlString = url;
    }

    public void setRequestMethod(String requestMethod) {
        this.requestMethod = requestMethod;
    }

    public NamedXPathAwareChild createParameter() {
        NamedXPathAwareChild parameter = new NamedXPathAwareChild();
        this.parameters.add(parameter);
        return parameter;
    }

    private String createDataSet(Element cruisecontrolLog) throws CruiseControlException {
        StringBuffer data = new StringBuffer();
        Iterator it = this.parameters.iterator();
        while (it.hasNext()) {
            NamedXPathAwareChild parameter = (NamedXPathAwareChild)it.next();
            String name = parameter.getName();
            String value = parameter.lookupValue(cruisecontrolLog);
            LOG.info((Object)("Adding request property: " + name + " = " + value));
            try {
                data.append(URLEncoder.encode(name, "UTF-8")).append("=").append(URLEncoder.encode(value, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new CruiseControlException("UTF-8 encoding not available", e);
            }
            if (!it.hasNext()) continue;
            data.append("&");
        }
        return data.toString();
    }

    static {
        METHODS.add("GET");
        METHODS.add("POST");
        METHODS.add("HEAD");
        METHODS.add("OPTIONS");
        METHODS.add("PUT");
        METHODS.add("DELETE");
        METHODS.add("TRACE");
    }
}

