/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.publishers;

import java.io.File;
import java.util.Vector;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Publisher;
import net.sourceforge.cruisecontrol.util.AbstractFTPClass;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import net.sourceforge.cruisecontrol.util.XMLLogHelper;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class FTPPublisher
extends AbstractFTPClass
implements Publisher {
    private static final Logger LOG = Logger.getLogger(FTPPublisher.class);
    private String destdir;
    private String srcdir;
    private boolean deleteArtifacts = false;

    public void setDestDir(String dir) {
        this.destdir = dir;
    }

    public void setSrcDir(String dir) {
        this.srcdir = dir;
    }

    public void setDeleteArtifacts(boolean shouldDelete) {
        this.deleteArtifacts = shouldDelete;
    }

    public void validate() throws CruiseControlException {
        ValidationHelper.assertIsSet((Object)this.destdir, "destdir", this.getClass());
        ValidationHelper.assertIsSet((Object)this.srcdir, "srcdir", this.getClass());
        super.validate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(Element cruisecontrolLog) throws CruiseControlException {
        XMLLogHelper helper = new XMLLogHelper(cruisecontrolLog);
        String uniqueDir = helper.getBuildTimestamp();
        File logDir = new File(this.srcdir + File.separator + uniqueDir);
        Vector knownDirs = new Vector();
        FTPClient ftp = null;
        try {
            ftp = this.openFTP();
            this.setBinary(ftp);
            String logName = this.getLogFileName(this.srcdir, uniqueDir);
            String lname = this.destdir + File.separator + logName;
            File lf = new File(this.srcdir, logName);
            if (lf.exists()) {
                this.makeDirsForFile(ftp, lname, knownDirs);
                this.sendFile(ftp, lf, lname);
                if (this.deleteArtifacts) {
                    lf.delete();
                }
            } else {
                LOG.info((Object)("Could not find build log file " + lf + "."));
            }
            if (logDir.exists()) {
                LOG.info((Object)("Sending log dir " + logDir + "."));
                this.ftpDir(logDir, ftp, this.destdir + File.separator + uniqueDir, knownDirs);
                LOG.info((Object)("Done sending log dir " + logDir + "."));
            } else {
                LOG.info((Object)("Could not find artifacts directory " + logDir + "."));
            }
        }
        catch (CruiseControlException e) {
            LOG.error((Object)"FTPPublisher.publish()", (Throwable)e);
        }
        finally {
            this.closeFTP(ftp);
        }
    }

    private void ftpDir(File basedir, FTPClient ftp, String destdir, Vector knownDirs) throws CruiseControlException {
        String[] fileList = basedir.list();
        if (fileList == null) {
            return;
        }
        for (int i = 0; i < fileList.length; ++i) {
            String fname = destdir + File.separator + fileList[i];
            File f = new File(basedir, fileList[i]);
            if (!f.exists()) continue;
            if (f.isDirectory()) {
                this.ftpDir(f, ftp, fname, knownDirs);
            } else {
                this.makeDirsForFile(ftp, fname, knownDirs);
                this.sendFile(ftp, f, fname);
            }
            if (!this.deleteArtifacts) continue;
            f.delete();
        }
    }

    private String getLogFileName(String srcdir, String uniqueDir) {
        File dir = new File(srcdir);
        String basename = "log" + uniqueDir;
        if (dir.exists() && dir.isDirectory()) {
            String[] list = dir.list();
            for (int i = 0; i < list.length; ++i) {
                if (!list[i].startsWith(basename) || !list[i].endsWith(".xml")) continue;
                return list[i];
            }
        }
        return basename + ".xml";
    }
}

