/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.publishers;

import java.io.IOException;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Publisher;
import net.sourceforge.cruisecontrol.util.Commandline;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class ExecutePublisher
implements Publisher {
    private static final Logger LOG = Logger.getLogger(ExecutePublisher.class);
    private String commandString;

    public void setCommand(String commandString) {
        this.commandString = commandString;
    }

    public void validate() throws CruiseControlException {
        ValidationHelper.assertIsSet((Object)this.commandString, "command", this.getClass());
    }

    public void publish(Element cruisecontrolLog) throws CruiseControlException {
        Commandline command = new Commandline(this.commandString);
        LOG.info((Object)("executing command: " + command));
        try {
            Process p = command.execute();
            p.waitFor();
            LOG.debug((Object)("waitfor() ended with exit code " + p.exitValue()));
        }
        catch (IOException e) {
            throw new CruiseControlException(e);
        }
        catch (InterruptedException e) {
            throw new CruiseControlException(e);
        }
    }
}

