/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.publishers;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Publisher;
import net.sourceforge.cruisecontrol.util.AbstractFTPClass;
import net.sourceforge.cruisecontrol.util.CurrentBuildFileWriter;
import net.sourceforge.cruisecontrol.util.Util;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import net.sourceforge.cruisecontrol.util.XMLLogHelper;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class CurrentBuildStatusFTPPublisher
extends AbstractFTPClass
implements Publisher {
    private static final Logger LOG = Logger.getLogger(CurrentBuildStatusFTPPublisher.class);
    private String fileName;
    private String destdir;

    public CurrentBuildStatusFTPPublisher() {
        LOG.warn((Object)"CurrentBuildStatusFTPPublisher was obsoleted by CurrentBuildStatusFTPListener");
    }

    public void setFile(String fileName) {
        this.fileName = fileName;
    }

    public void setDestDir(String dir) {
        this.destdir = dir;
    }

    public void validate() throws CruiseControlException {
        ValidationHelper.assertIsSet((Object)this.fileName, "file", this.getClass());
        ValidationHelper.assertIsSet((Object)this.destdir, "destdir", this.getClass());
        super.validate();
    }

    public void publish(Element cruisecontrolLog) throws CruiseControlException {
        String out = this.makeFile(cruisecontrolLog);
        String fname = this.destdir + File.separator + this.fileName;
        this.sendFileToFTPPath(out, fname);
    }

    protected String makeFile(Element cruisecontrolLog) throws CruiseControlException {
        XMLLogHelper helper = new XMLLogHelper(cruisecontrolLog);
        long interval = Long.parseLong(helper.getCruiseControlInfoProperty("interval"));
        this.writeFile(new Date(), interval);
        try {
            return Util.readFileToString(this.fileName);
        }
        catch (IOException ioe) {
            throw new CruiseControlException(ioe.getMessage());
        }
    }

    protected void writeFile(Date date, long interval) throws CruiseControlException {
        Date datePlusInterval = new Date(date.getTime() + interval * 1000L);
        CurrentBuildFileWriter.writefile("Next Build Starts At:\n", datePlusInterval, this.fileName);
    }
}

