/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.publishers;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Publisher;
import net.sourceforge.cruisecontrol.util.ManagedCommandline;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import net.sourceforge.cruisecontrol.util.XMLLogHelper;
import org.apache.log4j.Logger;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Element;

public class ClearCaseBaselinePublisher
implements Publisher {
    private boolean full = false;
    private String baselineprefix;
    private String viewtag;
    private String component;
    private static final Logger LOG = Logger.getLogger(ClearCaseBaselinePublisher.class);

    public void setBaselineprefix(String baselineprefix) {
        this.baselineprefix = baselineprefix;
    }

    public String getBaselineprefix() {
        return this.baselineprefix;
    }

    public void setViewtag(String viewtag) {
        this.viewtag = viewtag;
    }

    public String getViewtag() {
        return this.viewtag;
    }

    public void setFull(boolean full) {
        this.full = full;
    }

    public boolean getFull() {
        return this.full;
    }

    public void setComponent(String comp) {
        this.component = comp;
    }

    public String getComponent() {
        return this.component;
    }

    public void validate() throws CruiseControlException {
        ValidationHelper.assertIsSet((Object)this.viewtag, "viewtag", this.getClass());
    }

    public List getActivities(Element log) {
        Element modifications;
        ArrayList<String> activityList = new ArrayList<String>();
        if (log != null && (modifications = log.getChild("modifications")) != null) {
            for (Element modification : modifications.getChildren("modification")) {
                String activity;
                String type = modification.getAttributeValue("type");
                if (type == null || !type.equals("activity") || (activity = modification.getChild("revision").getText()) == null) continue;
                activityList.add(activity.trim());
            }
        }
        return activityList;
    }

    public boolean shouldPublish(Element log) {
        List newActivities = this.getActivities(log);
        if (newActivities.size() < 1) {
            LOG.info((Object)"No UCM activities in build. Skipping publisher.");
            return false;
        }
        return true;
    }

    public void publish(Element log) throws CruiseControlException {
        XMLLogHelper helper = new XMLLogHelper(log);
        if (!this.shouldPublish(log)) {
            return;
        }
        String baselinename = this.getBaselineprefix() != null ? this.getBaselineprefix() + helper.getLabel() : helper.getLabel();
        ManagedCommandline cmd = new ManagedCommandline();
        cmd.setExecutable("cleartool");
        cmd.createArgument("mkbl");
        cmd.createArguments("-view", this.getViewtag());
        if (this.getFull()) {
            cmd.createArgument("-full");
        }
        if (this.getComponent() != null) {
            cmd.createArguments("-component", this.getComponent());
        }
        cmd.createArgument(baselinename);
        try {
            cmd.execute();
            cmd.assertExitCode(0);
        }
        catch (Exception e) {
            StringBuffer error = new StringBuffer("Failed to create baseline: ");
            error.append(baselinename);
            throw new CruiseControlException(error.toString(), e);
        }
        StringBuffer message = new StringBuffer("Created baseline: ");
        message.append(baselinename);
        LOG.info((Object)message.toString());
    }

    public static void main(String[] args) {
        Element logElement = new Element("cruisecontrol");
        Element mods = new Element("modifications");
        logElement.addContent((Content)mods);
        Element mod = new Element("modification");
        mod.setAttribute("type", "activity");
        mods.addContent((Content)mod);
        Element rev = new Element("revision");
        rev.addContent((Content)new CDATA("Some activitiy"));
        mod.addContent((Content)rev);
        Element info = new Element("info");
        logElement.addContent((Content)info);
        Element prop = new Element("property");
        prop.setAttribute("name", "label");
        prop.setAttribute("value", "1_TST");
        info.addContent((Content)prop);
        ClearCaseBaselinePublisher baseline = new ClearCaseBaselinePublisher();
        baseline.setViewtag("RatlBankModel_int");
        try {
            baseline.publish(logElement);
        }
        catch (CruiseControlException ex) {
            ex.printStackTrace();
        }
    }
}

