/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.publishers;

import java.io.File;
import java.io.IOException;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Publisher;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import net.sourceforge.cruisecontrol.util.XMLLogHelper;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.Move;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.FileUtils;
import org.jdom.Element;

public class ArtifactsPublisher
implements Publisher {
    private String destDir;
    private String targetDirectory;
    private String targetFile;
    private String subdirectory;
    private boolean moveInsteadOfCopy = false;
    private boolean publishOnFailure = true;

    public void setDest(String dir) {
        this.destDir = dir;
    }

    public void setDir(String pDir) {
        this.targetDirectory = pDir;
    }

    public void setFile(String file) {
        this.targetFile = file;
    }

    public void setPublishOnFailure(boolean shouldPublish) {
        this.publishOnFailure = shouldPublish;
    }

    public void publish(Element cruisecontrolLog) throws CruiseControlException {
        XMLLogHelper helper = new XMLLogHelper(cruisecontrolLog);
        if (this.shouldPublish(helper.isBuildSuccessful())) {
            Project project = new Project();
            String timestamp = helper.getBuildTimestamp();
            File destinationDirectory = this.getDestinationDirectory(timestamp);
            if (this.targetDirectory != null) {
                this.publishDirectory(project, destinationDirectory);
            }
            if (this.targetFile != null) {
                this.publishFile(destinationDirectory);
            }
        }
    }

    protected boolean shouldPublish(boolean buildSuccessful) {
        return buildSuccessful || this.publishOnFailure;
    }

    File getDestinationDirectory(String timestamp) {
        String targetDir = timestamp;
        if (this.subdirectory != null) {
            targetDir = timestamp + File.separatorChar + this.subdirectory;
        }
        return new File(this.destDir, targetDir);
    }

    void publishFile(File uniqueDest) throws CruiseControlException {
        File file = new File(this.targetFile);
        if (!file.exists()) {
            throw new CruiseControlException("target file " + file.getAbsolutePath() + " does not exist");
        }
        FileUtils utils = FileUtils.getFileUtils();
        try {
            utils.copyFile(file, new File(uniqueDest, file.getName()));
            if (this.moveInsteadOfCopy) {
                FileUtils.delete((File)file);
            }
        }
        catch (IOException e) {
            throw new CruiseControlException(e);
        }
    }

    void publishDirectory(Project project, File uniqueDest) throws CruiseControlException {
        File directory = new File(this.targetDirectory);
        if (!directory.exists()) {
            throw new CruiseControlException("target directory " + directory.getAbsolutePath() + " does not exist");
        }
        if (!directory.isDirectory()) {
            throw new CruiseControlException("target directory " + directory.getAbsolutePath() + " is not a directory");
        }
        FileSet set = new FileSet();
        set.setDir(directory);
        Copy copier = this.createCopier();
        copier.addFileset(set);
        copier.setTodir(uniqueDest);
        copier.setProject(project);
        try {
            copier.execute();
        }
        catch (Exception e) {
            throw new CruiseControlException(e);
        }
    }

    public void validate() throws CruiseControlException {
        ValidationHelper.assertIsSet((Object)this.destDir, "dest", this.getClass());
        ValidationHelper.assertFalse(this.targetDirectory == null && this.targetFile == null, "'dir' or 'file' must be specified in configuration file.");
        ValidationHelper.assertFalse(this.targetDirectory != null && this.targetFile != null, "only one of 'dir' or 'file' may be specified.");
    }

    public void setSubdirectory(String subdir) {
        this.subdirectory = subdir;
    }

    public void setMoveInsteadOfCopy(boolean moveInsteadOfCopy) {
        this.moveInsteadOfCopy = moveInsteadOfCopy;
    }

    public Copy createCopier() {
        return this.moveInsteadOfCopy ? new Move() : new Copy();
    }
}

