/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.logmanipulators;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Log;
import net.sourceforge.cruisecontrol.Manipulator;
import net.sourceforge.cruisecontrol.util.ValidationHelper;

public abstract class BaseManipulator
implements Manipulator {
    private static final Map UNITS;
    private transient Integer unit = null;
    private transient int every = -1;

    protected File[] getRelevantFiles(String logDir, boolean ignoreSuffix) {
        File[] backupFiles = null;
        if (this.every != -1 && this.unit != null) {
            File dir = new File(logDir);
            Calendar cal = Calendar.getInstance();
            cal.add(this.unit, -this.every);
            backupFiles = dir.listFiles(this.getFilenameFilter(cal.getTime(), ignoreSuffix));
        }
        return backupFiles;
    }

    public void validate() throws CruiseControlException {
        ValidationHelper.assertFalse(this.every == -1 || this.unit == null, "BackupEvery and backupUnit must be set");
    }

    public void setEvery(int every) throws CruiseControlException {
        this.every = every;
    }

    public void setUnit(String unit) throws CruiseControlException {
        this.unit = (Integer)UNITS.get(unit.toUpperCase());
    }

    Integer getUnit() {
        return this.unit;
    }

    protected FilenameFilter getFilenameFilter(Date logdate, boolean ignoreSuffix) {
        return new LogfileNameFilter(logdate, ignoreSuffix);
    }

    static {
        HashMap<String, Integer> units = new HashMap<String, Integer>(4, 1.0f);
        units.put("DAY", new Integer(5));
        units.put("WEEK", new Integer(3));
        units.put("MONTH", new Integer(2));
        units.put("YEAR", new Integer(1));
        UNITS = Collections.unmodifiableMap(units);
    }

    private class LogfileNameFilter
    implements FilenameFilter {
        private Date logdate = null;
        private boolean ignoreSuffix = false;

        public LogfileNameFilter(Date logdate, boolean ignoreSuffix) {
            this.logdate = logdate;
            this.ignoreSuffix = ignoreSuffix;
        }

        public boolean accept(File dir, String name) {
            boolean result = name.startsWith("log");
            if (!this.ignoreSuffix) {
                result &= name.endsWith(".xml");
            }
            if (result) {
                try {
                    Date logfileDate = Log.parseDateFromLogFileName(name);
                    result = logfileDate.before(this.logdate);
                }
                catch (Exception e) {
                    result = false;
                }
            }
            return result;
        }
    }
}

