/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.listeners;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Listener;
import net.sourceforge.cruisecontrol.ProjectEvent;
import net.sourceforge.cruisecontrol.ProjectState;
import net.sourceforge.cruisecontrol.listeners.ProjectStateChangedEvent;
import net.sourceforge.cruisecontrol.util.CurrentBuildFileWriter;
import net.sourceforge.cruisecontrol.util.DateUtil;
import net.sourceforge.cruisecontrol.util.IO;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import org.apache.log4j.Logger;

public class CurrentBuildStatusPageListener
implements Listener {
    private static final long serialVersionUID = -2710491917137221293L;
    private static final Logger LOG = Logger.getLogger(CurrentBuildStatusPageListener.class);
    private String dstFileName;
    private File sourceFile = null;
    private List sourceText = new ArrayList();
    private static final String DEFAULT_TEXT = "{Project}: {State.Date} - {State.Name}: {State.Description}";
    private List history = new ArrayList();
    private static final String KEY_PROJECT = "{project}";
    private static final String KEY_NAME = "{state.name}";
    private static final String KEY_DESC = "{state.description}";
    private static final String KEY_DATE = "{state.date}";
    private static final String KEY_DURATION = "{state.duration}";
    private static final String KEY_HISTORY = "{history}";

    public CurrentBuildStatusPageListener() {
        this.sourceText.add(DEFAULT_TEXT);
    }

    public void handleEvent(ProjectEvent event) throws CruiseControlException {
        if (!(event instanceof ProjectStateChangedEvent)) {
            LOG.debug((Object)("ignoring event " + event.getClass().getName() + " for project " + event.getProjectName()));
            return;
        }
        ProjectStateChangedEvent stateChanged = (ProjectStateChangedEvent)event;
        ProjectState newState = stateChanged.getNewState();
        LOG.debug((Object)("updating status to " + newState.getName() + " for project " + stateChanged.getProjectName()));
        HistoryItem hist = new HistoryItem(newState);
        String result = this.substituteText(hist, stateChanged.getProjectName());
        this.history.add(0, hist);
        IO.write(this.dstFileName, result);
    }

    private String substituteText(HistoryItem current, String projectName) {
        StringBuffer result = new StringBuffer();
        for (String src : this.sourceText) {
            if (src.toLowerCase().startsWith(KEY_HISTORY)) {
                src = src.substring(KEY_HISTORY.length());
                Iterator histIter = this.history.iterator();
                long prevtime = current.when;
                while (histIter.hasNext()) {
                    HistoryItem hist = (HistoryItem)histIter.next();
                    result.append(this.substituteItems(src, projectName, hist, prevtime));
                    result.append('\n');
                    prevtime = hist.when;
                }
                continue;
            }
            result.append(this.substituteItems(src, projectName, current, 0L));
            result.append('\n');
        }
        return result.toString();
    }

    private String substituteItems(String src, String projectName, HistoryItem current, long prevtime) {
        int idx;
        StringBuffer result = new StringBuffer();
        while ((idx = src.indexOf(123)) != -1) {
            int skiplen;
            if (idx > 0) {
                result.append(src.substring(0, idx));
            }
            if ((src = src.substring(idx)).toLowerCase().startsWith(KEY_PROJECT)) {
                result.append(projectName);
                skiplen = KEY_PROJECT.length();
            } else if (src.toLowerCase().startsWith(KEY_NAME)) {
                result.append(current.state);
                skiplen = KEY_NAME.length();
            } else if (src.toLowerCase().startsWith(KEY_DESC)) {
                result.append(current.desc);
                skiplen = KEY_DESC.length();
            } else if (src.toLowerCase().startsWith(KEY_DATE)) {
                result.append(DateUtil.formatIso8601(new Date(current.when)));
                skiplen = KEY_DATE.length();
            } else if (src.toLowerCase().startsWith(KEY_DURATION)) {
                result.append(CurrentBuildStatusPageListener.formatDuration(prevtime - current.when));
                skiplen = KEY_DURATION.length();
            } else {
                result.append('{');
                skiplen = 1;
            }
            if (skiplen <= 0) continue;
            src = src.substring(skiplen);
        }
        result.append(src);
        return result.toString();
    }

    public static String formatDuration(long msecs) {
        StringBuffer buf = new StringBuffer();
        long hours = msecs / 3600000L;
        long mins = (msecs %= 3600000L) / 60000L;
        long secs = (msecs %= 60000L) / 1000L;
        msecs %= 1000L;
        if (hours > 0L) {
            buf.append(hours);
            buf.append(':');
        }
        if (mins > 0L || hours > 0L) {
            if (mins < 10L) {
                buf.append('0');
            }
            buf.append(mins);
            buf.append(':');
        }
        if (secs < 10L && (mins > 0L || hours > 0L)) {
            buf.append('0');
        }
        buf.append(secs);
        buf.append('.');
        if (msecs < 100L) {
            buf.append('0');
        }
        if (msecs < 10L) {
            buf.append('0');
        }
        buf.append(msecs);
        return buf.toString();
    }

    public void validate() throws CruiseControlException {
        ValidationHelper.assertIsSet((Object)this.dstFileName, "file", this.getClass());
        CurrentBuildFileWriter.validate(this.dstFileName);
        if (this.sourceFile != null) {
            ValidationHelper.assertTrue(this.sourceFile.exists(), "'sourceFile' does not exist: " + this.sourceFile.getAbsolutePath());
            ValidationHelper.assertTrue(this.sourceFile.isFile(), "'sourceFile' must be a file: " + this.sourceFile.getAbsolutePath());
            this.sourceText = IO.readLines(this.sourceFile);
        }
    }

    public void setFile(String fileName) {
        this.dstFileName = fileName.trim();
        LOG.debug((Object)("set fileName = " + fileName));
    }

    public void setSourceFile(String fileName) {
        this.sourceFile = new File(fileName);
        LOG.debug((Object)("set sourceFile = " + fileName));
    }

    private class HistoryItem
    implements Serializable {
        private static final long serialVersionUID = -5271600385796774883L;
        public String state;
        public String desc;
        public long when;

        public HistoryItem() {
        }

        public HistoryItem(ProjectState projstate) {
            this.state = projstate.getName();
            this.desc = projstate.getDescription();
            this.when = System.currentTimeMillis();
        }
    }
}

