/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.listeners;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Listener;
import net.sourceforge.cruisecontrol.ProjectEvent;
import net.sourceforge.cruisecontrol.ProjectState;
import net.sourceforge.cruisecontrol.listeners.ProjectStateChangedEvent;
import net.sourceforge.cruisecontrol.sourcecontrols.CMSynergy;
import net.sourceforge.cruisecontrol.util.ManagedCommandline;
import net.sourceforge.cruisecontrol.util.Util;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import org.apache.log4j.Logger;

public class CMSynergySessionMonitor
implements Listener {
    private static final long serialVersionUID = -9139730492970870720L;
    private static final Logger LOG = Logger.getLogger(CMSynergySessionMonitor.class);
    private File sessionFile;
    private String ccmExe = "ccm";
    private ArrayList sessions = new ArrayList();

    public void setCcmExe(String ccmExe) {
        this.ccmExe = ccmExe;
    }

    public void setSessionFile(String sessionFile) {
        this.sessionFile = new File(sessionFile);
    }

    public CMSynergySession createSession() {
        CMSynergySession session = new CMSynergySession();
        this.sessions.add(session);
        return session;
    }

    private static synchronized void checkSessionFile(File sessionFile) throws CruiseControlException {
        if (!sessionFile.exists()) {
            try {
                if (sessionFile.createNewFile()) {
                    LOG.info((Object)("Created CM Synergy session file at " + sessionFile.getAbsolutePath()));
                }
            }
            catch (IOException e) {
                throw new CruiseControlException("Could not create CM Synergy session file at " + sessionFile.getAbsolutePath(), e);
            }
        }
        if (!sessionFile.canWrite()) {
            throw new CruiseControlException("Session file \"" + sessionFile.getAbsolutePath() + "\" does not exist, or is not writable.");
        }
    }

    private static synchronized void checkSessions(String ccmExe, File sessionFile, List sessions) throws CruiseControlException {
        String availableSessions;
        Properties sessionMap;
        LOG.debug((Object)("Using persisted data from " + sessionFile.getAbsolutePath()));
        try {
            sessionMap = Util.loadPropertiesFromFile(sessionFile);
        }
        catch (IOException e) {
            throw new CruiseControlException(e);
        }
        ManagedCommandline cmd = new ManagedCommandline(ccmExe);
        cmd.createArgument("status");
        try {
            cmd.execute();
            cmd.assertExitCode(0);
            availableSessions = cmd.getStdoutAsString();
        }
        catch (Exception e) {
            LOG.warn((Object)"CM Synergy failed to provide a list of valid sessions.", (Throwable)e);
            availableSessions = "";
        }
        for (CMSynergySession session : sessions) {
            String name = session.getName();
            String id = sessionMap.getProperty(name);
            LOG.info((Object)("Checking " + name + "."));
            if (id == null || availableSessions.indexOf(id) < 0) {
                String newID = CMSynergySessionMonitor.startSession(ccmExe, session);
                if (newID == null) continue;
                LOG.info((Object)("Started CM Synergy session \"" + newID + "\"."));
                sessionMap.setProperty(name, newID);
                continue;
            }
            LOG.info((Object)("Using existing session \"" + id + "\"."));
        }
        try {
            Util.storePropertiesToFile(sessionMap, "CM Synergy session map", sessionFile);
        }
        catch (IOException e) {
            throw new CruiseControlException(e);
        }
    }

    private static String startSession(String ccmExe, CMSynergySession session) {
        LOG.info((Object)("Starting a new CM Synergy session for \"" + session.getName() + "\"."));
        ManagedCommandline cmd = new ManagedCommandline(ccmExe);
        cmd.createArgument("start");
        cmd.createArgument("-q");
        cmd.createArgument("-nogui");
        cmd.createArgument("-m");
        cmd.createArguments("-d", session.getDatabase());
        cmd.createArguments("-r", session.getRole());
        cmd.createArguments("-n", session.getUser());
        cmd.createArguments("-pw", session.getPassword());
        if (session.getHost() != null) {
            cmd.createArguments("-h", session.getHost());
        }
        try {
            cmd.execute();
            cmd.assertExitCode(0);
        }
        catch (Exception e) {
            LOG.error((Object)("Could not start a CM Synergy session for " + session.getName()), (Throwable)e);
            return null;
        }
        return cmd.getStdoutAsString().trim();
    }

    public void handleEvent(ProjectEvent event) throws CruiseControlException {
        ProjectStateChangedEvent stateChanged;
        if (event instanceof ProjectStateChangedEvent && (stateChanged = (ProjectStateChangedEvent)event).getNewState().getCode() == ProjectState.BOOTSTRAPPING.getCode()) {
            CMSynergySessionMonitor.checkSessionFile(this.sessionFile);
            CMSynergySessionMonitor.checkSessions(this.ccmExe, this.sessionFile, this.sessions);
        }
    }

    public void validate() throws CruiseControlException {
        ValidationHelper.assertTrue(this.sessions.size() > 0, "You must provide at least one nested <session> element.");
        for (CMSynergySession session : this.sessions) {
            session.validate();
        }
        if (this.sessionFile == null) {
            this.sessionFile = new File(CMSynergy.CCM_SESSION_FILE);
        }
    }

    public class CMSynergySession
    implements Serializable {
        private static final long serialVersionUID = -4131028240579472518L;
        private String name;
        private String db;
        private String role;
        private String user;
        private String password;
        private String host;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getRole() {
            return this.role;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public String getUser() {
            return this.user;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public String getDatabase() {
            return this.db;
        }

        public void setDatabase(String db) {
            this.db = db;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public void setAttributeFile(String attributeFile) {
            try {
                Properties properties = Util.loadPropertiesFromFile(new File(attributeFile));
                this.db = properties.getProperty("database");
                this.role = properties.getProperty("role");
                this.user = properties.getProperty("user");
                this.password = properties.getProperty("password");
                this.host = properties.getProperty("host");
            }
            catch (Exception e) {
                LOG.error((Object)("Could not load CM Synergy session properties from file \"" + attributeFile + "\"."), (Throwable)e);
            }
        }

        public void validate() throws CruiseControlException {
            ValidationHelper.assertIsSet((Object)this.name, "name", "the <session> child element");
            ValidationHelper.assertIsSet((Object)this.db, "db", "the <session> child element");
            ValidationHelper.assertIsSet((Object)this.role, "role", "the <session> child element");
            ValidationHelper.assertIsSet((Object)this.user, "user", "the <session> child element");
            ValidationHelper.assertIsSet((Object)this.password, "password", "the <session> child element");
        }
    }
}

