/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.labelincrementers;

import net.sourceforge.cruisecontrol.LabelIncrementer;
import net.sourceforge.cruisecontrol.labelincrementers.DefaultLabelIncrementer;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class FormattedLabelIncrementer
implements LabelIncrementer {
    private static final Logger LOG = Logger.getLogger(DefaultLabelIncrementer.class);
    private boolean preIncrement = false;
    private boolean includePrefix = true;
    private String defaultPrefix = "CC";
    private int defaultBuildNum = 1;
    private String defaultSuffix = "INT";
    private String separator = "_";

    public FormattedLabelIncrementer() {
        this.setSeparator(this.separator);
    }

    public void setSeparator(String newSeparator) {
        this.separator = newSeparator;
    }

    public void setPreBuildIncrementer(boolean preInc) {
        this.preIncrement = preInc;
    }

    public void setPrefix(boolean prefix) {
        this.includePrefix = prefix;
    }

    public String getDefaultLabel() {
        if (this.includePrefix) {
            return this.defaultPrefix + this.separator + this.defaultBuildNum + this.separator + this.defaultSuffix;
        }
        return this.defaultBuildNum + this.separator + this.defaultSuffix;
    }

    public void setDefaultLabel(String label) {
        LOG.debug((Object)("Setting default label: " + label));
        if (this.includePrefix) {
            int separatorIndex = label.lastIndexOf(this.separator);
            this.defaultSuffix = label.substring(separatorIndex + 1, label.length()).toUpperCase();
            this.defaultPrefix = label.substring(0, separatorIndex);
            separatorIndex = this.defaultPrefix.lastIndexOf(this.separator);
            this.defaultBuildNum = Integer.parseInt(this.defaultPrefix.substring(separatorIndex + 1, this.defaultPrefix.length()));
            this.defaultPrefix = this.defaultPrefix.substring(0, separatorIndex).toUpperCase();
        } else {
            this.defaultSuffix = label.substring(label.indexOf(this.separator) + 1, label.length()).toUpperCase();
            this.defaultBuildNum = Integer.parseInt(label.substring(0, label.indexOf(this.separator)));
        }
    }

    public boolean isPreBuildIncrementer() {
        return this.preIncrement;
    }

    public String incrementLabel(String oldLabel, Element buildLog) {
        String newLabel;
        if (this.includePrefix) {
            String prefix1 = oldLabel.substring(0, oldLabel.lastIndexOf(this.separator));
            String prefix2 = prefix1.substring(0, prefix1.lastIndexOf(this.separator));
            String suffix = oldLabel.substring(oldLabel.lastIndexOf(this.separator) + 1, oldLabel.length());
            String buildnum = prefix1.substring(prefix1.lastIndexOf(this.separator) + 1, prefix1.length());
            int i = Integer.parseInt(buildnum);
            newLabel = prefix2.toUpperCase() + this.separator + ++i + this.separator + suffix.toUpperCase();
        } else {
            String suffix = oldLabel.substring(oldLabel.lastIndexOf(this.separator) + 1, oldLabel.length());
            String buildnum = oldLabel.substring(0, oldLabel.indexOf(this.separator));
            int i = Integer.parseInt(buildnum);
            newLabel = ++i + this.separator + suffix.toUpperCase();
        }
        LOG.debug((Object)("Incrementing label: " + oldLabel + " -> " + newLabel));
        return newLabel;
    }

    public boolean isValidLabel(String label) {
        if (label.indexOf(this.separator) < 0) {
            return false;
        }
        try {
            String buildnum;
            String suffix;
            if (this.includePrefix) {
                String prefix1 = label.substring(0, label.lastIndexOf(this.separator));
                suffix = label.substring(label.lastIndexOf(this.separator) + 1, label.length());
                buildnum = prefix1.substring(prefix1.lastIndexOf(this.separator) + 1, prefix1.length());
            } else {
                suffix = label.substring(label.lastIndexOf(this.separator) + 1, label.length());
                buildnum = label.substring(0, label.indexOf(this.separator));
            }
            if (suffix.equals("BLD") || suffix.equals("INT") || suffix.equals("REL")) {
                Integer.parseInt(buildnum);
                return true;
            }
            return false;
        }
        catch (NumberFormatException e) {
            return false;
        }
        catch (StringIndexOutOfBoundsException e) {
            return false;
        }
    }
}

