/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.jmx;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import mx4j.MBeanDescriptionAdapter;

public class ProjectControllerMBeanDescription
extends MBeanDescriptionAdapter {
    private static final Map<String, String> METHOD_DESCRIPTIONS = new HashMap<String, String>();
    private static final Map<String, String> ATTR_DESCRIPTIONS;

    public String getOperationDescription(Method method) {
        String methodName = method.getName();
        if (METHOD_DESCRIPTIONS.containsKey(methodName)) {
            return METHOD_DESCRIPTIONS.get(methodName);
        }
        return super.getOperationDescription(method);
    }

    public String getAttributeDescription(String attr) {
        if (ATTR_DESCRIPTIONS.containsKey(attr)) {
            return ATTR_DESCRIPTIONS.get(attr);
        }
        return super.getAttributeDescription(attr);
    }

    public String getMBeanDescription() {
        return "Controller for a CruiseControl project";
    }

    static {
        METHOD_DESCRIPTIONS.put("pause", "Pauses the project");
        METHOD_DESCRIPTIONS.put("resume", "Resumes the project when it's paused");
        METHOD_DESCRIPTIONS.put("build", "Forces a build of the project");
        METHOD_DESCRIPTIONS.put("buildWithTarget", "Forces a build of the project using the given target");
        METHOD_DESCRIPTIONS.put("serialize", "Persists the state of the project to disk");
        METHOD_DESCRIPTIONS.put("commitMessages", "Gets the commit messages which include the user name and the message.");
        ATTR_DESCRIPTIONS = new HashMap<String, String>();
        ATTR_DESCRIPTIONS.put("ConfigFileName", "The name of the config file this project reads its settings from");
        ATTR_DESCRIPTIONS.put("Label", "The current build label");
        ATTR_DESCRIPTIONS.put("LabelIncrementer", "The classname of the LabelIncrementer used to determine the build label. Changes to this attribute are not persisted");
        ATTR_DESCRIPTIONS.put("LastBuild", "Time of the last build, using the format 'yyyyMMddHHmmss'");
        ATTR_DESCRIPTIONS.put("LastSuccessfulBuild", "Time of the last successful build, using the format 'yyyyMMddHHmmss'");
        ATTR_DESCRIPTIONS.put("LogDir", "The directory where the log files for this project are written to. Changes to this attribute are not persisted");
        ATTR_DESCRIPTIONS.put("ProjectName", "The name of this project");
        ATTR_DESCRIPTIONS.put("BuildInterval", "The build interval in milliseconds. Changes to this attribute are not persisted");
        ATTR_DESCRIPTIONS.put("Status", "The current status of the project");
        ATTR_DESCRIPTIONS.put("Paused", "Indicates if the project is paused");
        ATTR_DESCRIPTIONS.put("BuildStartTime", "Start Time of the last build, using the format 'yyyyMMddHHmmss'");
    }
}

