/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.jmx;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import net.sourceforge.cruisecontrol.BuildOutputLoggerManager;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Modification;
import net.sourceforge.cruisecontrol.ModificationSet;
import net.sourceforge.cruisecontrol.Project;
import net.sourceforge.cruisecontrol.SourceControl;
import net.sourceforge.cruisecontrol.events.BuildProgressEvent;
import net.sourceforge.cruisecontrol.events.BuildProgressListener;
import net.sourceforge.cruisecontrol.events.BuildResultEvent;
import net.sourceforge.cruisecontrol.events.BuildResultListener;
import net.sourceforge.cruisecontrol.jmx.ProjectControllerMBean;
import org.apache.log4j.Logger;

public class ProjectController
extends NotificationBroadcasterSupport
implements ProjectControllerMBean,
BuildProgressListener,
BuildResultListener {
    public static final String OBJECT_NAME_PREFIX = "CruiseControl Project:name=";
    private static final Logger LOG = Logger.getLogger(ProjectController.class);
    private final Project project;
    private static int sequence = 0;
    private static final Object SEQUENCE_LOCK = new Object();

    public ProjectController(Project project) {
        this.project = project;
        project.addBuildProgressListener(this);
        project.addBuildResultListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int nextSequence() {
        Object object = SEQUENCE_LOCK;
        synchronized (object) {
            return ++sequence;
        }
    }

    public void handleBuildProgress(BuildProgressEvent event) {
        this.log("build progress event: " + event.getState().getDescription());
        if (this.checkSourceProject(event.getProject())) {
            Notification notification = new Notification("cruisecontrol.progress.event", this, this.nextSequence());
            notification.setUserData(event.getState().getName());
            this.sendNotification(notification);
        }
    }

    public void handleBuildResult(BuildResultEvent event) {
        this.log("build result event: build " + String.valueOf(event.isBuildSuccessful() ? "successful" : "failed"));
        if (this.checkSourceProject(event.getProject())) {
            Notification notification = new Notification("cruisecontrol.result.event", this, this.nextSequence());
            notification.setUserData(event.isBuildSuccessful() ? Boolean.TRUE : Boolean.FALSE);
            this.sendNotification(notification);
        }
    }

    private boolean checkSourceProject(Project sourceProject) {
        boolean projectsMatch = false;
        if (this.project == sourceProject) {
            projectsMatch = true;
        } else if (sourceProject == null) {
            LOG.warn((Object)"source project was null");
        } else {
            LOG.warn((Object)("source project " + sourceProject.getName() + " didn't match internal project " + this.project.getName()));
        }
        return projectsMatch;
    }

    public void pause() {
        this.log("pausing");
        this.project.setPaused(true);
    }

    public void resume() {
        this.log("resuming");
        this.project.setPaused(false);
    }

    public void build() {
        this.log("forcing build");
        this.project.setBuildForced(true);
    }

    public void buildWithTarget(String buildTarget) {
        this.log("forcing build with target \"" + buildTarget + "\"");
        this.project.forceBuildWithTarget(buildTarget);
    }

    public void serialize() {
        this.log("serializing");
        this.project.serializeProject();
    }

    public boolean isPaused() {
        return this.project.isPaused();
    }

    public void setLabel(String label) {
        this.log("setting label to [" + label + "]");
        this.project.setLabel(label);
    }

    public String getLabel() {
        return this.project.getLabel();
    }

    public void setLastBuild(String date) throws CruiseControlException {
        this.log("setting last build to [" + date + "]");
        this.project.setLastBuild(date);
    }

    public String getLastBuild() {
        return this.project.getLastBuild();
    }

    public boolean isLastBuildSuccessful() {
        return this.project.isLastBuildSuccessful();
    }

    public void setLastSuccessfulBuild(String date) throws CruiseControlException {
        this.log("setting last successful build to [" + date + "]");
        this.project.setLastSuccessfulBuild(date);
    }

    public String getLastSuccessfulBuild() {
        return this.project.getLastSuccessfulBuild();
    }

    public String getBuildStartTime() {
        String buildStartTime = this.project.getBuildStartTime();
        return buildStartTime == null ? "" : buildStartTime;
    }

    public void setLogDir(String logdir) throws CruiseControlException {
        this.log("setting log dir to [" + logdir + "]");
        this.project.getLog().setDir(logdir);
    }

    public String getLogDir() {
        return this.project.getLogDir();
    }

    public void setProjectName(String name) {
        this.log("setting project name to [" + name + "]");
        this.project.setName(name);
    }

    public String getProjectName() {
        return this.project.getName();
    }

    public void setBuildInterval(long buildInterval) {
        this.log("setting build interval to [" + buildInterval + "]");
        this.project.overrideBuildInterval(buildInterval);
    }

    public long getBuildInterval() {
        return this.project.getBuildInterval();
    }

    public String getStatus() {
        return this.project.getStatusWithQueuePosition();
    }

    private void log(String message) {
        LOG.info((Object)(this.project.getName() + " Controller: " + message));
    }

    public void register(MBeanServer server) throws JMException {
        ObjectName projectName = new ObjectName(OBJECT_NAME_PREFIX + this.project.getName());
        try {
            server.unregisterMBean(projectName);
        }
        catch (InstanceNotFoundException noProblem) {
        }
        catch (MBeanRegistrationException mBeanRegistrationException) {
            // empty catch block
        }
        server.registerMBean(this, projectName);
    }

    public String[][] commitMessages() {
        ModificationSet modificationSet = this.project.getProjectConfig().getModificationSet();
        List<SourceControl> sourceControls = modificationSet.getSourceControls();
        Iterator<SourceControl> iterator = sourceControls.iterator();
        ArrayList<Modification> modifications = new ArrayList<Modification>();
        while (iterator.hasNext()) {
            SourceControl sourcecontrol = iterator.next();
            modifications.addAll(sourcecontrol.getModifications(this.project.getLastBuildDate(), new Date()));
        }
        String[][] commitMessages = new String[modifications.size()][];
        for (int i = 0; i < modifications.size(); ++i) {
            Modification modication = (Modification)modifications.get(i);
            commitMessages[i] = new String[2];
            commitMessages[i][0] = modication.userName;
            commitMessages[i][1] = modication.comment;
        }
        return commitMessages;
    }

    public String[] getBuildOutput(Integer firstLine) {
        return BuildOutputLoggerManager.INSTANCE.lookup().retrieveLines(firstLine);
    }
}

