/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.config;

import com.twmacinta.util.MD5OutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import net.sourceforge.cruisecontrol.CruiseControlConfig;
import net.sourceforge.cruisecontrol.CruiseControlController;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.ProjectInterface;
import net.sourceforge.cruisecontrol.config.XmlResolver;
import net.sourceforge.cruisecontrol.util.Util;
import org.apache.log4j.Logger;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public class XMLConfigManager {
    private static final Logger LOG = Logger.getLogger(XMLConfigManager.class);
    private final File configFile;
    private CruiseControlConfig config;
    private String hash;
    private final Resolver resolver = new Resolver();
    private final CruiseControlController controller;

    public XMLConfigManager(File configurationFile) throws CruiseControlException {
        this(configurationFile, null);
    }

    public XMLConfigManager(File file, CruiseControlController controller) throws CruiseControlException {
        this.configFile = file;
        this.controller = controller;
        this.loadConfig(this.configFile);
        this.hash = this.calculateMD5(this.configFile);
    }

    private void loadConfig(File file) throws CruiseControlException {
        LOG.info((Object)("reading settings from config file [" + file.getAbsolutePath() + "]"));
        Element element = Util.loadRootElement(file);
        this.resolver.resetResolvedFiles();
        this.config = new CruiseControlConfig(element, this.resolver, this.controller);
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public CruiseControlConfig getCruiseControlConfig() {
        return this.config;
    }

    public ProjectInterface getProject(String projectName) {
        LOG.info((Object)("using settings from config file [" + this.configFile.getAbsolutePath() + "]"));
        return this.config.getProject(projectName);
    }

    public boolean reloadIfNecessary() throws CruiseControlException {
        boolean fileChanged;
        LOG.debug((Object)("Calculating MD5 [" + this.configFile.getAbsolutePath() + "]"));
        String newHash = this.calculateMD5(this.configFile);
        boolean bl = fileChanged = !newHash.equals(this.hash);
        if (fileChanged) {
            this.loadConfig(this.configFile);
            this.hash = newHash;
        }
        return fileChanged;
    }

    private String calculateMD5(File file) {
        LOG.debug((Object)("Calculating MD5 [" + this.configFile.getAbsolutePath() + "]"));
        String md5 = this.calculatePartialMD5(file);
        Set<File> includedFiles = this.resolver.getResolvedFiles();
        for (File includedFile : includedFiles) {
            md5 = md5 + this.calculatePartialMD5(includedFile);
        }
        return md5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String calculatePartialMD5(File file) {
        String md5 = "";
        try {
            Element element = Util.loadRootElement(file);
            MD5OutputStream stream = new MD5OutputStream((OutputStream)new ByteArrayOutputStream());
            try {
                XMLOutputter outputter = new XMLOutputter();
                outputter.output(element, (OutputStream)stream);
                md5 = stream.getMD5().asHex();
            }
            finally {
                stream.close();
            }
        }
        catch (IOException e) {
            LOG.error((Object)("exception calculating MD5 of config file " + file.getAbsolutePath()), (Throwable)e);
        }
        catch (CruiseControlException e) {
            LOG.error((Object)("exception calculating MD5 of config file " + file.getAbsolutePath()), (Throwable)e);
        }
        return md5;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Resolver
    implements XmlResolver {
        private final Set<File> resolvedFiles = new HashSet<File>();

        Resolver() {
        }

        @Override
        public Element getElement(String path) throws CruiseControlException {
            File file = new File(XMLConfigManager.this.configFile.getParentFile(), path);
            this.resolvedFiles.add(file);
            return Util.loadRootElement(file);
        }

        public Set<File> getResolvedFiles() {
            return this.resolvedFiles;
        }

        public void resetResolvedFiles() {
            this.resolvedFiles.clear();
        }
    }
}

