/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.buildloggers;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Arrays;
import net.sourceforge.cruisecontrol.BuildLogger;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.util.PruneElementFilter;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import org.apache.log4j.Logger;
import org.apache.oro.io.GlobFilenameFilter;
import org.apache.oro.text.MalformedCachePatternException;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.xml.sax.XMLFilter;

public class MergeLogger
implements BuildLogger {
    private static final Logger LOG = Logger.getLogger(MergeLogger.class);
    private String file;
    private String dir;
    private String pattern = "*.xml";
    private GlobFilenameFilter fileNameFilter;
    private boolean removeProperties = true;

    public void setFile(String file) {
        this.file = file;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
        this.fileNameFilter = null;
    }

    public void validate() throws CruiseControlException {
        ValidationHelper.assertFalse(this.file == null && this.dir == null, "one of file or dir are required attributes");
        ValidationHelper.assertFalse(this.file != null && this.dir != null, "only one of file or dir may be specified");
        ValidationHelper.assertFalse(this.dir != null && this.pattern == null, "no file pattern was specified");
        this.compilePattern();
    }

    private void compilePattern() throws CruiseControlException {
        if (this.fileNameFilter == null && this.pattern != null) {
            try {
                this.fileNameFilter = new GlobFilenameFilter(this.pattern);
            }
            catch (MalformedCachePatternException e) {
                ValidationHelper.fail("Invalid filename pattern " + this.pattern, (Exception)((Object)e));
            }
        }
    }

    public void log(Element buildLog) throws CruiseControlException {
        String nextLogFilename = this.file != null ? this.file : this.dir;
        this.mergeFile(new File(nextLogFilename), buildLog);
    }

    private void mergeFile(File nextLogFile, Element buildLog) {
        if (!nextLogFile.exists()) {
            LOG.info((Object)(nextLogFile.toString() + " does not exist. Skipping ..."));
        } else if (nextLogFile.isDirectory()) {
            Object[] children = nextLogFile.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory() || MergeLogger.this.fileNameFilter.accept(file);
                }
            });
            Arrays.sort(children);
            for (int j = 0; j < children.length; ++j) {
                this.mergeFile((File)children[j], buildLog);
            }
        } else if (nextLogFile.isFile()) {
            if (nextLogFile.length() == 0L) {
                LOG.warn((Object)(nextLogFile.toString() + " is empty. Skipping ..."));
            } else {
                Element auxLogElement = this.getElement(nextLogFile);
                if (auxLogElement != null) {
                    buildLog.addContent(auxLogElement.detach());
                }
            }
        } else {
            LOG.warn((Object)(nextLogFile.toString() + " is not a directory or a file. Skipping ..."));
        }
    }

    Element getElement(File xmlFile) {
        try {
            SAXBuilder builder = new SAXBuilder("org.apache.xerces.parsers.SAXParser");
            if (this.removeProperties) {
                builder.setXMLFilter((XMLFilter)new PruneElementFilter("properties"));
            }
            return builder.build(xmlFile).getRootElement();
        }
        catch (JDOMException e) {
            LOG.warn((Object)("Could not read log: " + xmlFile + ".  Skipping..."), (Throwable)e);
        }
        catch (IOException e) {
            LOG.warn((Object)("Could not read log: " + xmlFile + ".  Skipping..."), (Throwable)e);
        }
        return null;
    }

    public void setRemoveProperties(boolean b) {
        this.removeProperties = b;
    }
}

