/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.builders;

import java.io.File;
import java.util.Map;
import net.sourceforge.cruisecontrol.Builder;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Progress;
import net.sourceforge.cruisecontrol.builders.RakeScript;
import net.sourceforge.cruisecontrol.builders.ScriptRunner;
import net.sourceforge.cruisecontrol.util.DateUtil;
import net.sourceforge.cruisecontrol.util.Util;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import org.apache.log4j.Logger;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RakeBuilder
extends Builder {
    private static final Logger LOG = Logger.getLogger(RakeBuilder.class);
    private String workingDir = null;
    private String buildFile = "rakefile.rb";
    private String target = "";
    private long timeout = -1L;
    private boolean wasValidated = false;

    @Override
    public void validate() throws CruiseControlException {
        super.validate();
        ValidationHelper.assertIsSet((Object)this.buildFile, "buildfile", this.getClass());
        ValidationHelper.assertIsSet((Object)this.target, "target", this.getClass());
        this.wasValidated = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element build(Map<String, String> buildProperties, Progress progressIn) throws CruiseControlException {
        if (!this.wasValidated) {
            throw new IllegalStateException("This builder was never validated. The build method should not be getting called.");
        }
        this.validateBuildFileExists();
        Progress progress = this.getShowProgress() ? progressIn : null;
        Element buildLogElement = new Element("build");
        RakeScript script = this.getRakeScript();
        script.setBuildLogHeader(buildLogElement);
        script.setWindows(Util.isWindows());
        script.setBuildFile(this.buildFile);
        script.setTarget(this.target);
        script.setProgress(progress);
        long startTime = System.currentTimeMillis();
        File workDir = this.workingDir != null ? new File(this.workingDir) : null;
        boolean scriptCompleted = new ScriptRunner().runScript(workDir, script, this.timeout);
        long endTime = System.currentTimeMillis();
        if (!scriptCompleted) {
            LOG.warn((Object)("Build timeout timer of " + this.timeout + " seconds has expired"));
            buildLogElement = new Element("build");
            buildLogElement.setAttribute("error", "build timeout");
        } else if (script.getExitCode() != 0) {
            Element element = buildLogElement;
            synchronized (element) {
                buildLogElement.setAttribute("error", "Return code is " + script.getExitCode());
            }
        }
        buildLogElement.setAttribute("time", DateUtil.getDurationAsString(endTime - startTime));
        return buildLogElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element buildWithTarget(Map<String, String> properties, String buildTarget, Progress progress) throws CruiseControlException {
        String origTarget = this.target;
        try {
            this.target = buildTarget;
            Element element = this.build(properties, progress);
            return element;
        }
        finally {
            this.target = origTarget;
        }
    }

    void validateBuildFileExists() throws CruiseControlException {
        File build = new File(this.buildFile);
        if (!build.isAbsolute() && this.workingDir != null) {
            build = new File(this.workingDir, this.buildFile);
        }
        ValidationHelper.assertExists(build, "buildfile", this.getClass());
    }

    public void setWorkingDir(String dir) {
        this.workingDir = dir;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setBuildFile(String buildFile) {
        this.buildFile = buildFile;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    protected RakeScript getRakeScript() {
        return new RakeScript();
    }
}

