/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.builders;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Progress;
import net.sourceforge.cruisecontrol.builders.Script;
import net.sourceforge.cruisecontrol.util.Commandline;
import net.sourceforge.cruisecontrol.util.StreamConsumer;
import org.apache.log4j.Logger;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenScript
implements Script,
StreamConsumer {
    private static final Logger LOG = Logger.getLogger(MavenScript.class);
    private Map<String, String> buildProperties;
    private String goalset;
    private String mavenScript;
    private String projectFile;
    private int exitCode;
    private final Element buildLogElement;
    private Element currentElement = null;
    private final Progress progress;

    public MavenScript(Element buildLogElement, Progress progress) {
        this.buildLogElement = buildLogElement;
        this.progress = progress;
    }

    @Override
    public Commandline buildCommandline() throws CruiseControlException {
        Commandline cmdLine = new Commandline();
        if (this.mavenScript == null) {
            throw new CruiseControlException("Non-script running is not implemented yet.\nAs of 1.0-beta-10 Maven startup mechanism is still changing...");
        }
        cmdLine.setExecutable(this.mavenScript);
        for (String key : this.buildProperties.keySet()) {
            cmdLine.createArgument("-D" + key + "=" + this.buildProperties.get(key));
        }
        if (LOG.isDebugEnabled()) {
            cmdLine.createArgument("-X");
        }
        cmdLine.createArgument("-b");
        if (this.projectFile != null) {
            File pFile = new File(this.projectFile);
            cmdLine.createArguments("-p", pFile.getName());
        }
        if (this.goalset != null) {
            StringTokenizer stok = new StringTokenizer(this.goalset, " \t\r\n");
            while (stok.hasMoreTokens()) {
                cmdLine.createArgument(stok.nextToken());
            }
        }
        if (LOG.isDebugEnabled()) {
            String[] args;
            StringBuilder sb = new StringBuilder();
            sb.append("Executing Command: ");
            for (String arg : args = cmdLine.getCommandline()) {
                sb.append(arg);
                sb.append(" ");
            }
            LOG.debug((Object)sb.toString());
        }
        return cmdLine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void consumeLine(String line) {
        if (line == null || line.length() == 0 || this.buildLogElement == null) {
            return;
        }
        Element element = this.buildLogElement;
        synchronized (element) {
            if (line.startsWith("BUILD FAILED")) {
                this.buildLogElement.setAttribute("error", "BUILD FAILED detected");
            } else if (line.startsWith("org.apache.maven.MavenException")) {
                this.buildLogElement.setAttribute("error", "You have encountered an unknown error running Maven: " + line);
            } else if (line.startsWith("The build cannot continue")) {
                this.buildLogElement.setAttribute("error", "The build cannot continue: Unsatisfied Dependency");
            } else if (line.endsWith(":") && !line.startsWith(" ") && !line.startsWith("\t")) {
                this.makeNewCurrentElement(line.substring(0, line.lastIndexOf(58)));
                return;
            }
            Element msg = new Element("message");
            msg.addContent((Content)new CDATA(line));
            msg.setAttribute("priority", "info");
            if (this.currentElement == null) {
                this.buildLogElement.addContent((Content)msg);
            } else {
                this.currentElement.addContent((Content)msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeNewCurrentElement(String cTask) {
        if (this.buildLogElement == null) {
            return;
        }
        Element element = this.buildLogElement;
        synchronized (element) {
            this.flushCurrentElement();
            this.currentElement = new Element("mavengoal");
            this.currentElement.setAttribute("name", cTask);
            this.currentElement.setAttribute("time", "? seconds");
        }
        if (this.progress != null) {
            this.progress.setValue(cTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushCurrentElement() {
        if (this.buildLogElement == null) {
            return;
        }
        Element element = this.buildLogElement;
        synchronized (element) {
            if (this.currentElement != null) {
                List lst;
                if (this.buildLogElement.getAttribute("error") != null && (lst = this.currentElement.getChildren("message")) != null) {
                    for (Element msg : lst) {
                        msg.setAttribute("priority", "error");
                    }
                }
                this.buildLogElement.addContent((Content)this.currentElement);
            }
            this.currentElement = null;
        }
    }

    public void setBuildProperties(Map<String, String> buildProperties) {
        this.buildProperties = buildProperties;
    }

    public void setGoalset(String goalset) {
        this.goalset = goalset;
    }

    public void setMavenScript(String mavenScript) {
        this.mavenScript = mavenScript;
    }

    public void setProjectFile(String projectFile) {
        this.projectFile = projectFile;
    }

    @Override
    public int getExitCode() {
        return this.exitCode;
    }

    @Override
    public void setExitCode(int exitCode) {
        this.exitCode = exitCode;
    }
}

