/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.builders;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import net.sourceforge.cruisecontrol.Builder;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Progress;
import net.sourceforge.cruisecontrol.builders.MavenScript;
import net.sourceforge.cruisecontrol.builders.ScriptRunner;
import net.sourceforge.cruisecontrol.util.DateUtil;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import org.apache.log4j.Logger;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenBuilder
extends Builder {
    private static final Logger LOG = Logger.getLogger(MavenBuilder.class);
    private String projectFile;
    private String goal;
    private String mavenScript;
    private long timeout = -1L;

    @Override
    public void validate() throws CruiseControlException {
        super.validate();
        ValidationHelper.assertIsSet((Object)this.mavenScript, "mavenScript", this.getClass());
        ValidationHelper.assertIsSet((Object)this.goal, "goal", this.getClass());
        if (this.getGoalSets().isEmpty()) {
            ValidationHelper.assertIsSet(null, "goal", this.getClass());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element build(Map buildProperties, Progress progressIn) throws CruiseControlException {
        Progress progress = this.getShowProgress() ? progressIn : null;
        File ckFile = new File(this.mavenScript);
        ValidationHelper.assertTrue(ckFile.exists(), "Script " + ckFile.getAbsolutePath() + " does not exist");
        ValidationHelper.assertIsSet((Object)this.projectFile, "projectFile", this.getClass());
        ckFile = new File(this.projectFile);
        ValidationHelper.assertTrue(ckFile.exists(), "Project descriptor " + ckFile.getAbsolutePath() + " does not exist");
        File workingDir = new File(this.projectFile).getParentFile();
        long startTime = System.currentTimeMillis();
        Element buildLogElement = new Element("build");
        List<String> runs = this.getGoalSets();
        for (String goalset : runs) {
            MavenScript script = new MavenScript(buildLogElement, progress);
            script.setGoalset(goalset);
            script.setBuildProperties(buildProperties);
            script.setMavenScript(this.mavenScript);
            script.setProjectFile(this.projectFile);
            ScriptRunner scriptRunner = new ScriptRunner();
            boolean scriptCompleted = scriptRunner.runScript(workingDir, script, this.timeout);
            script.flushCurrentElement();
            if (!scriptCompleted) {
                LOG.warn((Object)("Build timeout timer of " + this.timeout + " seconds has expired"));
                buildLogElement = new Element("build");
                buildLogElement.setAttribute("error", "build timeout");
            } else if (script.getExitCode() != 0) {
                Element element = buildLogElement;
                synchronized (element) {
                    buildLogElement.setAttribute("error", "Return code is " + script.getExitCode());
                }
            }
            if (buildLogElement.getAttribute("error") == null) continue;
            break;
        }
        long endTime = System.currentTimeMillis();
        buildLogElement.setAttribute("time", DateUtil.getDurationAsString(endTime - startTime));
        return buildLogElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element buildWithTarget(Map<String, String> properties, String target, Progress progress) throws CruiseControlException {
        String origGoal = this.goal;
        try {
            this.goal = target;
            Element element = this.build((Map)properties, progress);
            return element;
        }
        finally {
            this.goal = origGoal;
        }
    }

    public void setMavenScript(String mavenScript) {
        this.mavenScript = mavenScript;
    }

    public void setGoal(String goal) {
        this.goal = goal;
    }

    public void setProjectFile(String projectFile) {
        this.projectFile = projectFile;
    }

    protected List<String> getGoalSets() {
        ArrayList<String> al = new ArrayList<String>();
        if (this.goal != null) {
            StringTokenizer stok = new StringTokenizer(this.goal, "|");
            while (stok.hasMoreTokens()) {
                String subSet = stok.nextToken().trim();
                if (subSet == null || subSet.length() == 0) continue;
                al.add(subSet);
            }
        }
        return al;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }
}

