/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.builders;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Progress;
import net.sourceforge.cruisecontrol.builders.Maven2Builder;
import net.sourceforge.cruisecontrol.builders.Property;
import net.sourceforge.cruisecontrol.builders.Script;
import net.sourceforge.cruisecontrol.util.Commandline;
import net.sourceforge.cruisecontrol.util.StreamConsumer;
import org.apache.log4j.Logger;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Maven2Script
implements Script,
StreamConsumer {
    private static final String ERROR = "error";
    private static final String SUCCESS = "success";
    private static final Logger LOG = Logger.getLogger(Maven2Script.class);
    private String goalset;
    private String mvn;
    private String pomFile;
    private final String settingsFile;
    private final String flags;
    private final Element buildLogElement;
    private Map<String, String> buildProperties;
    private final String activateProfiles;
    private List<Property> properties;
    private final Progress progress;
    private int exitCode;
    private Element currentElement;

    public Maven2Script(Maven2Builder maven2Builder, Element buildLogElement, String goals, Progress progress) {
        this.buildLogElement = buildLogElement;
        this.mvn = maven2Builder.getMvnScript();
        this.pomFile = maven2Builder.getPomFile();
        this.goalset = goals;
        this.settingsFile = maven2Builder.getSettingsFile();
        this.flags = maven2Builder.getFlags();
        this.activateProfiles = maven2Builder.getActivateProfiles();
        this.progress = progress;
    }

    @Override
    public Commandline buildCommandline() throws CruiseControlException {
        StringTokenizer stok;
        Commandline cmdLine = new Commandline();
        cmdLine.setExecutable(this.mvn);
        cmdLine.createArgument("-B");
        if (LOG.isDebugEnabled()) {
            cmdLine.createArgument("-X");
        }
        if (this.settingsFile != null) {
            cmdLine.createArguments("-s", this.settingsFile);
        }
        if (this.pomFile != null) {
            cmdLine.createArguments("-f", new File(this.pomFile).getName());
        }
        if (this.activateProfiles != null) {
            cmdLine.createArguments("-P", this.activateProfiles);
        }
        if (this.flags != null) {
            stok = new StringTokenizer(this.flags, " \t\r\n");
            while (stok.hasMoreTokens()) {
                cmdLine.createArgument(stok.nextToken());
            }
        }
        if (this.goalset != null) {
            stok = new StringTokenizer(this.goalset, " \t\r\n");
            while (stok.hasMoreTokens()) {
                cmdLine.createArgument(stok.nextToken());
            }
        }
        for (String key : this.buildProperties.keySet()) {
            String value = this.buildProperties.get(key);
            if (value.indexOf(32) == -1) {
                cmdLine.createArgument("-D" + key + "=" + value);
                continue;
            }
            String spacelessValue = value.replace(' ', '_');
            LOG.warn((Object)("Maven2Script altering build property with space. Key:" + key + "; Orig Value:" + value + "; New Value: " + spacelessValue));
            cmdLine.createArgument("-D" + key + "=" + spacelessValue);
        }
        for (Property property : this.properties) {
            cmdLine.createArgument("-D" + property.getName() + "=" + property.getValue());
        }
        if (LOG.isDebugEnabled()) {
            String[] args;
            StringBuilder sb = new StringBuilder();
            sb.append("Executing Command: ");
            for (String arg : args = cmdLine.getCommandline()) {
                sb.append(arg);
                sb.append(" ");
            }
            LOG.debug((Object)sb.toString());
        }
        return cmdLine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void consumeLine(String line) {
        if (line == null || line.length() == 0 || this.buildLogElement == null) {
            return;
        }
        Element element = this.buildLogElement;
        synchronized (element) {
            String infoLine;
            String level;
            if (line.startsWith("[ERROR]")) {
                level = ERROR;
                infoLine = line.substring(line.indexOf(93) + 1).trim();
            } else if (line.startsWith("[INFO]") || line.startsWith("[DEBUG]")) {
                level = "info";
                infoLine = line.substring(line.indexOf(93) + 1).trim();
            } else {
                level = "info";
                infoLine = line;
            }
            if (infoLine.startsWith("BUILD SUCCESSFUL")) {
                this.buildLogElement.setAttribute(SUCCESS, "BUILD SUCCESSFUL detected");
            } else if (infoLine.startsWith("BUILD FAILURE")) {
                this.buildLogElement.setAttribute(ERROR, "BUILD FAILURE detected");
            } else if (infoLine.startsWith("BUILD ERROR")) {
                this.buildLogElement.setAttribute(ERROR, "BUILD ERROR detected");
            } else if (infoLine.startsWith("FATAL ERROR")) {
                this.buildLogElement.setAttribute(ERROR, "FATAL ERROR detected");
            } else if (infoLine.startsWith("[") && infoLine.endsWith("]") && infoLine.indexOf(":") > -1) {
                this.makeNewCurrentElement(infoLine.substring(1, infoLine.length() - 1));
                return;
            }
            Element msg = new Element("message");
            msg.addContent((Content)new CDATA(line));
            msg.setAttribute("priority", level);
            if (this.currentElement == null) {
                this.buildLogElement.addContent((Content)msg);
            } else {
                this.currentElement.addContent((Content)msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeNewCurrentElement(String cTask) {
        if (this.buildLogElement == null) {
            return;
        }
        Element element = this.buildLogElement;
        synchronized (element) {
            this.flushCurrentElement();
            this.currentElement = new Element("mavengoal");
            this.currentElement.setAttribute("name", cTask);
            if (this.progress != null) {
                this.progress.setValue(cTask);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushCurrentElement() {
        if (this.buildLogElement == null) {
            return;
        }
        Element element = this.buildLogElement;
        synchronized (element) {
            if (this.currentElement != null) {
                List lst;
                if (this.buildLogElement.getAttribute(SUCCESS) != null && this.buildLogElement.getAttribute(ERROR) == null) {
                    LOG.debug((Object)"Ok : BUILD SUCCESSFUL");
                } else if (this.buildLogElement.getAttribute(ERROR) != null && (lst = this.currentElement.getChildren("message")) != null) {
                    for (Element msg : lst) {
                        msg.setAttribute("priority", ERROR);
                    }
                }
                this.buildLogElement.addContent((Content)this.currentElement);
                this.currentElement = null;
            }
        }
    }

    public void setBuildProperties(Map<String, String> buildProperties) {
        this.buildProperties = buildProperties;
    }

    public void setGoalset(String goalset) {
        this.goalset = goalset;
    }

    public void setMvnScript(String mvnScript) {
        this.mvn = mvnScript;
    }

    public void setPomFile(String pomFile) {
        this.pomFile = pomFile;
    }

    public void setProperties(List<Property> properties) {
        this.properties = properties;
    }

    @Override
    public int getExitCode() {
        return this.exitCode;
    }

    @Override
    public void setExitCode(int exitCode) {
        this.exitCode = exitCode;
    }
}

