/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.builders;

import java.util.List;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Progress;
import net.sourceforge.cruisecontrol.builders.Script;
import net.sourceforge.cruisecontrol.util.Commandline;
import net.sourceforge.cruisecontrol.util.StreamConsumer;
import org.apache.log4j.Logger;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Element;

public class ExecScript
implements Script,
StreamConsumer {
    private static final Logger LOG = Logger.getLogger(ExecScript.class);
    private String execCommand;
    private String execArgs;
    private String errorStr;
    private Progress progress;
    private int exitCode;
    private boolean foundError = false;
    private Element buildLogElement;
    private Element currentElement = null;

    public Commandline buildCommandline() throws CruiseControlException {
        Commandline cmdLine = new Commandline();
        if (this.execCommand == null) {
            throw new CruiseControlException("no command to be executed");
        }
        cmdLine.setExecutable(this.execCommand);
        if (this.execArgs != null) {
            cmdLine.addArguments(Commandline.translateCommandline(this.execArgs));
        }
        if (LOG.isDebugEnabled()) {
            String[] args;
            StringBuilder sb = new StringBuilder();
            sb.append("Executing Command: ");
            for (String arg : args = cmdLine.getCommandline()) {
                sb.append(arg);
                sb.append(" ");
            }
            LOG.debug((Object)sb.toString());
        }
        return cmdLine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void consumeLine(String line) {
        if (line == null || line.length() == 0 || this.buildLogElement == null) {
            return;
        }
        Element message = null;
        String messageLevel = "info";
        if (this.errorStr != null && line.contains(this.errorStr)) {
            this.foundError = true;
            messageLevel = "error";
            message = this.messageFromLine(line, messageLevel);
        } else {
            message = this.messageFromLine(line, messageLevel);
        }
        Element element = this.buildLogElement;
        synchronized (element) {
            if (this.currentElement == null) {
                this.buildLogElement.addContent((Content)message);
            } else {
                this.currentElement.addContent((Content)message);
            }
        }
        if (this.progress != null) {
            this.progress.setValue(line);
        }
    }

    private Element messageFromLine(String line, String level) {
        Element msg = new Element("message");
        msg.addContent((Content)new CDATA(line));
        msg.setAttribute("priority", level);
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushCurrentElement() {
        if (this.buildLogElement == null) {
            return;
        }
        Element element = this.buildLogElement;
        synchronized (element) {
            if (this.currentElement != null) {
                List lst;
                if (this.buildLogElement.getAttribute("error") != null && (lst = this.currentElement.getChildren("message")) != null) {
                    for (Element msg : lst) {
                        msg.setAttribute("priority", "error");
                    }
                }
                this.buildLogElement.addContent((Content)this.currentElement);
            }
            this.currentElement = null;
        }
    }

    public Element setBuildLogHeader(Element buildLogElement) {
        Element target = new Element("target");
        target.setAttribute("name", "exec");
        buildLogElement.addContent((Content)target);
        Element task = new Element("task");
        task.setAttribute("name", this.execCommand);
        target.addContent((Content)task);
        return task;
    }

    public void setExecArgs(String execArgs) {
        this.execArgs = execArgs;
    }

    public void setExecCommand(String execCommand) {
        this.execCommand = execCommand;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public void setExitCode(int exitCode) {
        this.exitCode = exitCode;
    }

    public void setErrorStr(String errStr) {
        this.errorStr = errStr;
    }

    public void setBuildLogElement(Element buildLogElement) {
        this.buildLogElement = buildLogElement;
    }

    public void setProgress(Progress progress) {
        this.progress = progress;
    }

    public boolean wasError() {
        return this.foundError;
    }
}

