/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.builders;

import java.io.File;
import java.util.Map;
import net.sourceforge.cruisecontrol.Builder;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Progress;
import net.sourceforge.cruisecontrol.builders.ExecScript;
import net.sourceforge.cruisecontrol.builders.ScriptRunner;
import net.sourceforge.cruisecontrol.util.DateUtil;
import net.sourceforge.cruisecontrol.util.Util;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import org.apache.log4j.Logger;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecBuilder
extends Builder {
    private static final Logger LOG = Logger.getLogger(ExecBuilder.class);
    private String command;
    private String args;
    private String workingDir;
    private String errorStr;
    private long timeout = -1L;
    private Element buildLogElement = null;

    @Override
    public void validate() throws CruiseControlException {
        super.validate();
        ValidationHelper.assertIsSet((Object)this.command, "command", this.getClass());
        if (this.workingDir == null) {
            this.workingDir = System.getProperty("java.io.tmpdir");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element build(Map<String, String> buildProperties, Progress progressIn) throws CruiseControlException {
        Progress progress = this.getShowProgress() ? progressIn : null;
        long startTime = System.currentTimeMillis();
        this.buildLogElement = new Element("build");
        ExecScript script = this.createExecScript();
        script.setExecCommand(this.command);
        script.setExecArgs(this.substituteProperties(buildProperties, this.args));
        script.setErrorStr(this.errorStr);
        script.setProgress(progress);
        Element task = script.setBuildLogHeader(this.buildLogElement);
        script.setBuildLogElement(task);
        ScriptRunner scriptRunner = new ScriptRunner();
        boolean scriptCompleted = false;
        boolean scriptIOError = false;
        try {
            scriptCompleted = this.runScript(script, scriptRunner, this.workingDir);
        }
        catch (CruiseControlException ex) {
            LOG.error((Object)("Could not execute command: " + this.command), (Throwable)ex);
            scriptIOError = true;
        }
        long endTime = System.currentTimeMillis();
        this.buildLogElement.setAttribute("time", DateUtil.getDurationAsString(endTime - startTime));
        if (scriptIOError) {
            StringBuffer message = new StringBuffer("Could not execute command: " + this.command);
            if (this.args == null) {
                message.append(" with no arguments");
            } else {
                message.append(" with arguments: ").append(this.args);
            }
            LOG.warn((Object)message.toString());
            Element element = this.buildLogElement;
            synchronized (element) {
                this.buildLogElement.setAttribute("error", "exec error");
                Element msg = new Element("message");
                msg.addContent((Content)new CDATA(message.toString()));
                msg.setAttribute("priority", "error");
                task.addContent((Content)msg);
            }
        }
        if (script.wasError()) {
            Element element = this.buildLogElement;
            synchronized (element) {
                LOG.warn((Object)"Detected error string string in build output");
                this.buildLogElement.setAttribute("error", "error string found");
                Element msg = new Element("message");
                msg.addContent((Content)new CDATA("Detected error string: " + this.errorStr));
                msg.setAttribute("priority", "error");
                task.addContent((Content)msg);
            }
        }
        if (!scriptCompleted) {
            LOG.warn((Object)("Build timeout timer of " + this.timeout + " seconds has expired"));
            Element element = this.buildLogElement;
            synchronized (element) {
                this.buildLogElement.setAttribute("error", "build timeout");
            }
        }
        if (script.getExitCode() != 0) {
            LOG.warn((Object)("Exec return code is " + script.getExitCode()));
            Element element = this.buildLogElement;
            synchronized (element) {
                this.buildLogElement.setAttribute("error", "return code is " + script.getExitCode());
            }
        }
        script.flushCurrentElement();
        return this.buildLogElement;
    }

    protected boolean runScript(ExecScript script, ScriptRunner scriptRunner, String dir) throws CruiseControlException {
        return scriptRunner.runScript(new File(dir), script, this.timeout);
    }

    private String substituteProperties(Map properties, String string) {
        String value = string;
        try {
            value = Util.parsePropertiesInString(properties, string, false);
        }
        catch (CruiseControlException e) {
            LOG.error((Object)("exception substituting properties into arguments: " + string), (Throwable)e);
        }
        return value;
    }

    protected ExecScript createExecScript() {
        return new ExecScript();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element buildWithTarget(Map<String, String> properties, String target, Progress progress) throws CruiseControlException {
        String origArgs = this.args;
        try {
            this.args = target;
            Element element = this.build(properties, progress);
            return element;
        }
        finally {
            this.args = origArgs;
        }
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setCommand(String cmd) {
        this.command = cmd;
    }

    public String getCommand() {
        return this.command;
    }

    public void setArgs(String args) {
        this.args = args;
    }

    public void setErrorStr(String errStr) {
        this.errorStr = errStr;
    }

    public void setWorkingDir(String dir) {
        this.workingDir = dir;
    }

    public String getBuildError() {
        if (this.buildLogElement.getAttribute("error") != null) {
            return this.buildLogElement.getAttribute("error").getValue();
        }
        return "none";
    }
}

