/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.builders;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Progress;
import net.sourceforge.cruisecontrol.builders.AntBuilder;
import net.sourceforge.cruisecontrol.builders.Property;
import net.sourceforge.cruisecontrol.builders.Script;
import net.sourceforge.cruisecontrol.util.Commandline;
import net.sourceforge.cruisecontrol.util.StreamConsumer;
import net.sourceforge.cruisecontrol.util.UtilLocator;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntScript
implements Script,
StreamConsumer {
    private static final Logger LOG = Logger.getLogger(AntScript.class);
    static final String CLASSNAME_DASHBOARD_LISTENER = "net.sourceforge.cruisecontrol.builders.AntOutputLogger";
    static final String CLASSNAME_ANTPROGRESS_LOGGER = "net.sourceforge.cruisecontrol.builders.AntProgressLogger";
    static final String CLASSNAME_ANTPROGRESS_XML_LOGGER = "net.sourceforge.cruisecontrol.builders.AntProgressXmlLogger";
    static final String CLASSNAME_ANTPROGRESS_XML_LISTENER = "net.sourceforge.cruisecontrol.builders.AntProgressXmlListener";
    public static final String LIBNAME_PROGRESS_LOGGER = "cruisecontrol-antprogresslogger.jar";
    static final String MSG_PREFIX_ANT_PROGRESS = "ccAntProgress -- ";
    private Map<String, String> buildProperties;
    private boolean isWindows;
    private String antScript;
    private List<AntBuilder.JVMArg> args;
    private List<AntBuilder.Lib> libs;
    private List<AntBuilder.Listener> listeners;
    private String loggerClassName;
    private boolean isLoggerClassNameSet;
    private boolean showAntOutput;
    private String tempFileName = "log.xml";
    private boolean useScript;
    private boolean useLogger;
    private boolean useQuiet;
    private boolean useDebug;
    private boolean keepGoing;
    private String buildFile = "build.xml";
    private List<Property> properties;
    private String target = "";
    private String systemClassPath;
    private int exitCode;
    private String propertyfile;
    private String progressLoggerLib;
    private Progress progress;
    private static final String MSG_RESOLUTION_PROGRESS_LOGGER_LIB = "\n\tTo enable showAntOutput and/or showProgress, do one of the following: \n\t1. Copy cruisecontrol-antprogresslogger.jar to a directory, and set the full path (including filename) \n\t\tto cruisecontrol-antprogresslogger.jar in config.xml as the value of 'progressLoggerLib' for this <ant> builder. \n\t2. Set showAntOutput=false and/or showProgress=false for this <ant> builder.\n\t3. Copy cruisecontrol-antprogresslogger.jar into your ant/lib directory.\n\tNote: Please report this issue, as not finding this library is most likely a boog.";

    @Override
    public Commandline buildCommandline() throws CruiseControlException {
        Commandline cmdLine = new Commandline();
        if (this.useScript) {
            cmdLine.setExecutable(this.antScript);
        } else {
            if (this.isWindows) {
                cmdLine.setExecutable("java.exe");
            } else {
                cmdLine.setExecutable("java");
            }
            for (AntBuilder.JVMArg jVMArg : this.args) {
                String arg = jVMArg.getArg();
                if (arg == null || arg.length() <= 0) continue;
                cmdLine.createArgument(arg);
            }
            List<String> classpathItems = this.getClasspathItems(this.systemClassPath, this.isWindows);
            String string = this.getAntLauncherJarLocation(this.systemClassPath, classpathItems);
            cmdLine.createArguments("-classpath", string);
            cmdLine.createArgument("org.apache.tools.ant.launch.Launcher");
            cmdLine.createArguments("-lib", this.removeSaxonJars(classpathItems, this.isWindows));
        }
        if (this.progress == null) {
            if (this.useLogger) {
                cmdLine.createArguments("-logger", this.getLoggerClassName());
                cmdLine.createArguments("-logfile", this.tempFileName);
            } else {
                cmdLine.createArguments("-listener", this.getLoggerClassName());
                cmdLine.createArgument("-DXmlLogger.file=" + this.tempFileName);
            }
        } else {
            this.setupResolvedLoggerClassname();
            cmdLine.createArguments("-logger", this.getLoggerClassName());
            if (this.useLogger) {
                cmdLine.createArguments("-listener", CLASSNAME_ANTPROGRESS_XML_LISTENER);
                cmdLine.createArgument("-DXmlLogger.file=" + this.tempFileName);
            } else {
                cmdLine.createArguments("-listener", "org.apache.tools.ant.XmlLogger");
                cmdLine.createArgument("-DXmlLogger.file=" + this.tempFileName);
            }
        }
        if (AntBuilder.shouldAddDashboardLoggerJarToCommandLine(this.showAntOutput, this.useLogger)) {
            cmdLine.createArguments("-listener", CLASSNAME_DASHBOARD_LISTENER);
        }
        if (this.progress != null || AntBuilder.shouldAddDashboardLoggerJarToCommandLine(this.showAntOutput, this.useLogger)) {
            this.setupDefaultProgressLoggerLib();
            cmdLine.createArguments("-lib", this.progressLoggerLib);
        }
        if (this.useDebug) {
            cmdLine.createArgument("-debug");
        } else if (this.useQuiet) {
            cmdLine.createArgument("-quiet");
        }
        if (this.keepGoing) {
            cmdLine.createArgument("-keep-going");
        }
        for (AntBuilder.Lib lib : this.libs) {
            cmdLine.createArguments("-lib", lib.getSearchPath());
        }
        for (AntBuilder.Listener listener : this.listeners) {
            cmdLine.createArguments("-listener", listener.getClassName());
        }
        for (Map.Entry entry : this.buildProperties.entrySet()) {
            String value = (String)entry.getValue();
            if ("".equals(value)) continue;
            cmdLine.createArgument("-D" + entry.getKey() + "=" + value);
        }
        for (Property property : this.properties) {
            cmdLine.createArgument("-D" + property.getName() + "=" + property.getValue());
        }
        if (this.propertyfile != null) {
            cmdLine.createArguments("-propertyfile", this.propertyfile);
        }
        cmdLine.createArguments("-buildfile", this.buildFile);
        StringTokenizer targets = new StringTokenizer(this.target);
        while (targets.hasMoreTokens()) {
            cmdLine.createArgument(targets.nextToken());
        }
        return cmdLine;
    }

    String getAntLauncherJarLocation(String path, boolean isWindows) throws CruiseControlException {
        return this.getAntLauncherJarLocation(path, this.getClasspathItems(path, isWindows));
    }

    private String getAntLauncherJarLocation(String path, List<String> classpathItems) throws CruiseControlException {
        for (String pathElement : classpathItems) {
            if (pathElement.indexOf("ant-launcher") == -1 || !pathElement.endsWith(".jar")) continue;
            return pathElement;
        }
        throw new CruiseControlException("Couldn't find path to ant-launcher jar in this classpath: '" + path + "'");
    }

    List<String> getClasspathItems(String path, boolean isWindows) {
        ArrayList<String> ret = new ArrayList<String>();
        String separator = this.getSeparator(isWindows);
        StringTokenizer pathTokenizer = new StringTokenizer(path, separator);
        while (pathTokenizer.hasMoreTokens()) {
            String pathElement = pathTokenizer.nextToken();
            ret.add(pathElement);
        }
        return ret;
    }

    String removeSaxonJars(List<String> classpathItems, boolean isWindows) {
        StringBuilder path = new StringBuilder();
        String separator = this.getSeparator(isWindows);
        for (String pathElement : classpathItems) {
            File elementFile = new File(pathElement);
            if (elementFile.getName().startsWith("saxon")) continue;
            if (path.length() > 0) {
                path.append(separator);
            }
            path.append(pathElement);
        }
        return path.toString();
    }

    String removeSaxonJars(String path, boolean isWindows) {
        return this.removeSaxonJars(this.getClasspathItems(path, isWindows), isWindows);
    }

    private String getSeparator(boolean isWindows) {
        return isWindows ? ";" : ":";
    }

    void setupResolvedLoggerClassname() {
        if (this.progress != null && !this.isLoggerClassNameSet) {
            this.loggerClassName = this.useLogger ? CLASSNAME_ANTPROGRESS_XML_LOGGER : CLASSNAME_ANTPROGRESS_LOGGER;
        } else if (this.progress != null) {
            LOG.warn((Object)("Ant Progress support is enabled AND loggerClassname is set. Be sure the loggerClassName: " + this.loggerClassName + " is compatible with" + " Ant Progress."));
        }
        LOG.debug((Object)("Using loggerClassName: " + this.loggerClassName));
    }

    public static String findDefaultProgressLoggerLib() throws ProgressLibLocatorException {
        File ccMain = UtilLocator.getClassSource(AntScript.class);
        if (ccMain == null) {
            throw new ProgressLibLocatorException("Could not determine -lib path for progressLoggerLib. (Java 6/Webstart issue?) \n\tTo enable showAntOutput and/or showProgress, do one of the following: \n\t1. Copy cruisecontrol-antprogresslogger.jar to a directory, and set the full path (including filename) \n\t\tto cruisecontrol-antprogresslogger.jar in config.xml as the value of 'progressLoggerLib' for this <ant> builder. \n\t2. Set showAntOutput=false and/or showProgress=false for this <ant> builder.\n\t3. Copy cruisecontrol-antprogresslogger.jar into your ant/lib directory.\n\tNote: Please report this issue, as not finding this library is most likely a boog.");
        }
        String pathToDirContainingCCMainJar = ccMain.isDirectory() ? ccMain.getAbsolutePath() : ccMain.getParentFile().getAbsolutePath();
        File expectedProgressLoggerJar = new File(pathToDirContainingCCMainJar, LIBNAME_PROGRESS_LOGGER);
        if (!expectedProgressLoggerJar.exists()) {
            throw new ProgressLibLocatorException("The progressLoggerLib jar file does not exist where expected: " + expectedProgressLoggerJar.getAbsolutePath() + MSG_RESOLUTION_PROGRESS_LOGGER_LIB);
        }
        String progressLoggerLib = expectedProgressLoggerJar.getAbsolutePath();
        return progressLoggerLib;
    }

    void setupDefaultProgressLoggerLib() throws ProgressLibLocatorException {
        if (this.progressLoggerLib == null) {
            this.progressLoggerLib = AntScript.findDefaultProgressLoggerLib();
            LOG.debug((Object)("Using default progressLoggerLib: " + this.progressLoggerLib));
        }
    }

    @Override
    public void consumeLine(String line) {
        if (this.progress != null && line != null && line.startsWith(MSG_PREFIX_ANT_PROGRESS)) {
            this.progress.setValue(line.substring(MSG_PREFIX_ANT_PROGRESS.length()));
        }
    }

    public void setBuildProperties(Map<String, String> buildProperties) {
        this.buildProperties = buildProperties;
    }

    public String getLoggerClassName() {
        return this.loggerClassName;
    }

    public void setLoggerClassName(String loggerClassName) {
        this.loggerClassName = loggerClassName;
    }

    public void setIsLoggerClassNameSet(boolean isLoggerClassNameSet) {
        this.isLoggerClassNameSet = isLoggerClassNameSet;
    }

    public void setShowAntOutput(boolean showAntOutput) {
        this.showAntOutput = showAntOutput;
    }

    public void setAntScript(String antScript) {
        this.antScript = antScript;
    }

    public void setArgs(List<AntBuilder.JVMArg> args) {
        this.args = args;
    }

    public void setWindows(boolean isWindows) {
        this.isWindows = isWindows;
    }

    public void setBuildFile(String buildFile) {
        this.buildFile = buildFile;
    }

    public void setTempFileName(String tempFileName) {
        this.tempFileName = tempFileName;
    }

    public void setUseDebug(boolean useDebug) {
        this.useDebug = useDebug;
    }

    public void setUseLogger(boolean useLogger) {
        this.useLogger = useLogger;
    }

    public void setUseQuiet(boolean useQuiet) {
        this.useQuiet = useQuiet;
    }

    public void setKeepGoing(boolean keepGoing) {
        this.keepGoing = keepGoing;
    }

    public void setUseScript(boolean useScript) {
        this.useScript = useScript;
    }

    public void setSystemClassPath(String systemClassPath) {
        this.systemClassPath = systemClassPath;
    }

    public void setProperties(List<Property> properties) {
        this.properties = properties;
    }

    public void setLibs(List<AntBuilder.Lib> libs) {
        this.libs = libs;
    }

    public void setListeners(List<AntBuilder.Listener> listeners) {
        this.listeners = listeners;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    @Override
    public int getExitCode() {
        return this.exitCode;
    }

    @Override
    public void setExitCode(int exitCode) {
        this.exitCode = exitCode;
    }

    public void setPropertyFile(String propertyFile) {
        this.propertyfile = propertyFile;
    }

    public void setProgressLoggerLib(String progressLoggerLib) {
        this.progressLoggerLib = progressLoggerLib;
    }

    public void setProgress(Progress progress) {
        this.progress = progress;
    }

    public static final class ProgressLibLocatorException
    extends CruiseControlException {
        private ProgressLibLocatorException(String msg) {
            super(msg);
        }
    }
}

