/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cruisecontrol.builders;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sourceforge.cruisecontrol.BuildOutputLoggerManager;
import net.sourceforge.cruisecontrol.Builder;
import net.sourceforge.cruisecontrol.CruiseControlException;
import net.sourceforge.cruisecontrol.Progress;
import net.sourceforge.cruisecontrol.builders.AntScript;
import net.sourceforge.cruisecontrol.builders.Property;
import net.sourceforge.cruisecontrol.builders.ScriptRunner;
import net.sourceforge.cruisecontrol.util.BuildOutputLogger;
import net.sourceforge.cruisecontrol.util.EmptyElementFilter;
import net.sourceforge.cruisecontrol.util.Util;
import net.sourceforge.cruisecontrol.util.ValidationHelper;
import org.apache.log4j.Logger;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;
import org.xml.sax.helpers.XMLFilterImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntBuilder
extends Builder {
    protected static final String DEFAULT_LOGGER = "org.apache.tools.ant.XmlLogger";
    private static final Logger LOG = Logger.getLogger(AntBuilder.class);
    private String antWorkingDir = null;
    private String buildFile = "build.xml";
    private String target = "";
    private String tempFileName = "log.xml";
    private String antScript;
    private String antHome;
    private boolean useLogger;
    private final List<JVMArg> args = new ArrayList<JVMArg>();
    private final List<Lib> libs = new ArrayList<Lib>();
    private final List<Listener> listeners = new ArrayList<Listener>();
    private final List<Property> properties = new ArrayList<Property>();
    private boolean useDebug = false;
    private boolean useQuiet = false;
    private boolean keepGoing = false;
    private String loggerClassName = "org.apache.tools.ant.XmlLogger";
    private boolean isLoggerClassNameSet;
    private boolean showAntOutput = true;
    private File saveLogDir = null;
    private long timeout = -1L;
    private boolean wasValidated = false;
    private String propertyfile;
    private String progressLoggerLib;

    @Override
    public void validate() throws CruiseControlException {
        super.validate();
        ValidationHelper.assertIsSet((Object)this.buildFile, "buildfile", this.getClass());
        ValidationHelper.assertIsSet((Object)this.target, "target", this.getClass());
        ValidationHelper.assertFalse(this.useDebug && this.useQuiet, "'useDebug' and 'useQuiet' can't be used together");
        if (!this.useLogger && (this.useDebug || this.useQuiet)) {
            LOG.warn((Object)"usedebug and usequiet are ignored if uselogger is not set to 'true'!");
        }
        if (this.saveLogDir != null) {
            ValidationHelper.assertTrue(this.saveLogDir.isDirectory(), "'saveLogDir' must exist and be a directory");
        }
        ValidationHelper.assertFalse(this.antScript != null && this.antHome != null, "'antHome' and 'antscript' cannot both be set");
        if (AntBuilder.shouldAddDashboardLoggerJarToCommandLine(this.showAntOutput, this.useLogger)) {
            if (this.progressLoggerLib == null) {
                AntScript.findDefaultProgressLoggerLib();
            } else {
                ValidationHelper.assertExists(new File(this.progressLoggerLib), "progressLoggerLib", this.getClass());
            }
        }
        if (this.antHome != null) {
            File antHomeFile = new File(this.antHome);
            ValidationHelper.assertTrue(antHomeFile.exists() && antHomeFile.isDirectory(), "'antHome' must exist and be a directory. Expected to find " + antHomeFile.getAbsolutePath());
            File antScriptInAntHome = new File(this.findAntScript(Util.isWindows()));
            ValidationHelper.assertTrue(antScriptInAntHome.exists() && antScriptInAntHome.isFile(), "'antHome' must contain an ant execution script. Expected to find " + antScriptInAntHome.getAbsolutePath());
            this.antScript = antScriptInAntHome.getAbsolutePath();
        }
        if (this.antScript != null && !this.args.isEmpty()) {
            LOG.warn((Object)"jvmargs will be ignored if you specify anthome or your own antscript!");
        }
        this.wasValidated = true;
    }

    @Override
    public Element build(Map<String, String> buildProperties, Progress progressIn) throws CruiseControlException {
        Element buildLogElement;
        BuildOutputLogger buildOutputConsumer;
        File workingDir;
        if (!this.wasValidated) {
            throw new IllegalStateException("This builder was never validated. The build method should not be getting called.");
        }
        this.validateBuildFileExists();
        Progress progress = this.getShowProgress() ? progressIn : null;
        AntScript script = new AntScript();
        script.setBuildProperties(buildProperties);
        script.setProperties(this.properties);
        script.setLibs(this.libs);
        script.setListeners(this.listeners);
        script.setUseLogger(this.useLogger);
        script.setUseScript(this.antScript != null);
        script.setWindows(Util.isWindows());
        script.setAntScript(this.antScript);
        script.setArgs(this.args);
        script.setBuildFile(this.buildFile);
        script.setTarget(this.target);
        script.setLoggerClassName(this.loggerClassName);
        script.setIsLoggerClassNameSet(this.isLoggerClassNameSet);
        script.setShowAntOutput(this.showAntOutput);
        script.setTempFileName(this.tempFileName);
        script.setUseDebug(this.useDebug);
        script.setUseQuiet(this.useQuiet);
        script.setKeepGoing(this.keepGoing);
        script.setSystemClassPath(this.getSystemClassPath());
        script.setPropertyFile(this.propertyfile);
        script.setProgressLoggerLib(this.progressLoggerLib);
        script.setProgress(progress);
        File file = workingDir = this.antWorkingDir != null ? new File(this.antWorkingDir) : null;
        if (this.showAntOutput) {
            File antBuilderOutput = new File(workingDir, "antBuilderOutput.log");
            buildOutputConsumer = BuildOutputLoggerManager.INSTANCE.lookupOrCreate(antBuilderOutput);
            buildOutputConsumer.clear();
        } else {
            buildOutputConsumer = null;
        }
        boolean scriptCompleted = this.runScript(script, workingDir, buildOutputConsumer);
        File logFile = new File(this.antWorkingDir, this.tempFileName);
        if (!scriptCompleted) {
            LOG.warn((Object)("Build timeout timer of " + this.timeout + " seconds has expired"));
            buildLogElement = new Element("build");
            buildLogElement.setAttribute("error", "build timeout");
            if (logFile.exists()) {
                try {
                    buildLogElement.setText(Util.readFileToString(logFile));
                }
                catch (IOException likely) {}
            }
        } else {
            buildLogElement = this.getAntLogAsElement(logFile);
            this.saveAntLog(logFile);
            logFile.delete();
        }
        return buildLogElement;
    }

    boolean runScript(AntScript script, File workingDir, BuildOutputLogger outputLogger) throws CruiseControlException {
        return new ScriptRunner().runScript(workingDir, script, this.timeout, outputLogger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element buildWithTarget(Map<String, String> properties, String buildTarget, Progress progress) throws CruiseControlException {
        String origTarget = this.target;
        try {
            this.target = buildTarget;
            Element element = this.build(properties, progress);
            return element;
        }
        finally {
            this.target = origTarget;
        }
    }

    void validateBuildFileExists() throws CruiseControlException {
        File build = new File(this.buildFile);
        if (!build.exists() && !build.isAbsolute() && this.antWorkingDir != null) {
            build = new File(this.antWorkingDir, this.buildFile);
        }
        ValidationHelper.assertExists(build, "buildfile", this.getClass());
    }

    public void setSaveLogDir(String dir) {
        this.saveLogDir = null;
        if (dir != null && !dir.trim().equals("")) {
            this.saveLogDir = new File(dir.trim());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveAntLog(File logFile) {
        if (this.saveLogDir == null) {
            return;
        }
        try {
            File newAntLogFile = new File(this.saveLogDir, this.tempFileName);
            newAntLogFile.createNewFile();
            FileInputStream in = new FileInputStream(logFile);
            try {
                FileOutputStream out = new FileOutputStream(newAntLogFile);
                try {
                    int len;
                    byte[] buf = new byte[1024];
                    while ((len = in.read(buf)) > 0) {
                        out.write(buf, 0, len);
                    }
                }
                finally {
                    out.close();
                }
            }
            finally {
                in.close();
            }
        }
        catch (IOException ioe) {
            LOG.error((Object)ioe);
            LOG.error((Object)("Unable to create file: " + new File(this.saveLogDir, this.tempFileName)));
        }
    }

    public void setAntWorkingDir(String dir) {
        this.antWorkingDir = dir;
    }

    public void setAntScript(String antScript) {
        this.antScript = antScript;
    }

    public void setAntHome(String antHome) {
        this.antHome = antHome;
    }

    protected String findAntScript(boolean isWindows) throws CruiseControlException {
        if (this.antHome == null) {
            throw new CruiseControlException("anthome attribute not set.");
        }
        if (isWindows) {
            return this.antHome + "\\bin\\ant.bat";
        }
        return this.antHome + "/bin/ant";
    }

    public void setTempFile(String tempFileName) {
        this.tempFileName = tempFileName;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setBuildFile(String buildFile) {
        this.buildFile = buildFile;
    }

    public void setUseLogger(boolean useLogger) {
        this.useLogger = useLogger;
    }

    public void setShowAntOutput(boolean showAntOutput) {
        this.showAntOutput = showAntOutput;
    }

    boolean getShowAntOutput() {
        return this.showAntOutput;
    }

    static boolean shouldAddDashboardLoggerJarToCommandLine(boolean showAntOutput, boolean useLogger) {
        return showAntOutput && useLogger;
    }

    public Object createJVMArg() {
        JVMArg arg = new JVMArg();
        this.args.add(arg);
        return arg;
    }

    public Object createLib() {
        Lib lib = new Lib();
        this.libs.add(lib);
        return lib;
    }

    public Object createListener() {
        Listener listener = new Listener();
        this.listeners.add(listener);
        return listener;
    }

    public Property createProperty() {
        Property property = new Property();
        this.properties.add(property);
        return property;
    }

    protected String getSystemClassPath() {
        return System.getProperty("java.class.path");
    }

    protected Element getAntLogAsElement(File file) throws CruiseControlException {
        if (!file.exists()) {
            throw new CruiseControlException("ant logfile " + file.getAbsolutePath() + " does not exist.");
        }
        if (file.length() == 0L) {
            throw new CruiseControlException("ant logfile " + file.getAbsolutePath() + " is empty. Your build probably failed. Check your CruiseControl logs.");
        }
        try {
            SAXBuilder builder = new SAXBuilder("org.apache.xerces.parsers.SAXParser");
            XMLFilterImpl piFilter = new XMLFilterImpl(){

                public void processingInstruction(String target, String data) throws SAXException {
                    if (target.equals("xml:stylesheet")) {
                        target = "xml-stylesheet";
                    }
                    super.processingInstruction(target, data);
                }
            };
            EmptyElementFilter emptyTaskFilter = new EmptyElementFilter("task");
            emptyTaskFilter.setParent(piFilter);
            EmptyElementFilter emptyMessageFilter = new EmptyElementFilter("message");
            emptyMessageFilter.setParent(emptyTaskFilter);
            builder.setXMLFilter((XMLFilter)emptyMessageFilter);
            return builder.build(file).getRootElement();
        }
        catch (Exception ee) {
            if (ee instanceof CruiseControlException) {
                throw (CruiseControlException)ee;
            }
            File saveFile = new File(file.getParentFile(), System.currentTimeMillis() + file.getName());
            file.renameTo(saveFile);
            throw new CruiseControlException("Error reading : " + file.getAbsolutePath() + ".  Saved as : " + saveFile.getAbsolutePath(), ee);
        }
    }

    public void setUseDebug(boolean debug) {
        this.useDebug = debug;
    }

    public void setUseQuiet(boolean quiet) {
        this.useQuiet = quiet;
    }

    public void setKeepGoing(boolean keepGoing) {
        this.keepGoing = keepGoing;
    }

    public String getLoggerClassName() {
        return this.loggerClassName;
    }

    public void setLoggerClassName(String string) {
        this.loggerClassName = string;
        this.isLoggerClassNameSet = true;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setPropertyfile(String propertyfile) {
        this.propertyfile = propertyfile;
    }

    public void setProgressLoggerLib(String progressLoggerLib) {
        this.progressLoggerLib = progressLoggerLib;
    }

    public String getProgressLoggerLib() {
        return this.progressLoggerLib;
    }

    public class Listener
    implements Serializable {
        private static final long serialVersionUID = 4813682685614734386L;
        private String className;

        public void setClassName(String className) {
            this.className = className;
        }

        public String getClassName() {
            return this.className;
        }
    }

    public class Lib
    implements Serializable {
        private static final long serialVersionUID = 1804469347425625224L;
        private String searchPath;

        public void setSearchPath(String searchPath) {
            this.searchPath = searchPath;
        }

        public String getSearchPath() {
            return this.searchPath;
        }
    }

    public class JVMArg
    implements Serializable {
        private static final long serialVersionUID = 402625457108399047L;
        private String arg;

        public void setArg(String arg) {
            this.arg = arg;
        }

        public String getArg() {
            return this.arg;
        }
    }
}

